/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import com.google.common.collect.Lists;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.Model;
import org.apache.mahout.clustering.ModelDistribution;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.dirichlet.DirichletDriver;
import org.apache.mahout.clustering.dirichlet.models.DistributionDescription;
import org.apache.mahout.clustering.dirichlet.models.GaussianClusterDistribution;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.iterator.ClusterIterator;
import org.apache.mahout.clustering.iterator.ClusteringPolicy;
import org.apache.mahout.clustering.iterator.DirichletClusteringPolicy;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class DisplayDirichlet
extends DisplayClustering {
    public DisplayDirichlet() {
        this.initialize();
        this.setTitle("Dirichlet Process Clusters - Normal Distribution (>" + (int)(significance * 100.0) + "% of population)");
    }

    @Override
    public void paint(Graphics g) {
        DisplayDirichlet.plotSampleData((Graphics2D)g);
        DisplayDirichlet.plotClusters((Graphics2D)g);
    }

    protected static void generateResults(Path input, Path output, ModelDistribution<VectorWritable> modelDist, int numClusters, int numIterations, double alpha0, int thin, int burnin) throws IOException, ClassNotFoundException, InterruptedException {
        boolean runClusterer = true;
        if (runClusterer) {
            DisplayDirichlet.runSequentialDirichletClusterer(input, output, modelDist, numClusters, numIterations, alpha0);
        } else {
            DisplayDirichlet.runSequentialDirichletClassifier(input, output, modelDist, numClusters, numIterations, alpha0);
        }
        for (int i = 1; i <= numIterations; ++i) {
            ClusterClassifier posterior = new ClusterClassifier();
            String name = i == numIterations ? "clusters-" + i + "-final" : "clusters-" + i;
            posterior.readFromSeqFiles(new Configuration(), new Path(output, name));
            ArrayList clusters = Lists.newArrayList();
            for (Cluster cluster : posterior.getModels()) {
                if (!DisplayDirichlet.isSignificant(cluster)) continue;
                clusters.add(cluster);
            }
            CLUSTERS.add(clusters);
        }
    }

    private static void runSequentialDirichletClassifier(Path input, Path output, ModelDistribution<VectorWritable> modelDist, int numClusters, int numIterations, double alpha0) throws IOException {
        ArrayList models = Lists.newArrayList();
        for (Model cluster : modelDist.sampleFromPrior(numClusters)) {
            models.add((Cluster)cluster);
        }
        ClusterClassifier prior = new ClusterClassifier((List)models, (ClusteringPolicy)new DirichletClusteringPolicy(numClusters, alpha0));
        Path priorPath = new Path(output, "clusters-0");
        prior.writeToSeqFiles(priorPath);
        Configuration conf = new Configuration();
        ClusterIterator.iterateSeq((Configuration)conf, (Path)input, (Path)priorPath, (Path)output, (int)numIterations);
    }

    private static void runSequentialDirichletClusterer(Path input, Path output, ModelDistribution<VectorWritable> modelDist, int numClusters, int numIterations, double alpha0) throws IOException, ClassNotFoundException, InterruptedException {
        DistributionDescription description = new DistributionDescription(modelDist.getClass().getName(), RandomAccessSparseVector.class.getName(), ManhattanDistanceMeasure.class.getName(), 2);
        DirichletDriver.run((Configuration)new Configuration(), (Path)input, (Path)output, (DistributionDescription)description, (int)numClusters, (int)numIterations, (double)alpha0, (boolean)true, (boolean)true, (double)0.0, (boolean)true);
    }

    public static void main(String[] args) throws Exception {
        VectorWritable modelPrototype = new VectorWritable((Vector)new DenseVector(2));
        GaussianClusterDistribution modelDist = new GaussianClusterDistribution(modelPrototype);
        Configuration conf = new Configuration();
        Path output = new Path("output");
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        Path samples = new Path("samples");
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{samples});
        RandomUtils.useTestSeed();
        DisplayDirichlet.generateSamples();
        DisplayDirichlet.writeSampleData(samples);
        int numIterations = 20;
        int numClusters = 10;
        boolean alpha0 = true;
        int thin = 3;
        int burnin = 5;
        DisplayDirichlet.generateResults(samples, output, (ModelDistribution<VectorWritable>)modelDist, numClusters, numIterations, (double)alpha0, thin, burnin);
        new DisplayDirichlet();
    }
}

