/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import com.google.common.collect.Lists;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansDriver;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.clustering.iterator.ClusterIterator;
import org.apache.mahout.clustering.iterator.ClusteringPolicy;
import org.apache.mahout.clustering.iterator.FuzzyKMeansClusteringPolicy;
import org.apache.mahout.clustering.kmeans.RandomSeedGenerator;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class DisplayFuzzyKMeans
extends DisplayClustering {
    DisplayFuzzyKMeans() {
        this.initialize();
        this.setTitle("Fuzzy k-Means Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    @Override
    public void paint(Graphics g) {
        DisplayFuzzyKMeans.plotSampleData((Graphics2D)g);
        DisplayFuzzyKMeans.plotClusters((Graphics2D)g);
    }

    public static void main(String[] args) throws Exception {
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        Path samples = new Path("samples");
        Path output = new Path("output");
        Configuration conf = new Configuration();
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{samples});
        RandomUtils.useTestSeed();
        DisplayClustering.generateSamples();
        DisplayFuzzyKMeans.writeSampleData(samples);
        boolean runClusterer = true;
        int maxIterations = 10;
        float threshold = 0.001f;
        float m = 1.1f;
        if (runClusterer) {
            DisplayFuzzyKMeans.runSequentialFuzzyKClusterer(conf, samples, output, (DistanceMeasure)measure, maxIterations, m, threshold);
        } else {
            int numClusters = 3;
            DisplayFuzzyKMeans.runSequentialFuzzyKClassifier(conf, samples, output, (DistanceMeasure)measure, numClusters, maxIterations, m, threshold);
        }
        new DisplayFuzzyKMeans();
    }

    private static void runSequentialFuzzyKClassifier(Configuration conf, Path samples, Path output, DistanceMeasure measure, int numClusters, int maxIterations, float m, double threshold) throws IOException {
        ArrayList points = Lists.newArrayList();
        for (int i = 0; i < numClusters; ++i) {
            points.add(((VectorWritable)SAMPLE_DATA.get(i)).get());
        }
        ArrayList initialClusters = Lists.newArrayList();
        int id = 0;
        for (Vector point : points) {
            initialClusters.add(new SoftCluster(point, id++, measure));
        }
        ClusterClassifier prior = new ClusterClassifier((List)initialClusters, (ClusteringPolicy)new FuzzyKMeansClusteringPolicy((double)m, threshold));
        Path priorPath = new Path(output, "classifier-0");
        prior.writeToSeqFiles(priorPath);
        ClusterIterator.iterateSeq((Configuration)conf, (Path)samples, (Path)priorPath, (Path)output, (int)maxIterations);
        DisplayFuzzyKMeans.loadClustersWritable(output);
    }

    private static void runSequentialFuzzyKClusterer(Configuration conf, Path samples, Path output, DistanceMeasure measure, int maxIterations, float m, double threshold) throws IOException, ClassNotFoundException, InterruptedException {
        Path clustersIn = new Path(output, "random-seeds");
        RandomSeedGenerator.buildRandom((Configuration)conf, (Path)samples, (Path)clustersIn, (int)3, (DistanceMeasure)measure);
        FuzzyKMeansDriver.run((Path)samples, (Path)clustersIn, (Path)output, (DistanceMeasure)measure, (double)threshold, (int)maxIterations, (float)m, (boolean)true, (boolean)true, (double)threshold, (boolean)true);
        DisplayFuzzyKMeans.loadClustersWritable(output);
    }
}

