/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.streaming.tools;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.streaming.mapreduce.CentroidWritable;
import org.apache.mahout.math.Centroid;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class IOUtils {
    private IOUtils() {
    }

    public static Iterable<Centroid> getCentroidsFromCentroidWritableIterable(Iterable<CentroidWritable> dirIterable) {
        return Iterables.transform(dirIterable, (Function)new Function<CentroidWritable, Centroid>(){

            public Centroid apply(CentroidWritable input) {
                Preconditions.checkNotNull((Object)input);
                return input.getCentroid().clone();
            }
        });
    }

    public static Iterable<Centroid> getCentroidsFromClusterWritableIterable(Iterable<ClusterWritable> dirIterable) {
        return Iterables.transform(dirIterable, (Function)new Function<ClusterWritable, Centroid>(){
            int numClusters = 0;

            public Centroid apply(ClusterWritable input) {
                Preconditions.checkNotNull((Object)input);
                return new Centroid(this.numClusters++, input.getValue().getCenter().clone(), (double)input.getValue().getTotalObservations());
            }
        });
    }

    public static Iterable<Vector> getVectorsFromVectorWritableIterable(Iterable<VectorWritable> dirIterable) {
        return Iterables.transform(dirIterable, (Function)new Function<VectorWritable, Vector>(){

            public Vector apply(VectorWritable input) {
                Preconditions.checkNotNull((Object)input);
                return input.get().clone();
            }
        });
    }
}

