/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.utils.ConcatenateVectorsReducer;

public class ConcatenateVectorsJob
extends AbstractJob {
    static final String MATRIXA_DIMS = "mahout.concatenatevectors.matrixA_dims";
    static final String MATRIXB_DIMS = "mahout.concatenatevectors.matrixB_dims";

    private ConcatenateVectorsJob() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new ConcatenateVectorsJob(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.addOption("matrixA", "ma", "A (left) matrix directory", true);
        this.addOption("matrixB", "mb", "B (right) matrix directory", true);
        this.addOutputOption();
        DefaultOptionCreator.overwriteOption().create();
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Path pathA = new Path(this.getOption("matrixA"));
        Path pathB = new Path(this.getOption("matrixB"));
        Path pathOutput = this.getOutputPath();
        Configuration configuration = this.getConf();
        FileSystem fs = FileSystem.get((Configuration)configuration);
        Class<? extends Writable> keyClassA = this.getKeyClass(pathA, fs);
        Class<? extends Writable> keyClassB = this.getKeyClass(pathB, fs);
        Preconditions.checkArgument((boolean)keyClassA.equals(keyClassB), (Object)"All SequenceFiles must use same key class");
        int dimA = this.getDimensions(pathA);
        int dimB = this.getDimensions(pathB);
        String nameA = this.getOption("matrixA");
        String nameB = this.getOption("matrixB");
        Job concatenate = this.prepareJob(new Path(nameA + "," + nameB), pathOutput, Mapper.class, keyClassA, VectorWritable.class, ConcatenateVectorsReducer.class, keyClassA, VectorWritable.class);
        configuration = concatenate.getConfiguration();
        configuration.set(MATRIXA_DIMS, Integer.toString(dimA));
        configuration.set(MATRIXB_DIMS, Integer.toString(dimB));
        boolean succeeded = concatenate.waitForCompletion(true);
        if (!succeeded) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<? extends Writable> getKeyClass(Path path, FileSystem fs) throws IOException {
        Class<Writable> clazz;
        Path pathPattern = new Path(path, "part*");
        FileStatus[] paths = fs.globStatus(pathPattern);
        Preconditions.checkArgument((paths.length == 0 ? 1 : 0) != 0, (Object)(path.getName() + " is a file, should be a directory"));
        Path file = paths[0].getPath();
        SequenceFile.Reader reader = null;
        try {
            reader = new SequenceFile.Reader(fs, file, fs.getConf());
            clazz = reader.getKeyClass().asSubclass(Writable.class);
        }
        catch (Throwable throwable) {
            Closeables.close(reader, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)reader, (boolean)true);
        return clazz;
    }
}

