/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.map.OpenIntDoubleHashMap;

public class RandomAccessSparseVector
extends AbstractVector {
    private static final int INITIAL_CAPACITY = 11;
    private OpenIntDoubleHashMap values;

    public RandomAccessSparseVector() {
        super(0);
    }

    public RandomAccessSparseVector(int cardinality) {
        this(cardinality, Math.min(cardinality, 11));
    }

    public RandomAccessSparseVector(int cardinality, int initialCapacity) {
        super(cardinality);
        this.values = new OpenIntDoubleHashMap(initialCapacity);
    }

    public RandomAccessSparseVector(Vector other) {
        this(other.size(), other.getNumNondefaultElements());
        for (Vector.Element e : other.nonZeroes()) {
            this.values.put(e.index(), e.get());
        }
    }

    private RandomAccessSparseVector(int cardinality, OpenIntDoubleHashMap values) {
        super(cardinality);
        this.values = values;
    }

    public RandomAccessSparseVector(RandomAccessSparseVector other, boolean shallowCopy) {
        super(other.size());
        this.values = shallowCopy ? other.values : (OpenIntDoubleHashMap)other.values.clone();
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return new SparseMatrix(rows, columns);
    }

    @Override
    public RandomAccessSparseVector clone() {
        return new RandomAccessSparseVector(this.size(), (OpenIntDoubleHashMap)this.values.clone());
    }

    @Override
    public String toString() {
        return this.sparseVectorToString();
    }

    @Override
    public Vector assign(Vector other) {
        if (this.size() != other.size()) {
            throw new CardinalityException(this.size(), other.size());
        }
        this.values.clear();
        for (Vector.Element e : other.nonZeroes()) {
            this.setQuick(e.index(), e.get());
        }
        return this;
    }

    @Override
    public void mergeUpdates(OrderedIntDoubleMapping updates) {
        for (int i = 0; i < updates.getNumMappings(); ++i) {
            this.values.put(updates.getIndices()[i], updates.getValues()[i]);
        }
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public double getQuick(int index) {
        return this.values.get(index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.invalidateCachedLength();
        if (value == 0.0) {
            this.values.removeKey(index);
        } else {
            this.values.put(index, value);
        }
    }

    @Override
    public void incrementQuick(int index, double increment) {
        this.invalidateCachedLength();
        this.values.adjustOrPutValue(index, increment, increment);
    }

    @Override
    public RandomAccessSparseVector like() {
        return new RandomAccessSparseVector(this.size(), this.values.size());
    }

    @Override
    public Vector like(int cardinality) {
        return new RandomAccessSparseVector(cardinality, this.values.size());
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.size();
    }

    @Override
    public int getNumNonZeroElements() {
        DoubleArrayList elementValues = this.values.values();
        int numMappedElements = elementValues.size();
        int numNonZeros = 0;
        for (int index = 0; index < numMappedElements; ++index) {
            if (elementValues.getQuick(index) == 0.0) continue;
            ++numNonZeros;
        }
        return numNonZeros;
    }

    @Override
    public double getLookupCost() {
        return 1.0;
    }

    @Override
    public double getIteratorAdvanceCost() {
        return 1.35;
    }

    @Override
    public boolean isAddConstantTime() {
        return true;
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonDefaultIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    private final class RandomAccessElement
    implements Vector.Element {
        int index;

        private RandomAccessElement() {
        }

        @Override
        public double get() {
            return RandomAccessSparseVector.this.values.get(this.index);
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            RandomAccessSparseVector.this.invalidateCachedLength();
            if (value == 0.0) {
                RandomAccessSparseVector.this.values.removeKey(this.index);
            } else {
                RandomAccessSparseVector.this.values.put(this.index, value);
            }
        }
    }

    private final class AllIterator
    implements Iterator<Vector.Element> {
        private final RandomAccessElement element;

        private AllIterator() {
            this.element = new RandomAccessElement();
            this.element.index = -1;
        }

        @Override
        public boolean hasNext() {
            return this.element.index + 1 < RandomAccessSparseVector.this.size();
        }

        @Override
        public Vector.Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.element.index;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class NonDefaultIterator
    implements Iterator<Vector.Element> {
        private OpenIntDoubleHashMap.MapElement mapElement;
        private final NonDefaultElement element = new NonDefaultElement();
        private final Iterator<OpenIntDoubleHashMap.MapElement> iterator;

        private NonDefaultIterator() {
            this.iterator = RandomAccessSparseVector.this.values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Vector.Element next() {
            this.mapElement = this.iterator.next();
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private final class NonDefaultElement
        implements Vector.Element {
            private NonDefaultElement() {
            }

            @Override
            public double get() {
                return NonDefaultIterator.this.mapElement.get();
            }

            @Override
            public int index() {
                return NonDefaultIterator.this.mapElement.index();
            }

            @Override
            public void set(double value) {
                RandomAccessSparseVector.this.invalidateCachedLength();
                NonDefaultIterator.this.mapElement.set(value);
            }
        }
    }
}

