/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer.hebbian;

import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.decomposer.EigenStatus;

public class TrainingState {
    private Matrix currentEigens;
    private int numEigensProcessed;
    private List<Double> currentEigenValues;
    private Matrix trainingProjections;
    private int trainingIndex;
    private Vector helperVector;
    private boolean firstPass;
    private List<EigenStatus> statusProgress;
    private double activationNumerator;
    private double activationDenominatorSquared;

    TrainingState(Matrix eigens, Matrix projections) {
        this.currentEigens = eigens;
        this.trainingProjections = projections;
        this.trainingIndex = 0;
        this.helperVector = new DenseVector(eigens.numRows());
        this.firstPass = true;
        this.statusProgress = new ArrayList<EigenStatus>();
        this.activationNumerator = 0.0;
        this.activationDenominatorSquared = 0.0;
        this.numEigensProcessed = 0;
    }

    public Vector mostRecentEigen() {
        return this.currentEigens.viewRow(this.numEigensProcessed - 1);
    }

    public Vector currentTrainingProjection() {
        if (this.trainingProjections.viewRow(this.trainingIndex) == null) {
            this.trainingProjections.assignRow(this.trainingIndex, new DenseVector(this.currentEigens.numCols()));
        }
        return this.trainingProjections.viewRow(this.trainingIndex);
    }

    public Matrix getCurrentEigens() {
        return this.currentEigens;
    }

    public void setCurrentEigens(Matrix currentEigens) {
        this.currentEigens = currentEigens;
    }

    public int getNumEigensProcessed() {
        return this.numEigensProcessed;
    }

    public void setNumEigensProcessed(int numEigensProcessed) {
        this.numEigensProcessed = numEigensProcessed;
    }

    public List<Double> getCurrentEigenValues() {
        return this.currentEigenValues;
    }

    public void setCurrentEigenValues(List<Double> currentEigenValues) {
        this.currentEigenValues = currentEigenValues;
    }

    public Matrix getTrainingProjections() {
        return this.trainingProjections;
    }

    public void setTrainingProjections(Matrix trainingProjections) {
        this.trainingProjections = trainingProjections;
    }

    public int getTrainingIndex() {
        return this.trainingIndex;
    }

    public void setTrainingIndex(int trainingIndex) {
        this.trainingIndex = trainingIndex;
    }

    public Vector getHelperVector() {
        return this.helperVector;
    }

    public void setHelperVector(Vector helperVector) {
        this.helperVector = helperVector;
    }

    public boolean isFirstPass() {
        return this.firstPass;
    }

    public void setFirstPass(boolean firstPass) {
        this.firstPass = firstPass;
    }

    public List<EigenStatus> getStatusProgress() {
        return this.statusProgress;
    }

    public void setStatusProgress(List<EigenStatus> statusProgress) {
        this.statusProgress = statusProgress;
    }

    public double getActivationNumerator() {
        return this.activationNumerator;
    }

    public void setActivationNumerator(double activationNumerator) {
        this.activationNumerator = activationNumerator;
    }

    public double getActivationDenominatorSquared() {
        return this.activationDenominatorSquared;
    }

    public void setActivationDenominatorSquared(double activationDenominatorSquared) {
        this.activationDenominatorSquared = activationDenominatorSquared;
    }
}

