/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import java.util.Collection;
import org.apache.mahout.math.Arrays;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.AbstractObjectList;

public class ObjectArrayList<T>
extends AbstractObjectList<T> {
    private Object[] elements;
    private int size;

    public ObjectArrayList() {
        this(10);
    }

    public ObjectArrayList(T[] elements) {
        this.elements(elements);
    }

    public ObjectArrayList(int initialCapacity) {
        this.elements = new Object[initialCapacity];
        this.size = 0;
    }

    public void add(T element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    public void beforeInsert(int index, T element) {
        if (this.size == index) {
            this.add(element);
            return;
        }
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public Object clone() {
        return new ObjectArrayList<Object>((Object[])this.elements.clone());
    }

    public ObjectArrayList<T> copy() {
        return (ObjectArrayList)this.clone();
    }

    public <Q> Q[] elements() {
        return this.elements;
    }

    public void elements(T[] elements) {
        this.elements = elements;
        this.size = elements.length;
    }

    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof ObjectArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        ObjectArrayList other = (ObjectArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        Q[] theElements = this.elements();
        Q[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(ObjectProcedure<T> procedure) {
        Object[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    public T get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return (T)this.elements[index];
    }

    public T getQuick(int index) {
        return (T)this.elements[index];
    }

    public int indexOfFromTo(T element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        Object[] theElements = this.elements;
        for (int i = from; i <= to; ++i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfFromTo(T element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        Object[] theElements = this.elements;
        for (int i = to; i >= from; --i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    public AbstractObjectList<T> partFromTo(int from, int to) {
        if (this.size == 0) {
            return new ObjectArrayList<T>(0);
        }
        ObjectArrayList.checkRangeFromTo(from, to, this.size);
        Object[] part = new Object[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new ObjectArrayList<Object>(part);
    }

    @Override
    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        Object[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            Object tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    public void set(int index, T element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    public void setQuick(int index, T element) {
        this.elements[index] = element;
    }

    @Override
    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }

    @Override
    public void removeFromTo(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceFromWith(int from, Collection<T> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void beforeInsertDummies(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mergeSortFromTo(int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void quickSortFromTo(int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }
}

