/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.ByteObjectProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractByteObjectMap<T>
extends AbstractSet {
    public boolean containsKey(final byte key) {
        return !this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final T value) {
        return !this.forEachPair(new ByteObjectProcedure<T>(){

            @Override
            public boolean apply(byte iterKey, Object iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractByteObjectMap<T> copy() {
        return (AbstractByteObjectMap)this.getClass().cast(this.clone());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractByteObjectMap)) {
            return false;
        }
        final AbstractByteObjectMap other = (AbstractByteObjectMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ByteObjectProcedure(){

            public boolean apply(byte key, Object value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ByteObjectProcedure(){

            public boolean apply(byte key, Object value) {
                return AbstractByteObjectMap.this.containsKey(key) && AbstractByteObjectMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new ByteObjectProcedure(){
            int i = 0;

            public boolean apply(byte key, Object value) {
                buf[this.i++] = HashUtils.hash(key) ^ value.hashCode();
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(ByteProcedure var1);

    public boolean forEachPair(final ByteObjectProcedure<T> procedure) {
        return this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                return procedure.apply(key, AbstractByteObjectMap.this.get(key));
            }
        });
    }

    public abstract T get(byte var1);

    public ByteArrayList keys() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(ByteArrayList keyList) {
        this.pairsSortedByValue(keyList, new ArrayList(this.size()));
    }

    public void pairsMatching(final ByteObjectProcedure<T> condition, final ByteArrayList keyList, final List<T> valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ByteObjectProcedure<T>(){

            @Override
            public boolean apply(byte key, T value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(ByteArrayList keyList, List<T> valueList) {
        this.keys(keyList);
        keyList.sort();
        Object[] tempValueList = new Object[keyList.size()];
        int i = keyList.size();
        while (--i >= 0) {
            tempValueList[i] = this.get(keyList.getQuick(i));
        }
        valueList.clear();
        for (Object value : tempValueList) {
            valueList.add(value);
        }
    }

    public void pairsSortedByValue(ByteArrayList keyList, List<T> valueList) {
        this.keys(keyList);
        this.values(valueList);
        if (!valueList.isEmpty() && !(valueList.get(0) instanceof Comparable)) {
            throw new UnsupportedOperationException("Cannot sort the values; " + valueList.get(0).getClass() + " does not implement Comparable");
        }
        final byte[] k = keyList.elements();
        final List<T> valueRef = valueList;
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                Object t1 = valueRef.get(a);
                valueRef.set(a, valueRef.get(b));
                valueRef.set(b, t1);
                byte t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                int ab = ((Comparable)valueRef.get(a)).compareTo(valueRef.get(b));
                return ab < 0 ? -1 : (ab > 0 ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(byte var1, T var2);

    public abstract boolean removeKey(byte var1);

    public String toString() {
        ByteArrayList theKeys = this.keys();
        theKeys.sort();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            byte key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ByteArrayList theKeys = new ByteArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            byte key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public List<T> values() {
        ArrayList list = new ArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final List<T> list) {
        list.clear();
        this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                list.add(AbstractByteObjectMap.this.get(key));
                return true;
            }
        });
    }
}

