/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.SparseColumnMatrix;
import org.apache.mahout.math.UnboundLabelException;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.VectorFunction;
import org.junit.Before;
import org.junit.Test;

public abstract class MatrixTest
extends MahoutTestCase {
    protected static final int ROW = 0;
    protected static final int COL = 1;
    private final double[][] values = new double[][]{{1.1, 2.2}, {3.3, 4.4}, {5.5, 6.6}};
    private final double[] vectorAValues = new double[]{0.9090909090909091, 1.8181818181818181};
    protected Matrix test;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.test = this.matrixFactory(this.values);
    }

    public abstract Matrix matrixFactory(double[][] var1);

    @Test
    public void testCardinality() {
        int[] c = this.test.size();
        MatrixTest.assertEquals((String)"row cardinality", (long)this.values.length, (long)c[0]);
        MatrixTest.assertEquals((String)"col cardinality", (long)this.values[0].length, (long)c[1]);
    }

    @Test
    public void testCopy() {
        int[] c = this.test.size();
        Matrix copy = this.test.clone();
        MatrixTest.assertSame((String)"wrong class", copy.getClass(), this.test.getClass());
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.test.getQuick(row, col), (double)copy.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testIterate() {
        MatrixSlice m;
        Iterator it = this.test.iterator();
        while (it.hasNext() && (m = (MatrixSlice)it.next()) != null) {
            Vector v = m.vector();
            Vector w = this.test instanceof SparseColumnMatrix ? this.test.getColumn(m.index()) : this.test.getRow(m.index());
            MatrixTest.assertEquals((String)("iterator: " + v + ", randomAccess: " + w), (Object)v, (Object)w);
        }
    }

    @Test
    public void testGetQuick() {
        int[] c = this.test.size();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.values[row][col], (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testLike() {
        Matrix like = this.test.like();
        MatrixTest.assertSame((String)"type", like.getClass(), this.test.getClass());
        MatrixTest.assertEquals((String)"rows", (long)this.test.size()[0], (long)like.size()[0]);
        MatrixTest.assertEquals((String)"columns", (long)this.test.size()[1], (long)like.size()[1]);
    }

    @Test
    public void testLikeIntInt() {
        Matrix like = this.test.like(4, 4);
        MatrixTest.assertSame((String)"type", like.getClass(), this.test.getClass());
        MatrixTest.assertEquals((String)"rows", (long)4L, (long)like.size()[0]);
        MatrixTest.assertEquals((String)"columns", (long)4L, (long)like.size()[1]);
    }

    @Test
    public void testSetQuick() {
        int[] c = this.test.size();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                this.test.setQuick(row, col, 1.23);
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)1.23, (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testSize() {
        int[] c = this.test.getNumNondefaultElements();
        MatrixTest.assertEquals((String)"row size", (long)this.values.length, (long)c[0]);
        MatrixTest.assertEquals((String)"col size", (long)this.values[0].length, (long)c[1]);
    }

    @Test
    public void testViewPart() {
        int[] offset = new int[]{1, 1};
        int[] size = new int[]{2, 1};
        Matrix view = this.test.viewPart(offset, size);
        MatrixTest.assertEquals((long)2L, (long)view.rowSize());
        MatrixTest.assertEquals((long)1L, (long)view.columnSize());
        int[] c = view.size();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.values[row + 1][col + 1], (double)view.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testViewPartCardinality() {
        int[] offset = new int[]{1, 1};
        int[] size = new int[]{3, 3};
        this.test.viewPart(offset, size);
    }

    @Test(expected=IndexException.class)
    public void testViewPartIndexOver() {
        int[] offset = new int[]{1, 1};
        int[] size = new int[]{2, 2};
        this.test.viewPart(offset, size);
    }

    @Test(expected=IndexException.class)
    public void testViewPartIndexUnder() {
        int[] offset = new int[]{-1, -1};
        int[] size = new int[]{2, 2};
        this.test.viewPart(offset, size);
    }

    @Test
    public void testAssignDouble() {
        int[] c = this.test.size();
        this.test.assign(4.53);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)4.53, (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testAssignDoubleArrayArray() {
        int[] c = this.test.size();
        this.test.assign(new double[3][2]);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)0.0, (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignDoubleArrayArrayCardinality() {
        int[] c = this.test.size();
        this.test.assign(new double[c[0] + 1][c[1]]);
    }

    @Test
    public void testAssignMatrixBinaryFunction() {
        int[] c = this.test.size();
        this.test.assign(this.test, Functions.PLUS);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(2.0 * this.values[row][col]), (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignMatrixBinaryFunctionCardinality() {
        this.test.assign(this.test.transpose(), Functions.PLUS);
    }

    @Test
    public void testAssignMatrix() {
        int[] c = this.test.size();
        Matrix value = this.test.like();
        value.assign(this.test);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.test.getQuick(row, col), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testAssignMatrixCardinality() {
        this.test.assign(this.test.transpose());
    }

    @Test
    public void testAssignUnaryFunction() {
        int[] c = this.test.size();
        this.test.assign(Functions.mult((double)-1.0));
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(-this.values[row][col]), (double)this.test.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testRowView() {
        int[] c = this.test.size();
        for (int row = 0; row < c[0]; ++row) {
            MatrixTest.assertEquals((double)0.0, (double)this.test.getRow(row).minus(this.test.viewRow(row)).norm(1.0), (double)0.0);
        }
        MatrixTest.assertEquals((long)c[1], (long)this.test.viewRow(3).size());
        MatrixTest.assertEquals((long)c[1], (long)this.test.viewRow(5).size());
        Random gen = RandomUtils.getRandom();
        for (int row = 0; row < c[0]; ++row) {
            int j = gen.nextInt(c[1]);
            double old = this.test.get(row, j);
            double v = gen.nextGaussian();
            this.test.viewRow(row).set(j, v);
            MatrixTest.assertEquals((double)v, (double)this.test.get(row, j), (double)0.0);
            MatrixTest.assertEquals((double)v, (double)this.test.viewRow(row).get(j), (double)0.0);
            this.test.set(row, j, old);
            MatrixTest.assertEquals((double)old, (double)this.test.get(row, j), (double)0.0);
            MatrixTest.assertEquals((double)old, (double)this.test.viewRow(row).get(j), (double)0.0);
        }
    }

    @Test
    public void testColumnView() {
        int[] c = this.test.size();
        for (int col = 0; col < c[1]; ++col) {
            MatrixTest.assertEquals((double)0.0, (double)this.test.getColumn(col).minus(this.test.viewColumn(col)).norm(1.0), (double)0.0);
        }
        MatrixTest.assertEquals((long)c[0], (long)this.test.viewColumn(3).size());
        MatrixTest.assertEquals((long)c[0], (long)this.test.viewColumn(5).size());
        Random gen = RandomUtils.getRandom();
        for (int col = 0; col < c[1]; ++col) {
            int j = gen.nextInt(c[1]);
            double old = this.test.get(col, j);
            double v = gen.nextGaussian();
            this.test.viewColumn(col).set(j, v);
            MatrixTest.assertEquals((double)v, (double)this.test.get(j, col), (double)0.0);
            MatrixTest.assertEquals((double)v, (double)this.test.viewColumn(col).get(j), (double)0.0);
            this.test.set(j, col, old);
            MatrixTest.assertEquals((double)old, (double)this.test.get(j, col), (double)0.0);
            MatrixTest.assertEquals((double)old, (double)this.test.viewColumn(col).get(j), (double)0.0);
        }
    }

    @Test
    public void testAggregateRows() {
        Vector v = this.test.aggregateRows(new VectorFunction(){

            public double apply(Vector v) {
                return v.zSum();
            }
        });
        for (int i = 0; i < this.test.numRows(); ++i) {
            MatrixTest.assertEquals((double)this.test.getRow(i).zSum(), (double)v.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAggregateCols() {
        Vector v = this.test.aggregateColumns(new VectorFunction(){

            public double apply(Vector v) {
                return v.zSum();
            }
        });
        for (int i = 0; i < this.test.numCols(); ++i) {
            MatrixTest.assertEquals((double)this.test.getColumn(i).zSum(), (double)v.get(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAggregate() {
        double total = this.test.aggregate(Functions.PLUS, Functions.IDENTITY);
        MatrixTest.assertEquals((double)this.test.aggregateRows(new VectorFunction(){

            public double apply(Vector v) {
                return v.zSum();
            }
        }).zSum(), (double)total, (double)1.0E-6);
    }

    @Test
    public void testDivide() {
        int[] c = this.test.size();
        Matrix value = this.test.divide(4.53);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row][col] / 4.53), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testGet() {
        int[] c = this.test.size();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.values[row][col], (double)this.test.get(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testGetIndexUnder() {
        int[] c = this.test.size();
        for (int row = -1; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                this.test.get(row, col);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testGetIndexOver() {
        int[] c = this.test.size();
        for (int row = 0; row < c[0] + 1; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                this.test.get(row, col);
            }
        }
    }

    @Test
    public void testMinus() {
        int[] c = this.test.size();
        Matrix value = this.test.minus(this.test);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)0.0, (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testMinusCardinality() {
        this.test.minus(this.test.transpose());
    }

    @Test
    public void testPlusDouble() {
        int[] c = this.test.size();
        Matrix value = this.test.plus(4.53);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row][col] + 4.53), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testPlusMatrix() {
        int[] c = this.test.size();
        Matrix value = this.test.plus(this.test);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row][col] * 2.0), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test(expected=CardinalityException.class)
    public void testPlusMatrixCardinality() {
        this.test.plus(this.test.transpose());
    }

    @Test(expected=IndexException.class)
    public void testSetUnder() {
        int[] c = this.test.size();
        for (int row = -1; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                this.test.set(row, col, 1.23);
            }
        }
    }

    @Test(expected=IndexException.class)
    public void testSetOver() {
        int[] c = this.test.size();
        for (int row = 0; row < c[0] + 1; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                this.test.set(row, col, 1.23);
            }
        }
    }

    @Test
    public void testTimesDouble() {
        int[] c = this.test.size();
        Matrix value = this.test.times(4.53);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)(this.values[row][col] * 4.53), (double)value.getQuick(row, col), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testTimesMatrix() {
        int[] c = this.test.size();
        Matrix transpose = this.test.transpose();
        Matrix value = this.test.times(transpose);
        int[] v = value.size();
        MatrixTest.assertEquals((String)"rows", (long)c[0], (long)v[0]);
        MatrixTest.assertEquals((String)"cols", (long)c[0], (long)v[1]);
        Matrix expected = new DenseMatrix((double[][])new double[][]{{5.0, 11.0, 17.0}, {11.0, 25.0, 39.0}, {17.0, 39.0, 61.0}}).times(1.21);
        for (int i = 0; i < expected.numCols(); ++i) {
            for (int j = 0; j < expected.numRows(); ++j) {
                MatrixTest.assertTrue((String)("Matrix times transpose not correct: " + i + ", " + j + "\nexpected:\n\t" + expected + "\nactual:\n\t" + value), (Math.abs(expected.get(i, j) - value.get(i, j)) < 1.0E-12 ? 1 : 0) != 0);
            }
        }
        DenseMatrix timestest = new DenseMatrix(10, 1);
        timestest.transpose().times((Matrix)timestest);
    }

    @Test(expected=CardinalityException.class)
    public void testTimesVector() {
        DenseVector vectorA = new DenseVector(this.vectorAValues);
        Vector testTimesVectorA = this.test.times((Vector)vectorA);
        DenseVector expected = new DenseVector(new double[]{5.0, 11.0, 17.0});
        MatrixTest.assertTrue((String)("Matrix times vector not equals: " + vectorA + " != " + testTimesVectorA), (expected.minus(testTimesVectorA).norm(2.0) < 1.0E-12 ? 1 : 0) != 0);
        this.test.times(testTimesVectorA);
    }

    @Test
    public void testTimesSquaredTimesVector() {
        DenseVector vectorA = new DenseVector(this.vectorAValues);
        Vector ttA = this.test.timesSquared((Vector)vectorA);
        Vector ttASlow = this.test.transpose().times(this.test.times((Vector)vectorA));
        MatrixTest.assertTrue((String)("M'Mv != M.timesSquared(v): " + ttA + " != " + ttASlow), (ttASlow.minus(ttA).norm(2.0) < 1.0E-12 ? 1 : 0) != 0);
    }

    @Test(expected=CardinalityException.class)
    public void testTimesMatrixCardinality() {
        Matrix other = this.test.like(5, 8);
        this.test.times(other);
    }

    @Test
    public void testTranspose() {
        int[] c = this.test.size();
        Matrix transpose = this.test.transpose();
        int[] t = transpose.size();
        MatrixTest.assertEquals((String)"rows", (long)c[1], (long)t[0]);
        MatrixTest.assertEquals((String)"cols", (long)c[0], (long)t[1]);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                MatrixTest.assertEquals((String)("value[" + row + "][" + col + ']'), (double)this.test.getQuick(row, col), (double)transpose.getQuick(col, row), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testZSum() {
        double sum = this.test.zSum();
        MatrixTest.assertEquals((String)"zsum", (double)23.1, (double)sum, (double)1.0E-6);
    }

    @Test
    public void testAssignRow() {
        double[] data = new double[]{2.1, 3.2};
        this.test.assignRow(1, (Vector)new DenseVector(data));
        MatrixTest.assertEquals((String)"test[1][0]", (double)2.1, (double)this.test.getQuick(1, 0), (double)1.0E-6);
        MatrixTest.assertEquals((String)"test[1][1]", (double)3.2, (double)this.test.getQuick(1, 1), (double)1.0E-6);
    }

    @Test(expected=CardinalityException.class)
    public void testAssignRowCardinality() {
        double[] data = new double[]{2.1, 3.2, 4.3};
        this.test.assignRow(1, (Vector)new DenseVector(data));
    }

    @Test
    public void testAssignColumn() {
        double[] data = new double[]{2.1, 3.2, 4.3};
        this.test.assignColumn(1, (Vector)new DenseVector(data));
        MatrixTest.assertEquals((String)"test[0][1]", (double)2.1, (double)this.test.getQuick(0, 1), (double)1.0E-6);
        MatrixTest.assertEquals((String)"test[1][1]", (double)3.2, (double)this.test.getQuick(1, 1), (double)1.0E-6);
        MatrixTest.assertEquals((String)"test[2][1]", (double)4.3, (double)this.test.getQuick(2, 1), (double)1.0E-6);
    }

    @Test(expected=CardinalityException.class)
    public void testAssignColumnCardinality() {
        double[] data = new double[]{2.1, 3.2};
        this.test.assignColumn(1, (Vector)new DenseVector(data));
    }

    @Test
    public void testGetRow() {
        Vector row = this.test.getRow(1);
        MatrixTest.assertEquals((String)"row size", (long)2L, (long)row.getNumNondefaultElements());
    }

    @Test(expected=IndexException.class)
    public void testGetRowIndexUnder() {
        this.test.getRow(-1);
    }

    @Test(expected=IndexException.class)
    public void testGetRowIndexOver() {
        this.test.getRow(5);
    }

    @Test
    public void testGetColumn() {
        Vector column = this.test.getColumn(1);
        MatrixTest.assertEquals((String)"row size", (long)3L, (long)column.getNumNondefaultElements());
    }

    @Test(expected=IndexException.class)
    public void testGetColumnIndexUnder() {
        this.test.getColumn(-1);
    }

    @Test(expected=IndexException.class)
    public void testGetColumnIndexOver() {
        this.test.getColumn(5);
    }

    @Test
    public void testDetermitant() {
        Matrix m = this.matrixFactory(new double[][]{{1.0, 3.0, 4.0}, {5.0, 2.0, 3.0}, {1.0, 4.0, 2.0}});
        MatrixTest.assertEquals((String)"determinant", (double)43.0, (double)m.determinant(), (double)1.0E-6);
    }

    @Test
    public void testLabelBindings() {
        Matrix m = this.matrixFactory(new double[][]{{1.0, 3.0, 4.0}, {5.0, 2.0, 3.0}, {1.0, 4.0, 2.0}});
        MatrixTest.assertNull((String)"row bindings", (Object)m.getRowLabelBindings());
        MatrixTest.assertNull((String)"col bindings", (Object)m.getColumnLabelBindings());
        HashMap<String, Integer> rowBindings = new HashMap<String, Integer>();
        rowBindings.put("Fee", 0);
        rowBindings.put("Fie", 1);
        rowBindings.put("Foe", 2);
        m.setRowLabelBindings(rowBindings);
        MatrixTest.assertEquals((String)"row", rowBindings, (Object)m.getRowLabelBindings());
        HashMap<String, Integer> colBindings = new HashMap<String, Integer>();
        colBindings.put("Foo", 0);
        colBindings.put("Bar", 1);
        colBindings.put("Baz", 2);
        m.setColumnLabelBindings(colBindings);
        MatrixTest.assertEquals((String)"row", rowBindings, (Object)m.getRowLabelBindings());
        MatrixTest.assertEquals((String)"Fee", (double)m.get(0, 1), (double)m.get("Fee", "Bar"), (double)1.0E-6);
        double[] newrow = new double[]{9.0, 8.0, 7.0};
        m.set("Foe", newrow);
        MatrixTest.assertEquals((String)"FeeBaz", (double)m.get(0, 2), (double)m.get("Fee", "Baz"), (double)1.0E-6);
    }

    @Test(expected=UnboundLabelException.class)
    public void testSettingLabelBindings() {
        Matrix m = this.matrixFactory(new double[][]{{1.0, 3.0, 4.0}, {5.0, 2.0, 3.0}, {1.0, 4.0, 2.0}});
        MatrixTest.assertNull((String)"row bindings", (Object)m.getRowLabelBindings());
        MatrixTest.assertNull((String)"col bindings", (Object)m.getColumnLabelBindings());
        m.set("Fee", "Foo", 1, 2, 9.0);
        MatrixTest.assertNotNull((String)"row", (Object)m.getRowLabelBindings());
        MatrixTest.assertNotNull((String)"row", (Object)m.getRowLabelBindings());
        MatrixTest.assertEquals((String)"Fee", (long)1L, (long)((Integer)m.getRowLabelBindings().get("Fee")).intValue());
        MatrixTest.assertEquals((String)"Fee", (long)2L, (long)((Integer)m.getColumnLabelBindings().get("Foo")).intValue());
        MatrixTest.assertEquals((String)"FeeFoo", (double)m.get(1, 2), (double)m.get("Fee", "Foo"), (double)1.0E-6);
        m.get("Fie", "Foe");
    }

    @Test
    public void testLabelBindingSerialization() {
        Matrix m = this.matrixFactory(new double[][]{{1.0, 3.0, 4.0}, {5.0, 2.0, 3.0}, {1.0, 4.0, 2.0}});
        MatrixTest.assertNull((String)"row bindings", (Object)m.getRowLabelBindings());
        MatrixTest.assertNull((String)"col bindings", (Object)m.getColumnLabelBindings());
        HashMap<String, Integer> rowBindings = new HashMap<String, Integer>();
        rowBindings.put("Fee", 0);
        rowBindings.put("Fie", 1);
        rowBindings.put("Foe", 2);
        m.setRowLabelBindings(rowBindings);
        MatrixTest.assertEquals((String)"row", rowBindings, (Object)m.getRowLabelBindings());
        HashMap<String, Integer> colBindings = new HashMap<String, Integer>();
        colBindings.put("Foo", 0);
        colBindings.put("Bar", 1);
        colBindings.put("Baz", 2);
        m.setColumnLabelBindings(colBindings);
        MatrixTest.assertEquals((String)"col", colBindings, (Object)m.getColumnLabelBindings());
    }
}

