/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer.lanczos;

import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.decomposer.SolverTest;
import org.apache.mahout.math.decomposer.lanczos.LanczosSolver;
import org.apache.mahout.math.decomposer.lanczos.LanczosState;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.linalg.EigenvalueDecomposition;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestLanczosSolver
extends SolverTest {
    private static final Logger log = LoggerFactory.getLogger(TestLanczosSolver.class);
    private static final double ERROR_TOLERANCE = 0.05;

    @Test
    public void testEigenvalueCheck() throws Exception {
        int size = 100;
        Matrix m = TestLanczosSolver.randomHierarchicalSymmetricMatrix(size);
        int desiredRank = 80;
        DenseVector initialVector = new DenseVector(size);
        initialVector.assign(1.0 / Math.sqrt(size));
        LanczosSolver solver = new LanczosSolver();
        LanczosState state = new LanczosState((VectorIterable)m, size, desiredRank, (Vector)initialVector);
        solver.solve(state, desiredRank, true);
        EigenvalueDecomposition decomposition = new EigenvalueDecomposition(m);
        DoubleMatrix1D eigenvalues = decomposition.getRealEigenvalues();
        float fractionOfEigensExpectedGood = 0.6f;
        int i = 0;
        while ((float)i < fractionOfEigensExpectedGood * (float)desiredRank) {
            double s = state.getSingularValue(desiredRank - i - 1);
            double e = eigenvalues.get(eigenvalues.size() - i - 1);
            log.info(i + " : L = {}, E = {}", (Object)s, (Object)e);
            TestLanczosSolver.assertTrue((String)"Singular value differs from eigenvalue", (Math.abs((s - e) / e) < 0.05 ? 1 : 0) != 0);
            Vector v = state.getRightSingularVector(i);
            Vector v2 = decomposition.getV().viewColumn(eigenvalues.size() - i - 1).toVector();
            double error = 1.0 - Math.abs(v.dot(v2) / (v.norm(2.0) * v2.norm(2.0)));
            log.info("error: {}", (Object)error);
            TestLanczosSolver.assertTrue((String)(i + ": 1 - cosAngle = " + error), (error < 0.05 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testLanczosSolver() throws Exception {
        int numRows = 800;
        int numColumns = 500;
        Matrix corpus = TestLanczosSolver.randomHierarchicalMatrix(numRows, numColumns, false);
        int rank = 50;
        DenseVector initialVector = new DenseVector(numColumns);
        initialVector.assign(1.0 / Math.sqrt(numColumns));
        LanczosState state = new LanczosState((VectorIterable)corpus, numColumns, rank, (Vector)initialVector);
        long time = TestLanczosSolver.timeLanczos(corpus, state, rank, false);
        TestLanczosSolver.assertTrue((String)"Lanczos taking too long!  Are you in the debugger? :)", (time < 10000L ? 1 : 0) != 0);
        TestLanczosSolver.assertOrthonormal(state);
        for (int i = 0; i < rank / 2; ++i) {
            TestLanczosSolver.assertEigen(i, state.getRightSingularVector(i), (VectorIterable)corpus, 0.05, false);
        }
    }

    @Test
    public void testLanczosSolverSymmetric() throws Exception {
        int numCols = 500;
        Matrix corpus = TestLanczosSolver.randomHierarchicalSymmetricMatrix(numCols);
        int rank = 30;
        DenseVector initialVector = new DenseVector(numCols);
        initialVector.assign(1.0 / Math.sqrt(numCols));
        LanczosState state = new LanczosState((VectorIterable)corpus, numCols, rank, (Vector)initialVector);
        long time = TestLanczosSolver.timeLanczos(corpus, state, rank, true);
        TestLanczosSolver.assertTrue((String)"Lanczos taking too long!  Are you in the debugger? :)", (time < 10000L ? 1 : 0) != 0);
    }

    public static long timeLanczos(Matrix corpus, LanczosState state, int rank, boolean symmetric) {
        long start = System.currentTimeMillis();
        LanczosSolver solver = new LanczosSolver();
        solver.solve(state, rank, symmetric);
        long end = System.currentTimeMillis();
        return end - start;
    }
}

