/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.jet.random.Gamma;
import org.junit.Test;

public final class GammaTest
extends MahoutTestCase {
    @Test
    public void testNextDouble() {
        double[] z = new double[100000];
        Random gen = RandomUtils.getRandom();
        for (double alpha : new double[]{1.0, 2.0, 10.0, 0.1, 0.01, 100.0}) {
            Gamma g = new Gamma(alpha, 1.0, gen);
            for (int i = 0; i < z.length; ++i) {
                z[i] = g.nextDouble();
            }
            Arrays.sort(z);
            for (double q : GammaTest.seq(0.01, 1.0, 0.01)) {
                double p = z[(int)(q * (double)z.length)];
                GammaTest.assertEquals((double)q, (double)g.cdf(p), (double)0.01);
            }
        }
    }

    @Test
    public void testCdf() {
        Random gen = RandomUtils.getRandom();
        for (double beta : new double[]{1.0, 0.1, 2.0, 100.0}) {
            Gamma g1 = new Gamma(1.0, beta, gen);
            Gamma g2 = new Gamma(1.0, 1.0, gen);
            for (double x : GammaTest.seq(0.0, 0.99, 0.1)) {
                GammaTest.assertEquals((String)String.format(Locale.ENGLISH, "Rate invariance: x = %.4f, alpha = 1, beta = %.1f", x, beta), (double)(1.0 - Math.exp(-x * beta)), (double)g1.cdf(x), (double)1.0E-9);
                GammaTest.assertEquals((String)String.format(Locale.ENGLISH, "Rate invariance: x = %.4f, alpha = 1, beta = %.1f", x, beta), (double)g2.cdf(beta * x), (double)g1.cdf(x), (double)1.0E-9);
            }
        }
        for (double alpha : new double[]{0.01, 0.1, 1.0, 2.0, 10.0, 100.0, 1000.0}) {
            Gamma g = new Gamma(alpha, 1.0, gen);
            for (double beta : new double[]{0.1, 1.0, 2.0, 100.0}) {
                Gamma g1 = new Gamma(alpha, beta, gen);
                for (double x : GammaTest.seq(0.0, 0.9999, 0.001)) {
                    GammaTest.assertEquals((String)String.format(Locale.ENGLISH, "Rate invariance: x = %.4f, alpha = %.2f, beta = %.1f", x, alpha, beta), (double)g.cdf(x * beta), (double)g1.cdf(x), (double)0.0);
                }
            }
        }
        GammaTest.checkGammaCdf(0.01, 1.0, 0.0, 0.9450896, 0.9516444, 0.9554919, 0.9582258, 0.9603474, 0.962081, 0.9635462, 0.9648148, 0.9659329, 0.9669321);
        GammaTest.checkGammaCdf(0.1, 1.0, 0.0, 0.7095387, 0.7591012, 0.7891072, 0.8107067, 0.8275518, 0.841318, 0.8529198, 0.8629131, 0.8716623, 0.8794196);
        GammaTest.checkGammaCdf(1.0, 1.0, 0.0, 0.1812692, 0.32968, 0.4511884, 0.550671, 0.6321206, 0.6988058, 0.753403, 0.7981035, 0.8347011, 0.8646647);
        GammaTest.checkGammaCdf(10.0, 1.0, 0.0, 4.649808E-5, 0.008132243, 0.08392402, 0.2833757, 0.5420703, 0.7576078, 0.8906006, 0.9567017, 0.9846189, 0.9950046);
        GammaTest.checkGammaCdf(100.0, 1.0, 0.0, 3.488879E-37, 1.206254E-15, 1.481528E-6, 0.01710831, 0.5132988, 0.9721363, 0.9998389, 0.9999999, 1.0, 1.0);
    }

    private static void checkGammaCdf(double alpha, double beta, double ... values) {
        Gamma g = new Gamma(alpha, beta, RandomUtils.getRandom());
        int i = 0;
        for (double x : GammaTest.seq(0.0, 2.0 * alpha, 2.0 * alpha / 10.0)) {
            GammaTest.assertEquals((String)String.format(Locale.ENGLISH, "alpha=%.2f, i=%d, x=%.2f", alpha, i, x), (double)values[i], (double)g.cdf(x), (double)1.0E-7);
            ++i;
        }
    }

    private static double[] seq(double from, double to, double by) {
        double[] r = new double[(int)Math.ceil(0.999999 * (to - from) / by)];
        int i = 0;
        for (double x = from; x < to - (to - from) * 1.0E-6; x += by) {
            r[i++] = x;
        }
        return r;
    }

    @Test
    public void testPdf() {
        Random gen = RandomUtils.getRandom();
        for (double alpha : new double[]{0.01, 0.1, 1.0, 2.0, 10.0, 100.0}) {
            for (double beta : new double[]{0.1, 1.0, 2.0, 100.0}) {
                Gamma g1 = new Gamma(alpha, beta, gen);
                for (double x : GammaTest.seq(0.0, 0.99, 0.1)) {
                    double p = Math.pow(beta, alpha) * Math.pow(x, alpha - 1.0) * Math.exp(-beta * x - org.apache.mahout.math.jet.stat.Gamma.logGamma((double)alpha));
                    GammaTest.assertEquals((String)String.format(Locale.ENGLISH, "alpha=%.2f, beta=%.2f, x=%.2f\n", alpha, beta, x), (double)p, (double)g1.pdf(x), (double)1.0E-9);
                }
            }
        }
    }
}

