/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.stat;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.jet.stat.Gamma;
import org.junit.Test;

public final class GammaTest
extends MahoutTestCase {
    @Test
    public void testGamma() {
        double[] x = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0};
        double[] expected = new double[]{1.0, 1.0, 24.0, 362880.0, 1.216451E17, 6.082819E62, 9.332622E155};
        for (int i = 0; i < x.length; ++i) {
            GammaTest.assertEquals((double)expected[i], (double)Gamma.gamma((double)x[i]), (double)(expected[i] * 1.0E-5));
            GammaTest.assertEquals((double)GammaTest.gammaInteger(x[i]), (double)Gamma.gamma((double)x[i]), (double)(expected[i] * 1.0E-5));
            GammaTest.assertEquals((double)GammaTest.gammaInteger(x[i]), (double)Math.exp(Gamma.logGamma((double)x[i])), (double)(expected[i] * 1.0E-5));
        }
    }

    @Test
    public void testNegativeArgForGamma() {
        double[] x = new double[]{-30.3, -20.7, -10.5, -1.1, 0.5, 0.99, -0.999};
        double[] expected = new double[]{-5.243216E-33, -1.904051E-19, -2.640122E-7, 9.714806, 1.772454, 1.005872, -1000.424};
        for (int i = 0; i < x.length; ++i) {
            GammaTest.assertEquals((double)expected[i], (double)Gamma.gamma((double)x[i]), (double)Math.abs(expected[i] * 1.0E-5));
            GammaTest.assertEquals((double)Math.abs(expected[i]), (double)Math.abs(Math.exp(Gamma.logGamma((double)x[i]))), (double)Math.abs(expected[i] * 1.0E-5));
        }
    }

    private static double gammaInteger(double x) {
        double r = 1.0;
        int i = 2;
        while ((double)i < x) {
            r *= (double)i;
            ++i;
        }
        return r;
    }

    @Test
    public void testBigX() {
        GammaTest.assertEquals((double)GammaTest.factorial(4), (double)24.0, (double)0.0);
        GammaTest.assertEquals((double)GammaTest.factorial(4), (double)Gamma.gamma((double)5.0), (double)0.0);
        GammaTest.assertEquals((double)GammaTest.factorial(14), (double)Gamma.gamma((double)15.0), (double)0.0);
        GammaTest.assertEquals((double)GammaTest.factorial(34), (double)Gamma.gamma((double)35.0), (double)(1.0E-15 * GammaTest.factorial(34)));
        GammaTest.assertEquals((double)GammaTest.factorial(44), (double)Gamma.gamma((double)45.0), (double)(1.0E-15 * GammaTest.factorial(44)));
        GammaTest.assertEquals((double)-6.8841366491691E-40, (double)Gamma.gamma((double)-35.1), (double)1.0E-52);
        GammaTest.assertEquals((double)-3.9156463526813115E-41, (double)Gamma.gamma((double)-35.9), (double)1.0E-52);
        GammaTest.assertEquals((double)-2.000000000577215E9, (double)Gamma.gamma((double)-5.0E-10), (double)2.000000000577215E-6);
        GammaTest.assertEquals((double)1.999999999422784E9, (double)Gamma.gamma((double)5.0E-10), (double)1.9999999994227842E-6);
        GammaTest.assertEquals((double)1.324296658017984E252, (double)Gamma.gamma((double)146.1), (double)1.324296658017984E242);
        for (double x : new double[]{5.0, 15.0, 35.0, 45.0, -35.1, -35.9, -5.0E-10, 5.0E-10, 146.1}) {
            double ref = Math.log(Math.abs(Gamma.gamma((double)x)));
            double actual = Gamma.logGamma((double)x);
            double diff = Math.abs(ref - actual) / ref;
            GammaTest.assertEquals((String)("gamma versus logGamma at " + x + " (diff = " + diff + ')'), (double)0.0, (double)((ref - actual) / ref), (double)1.0E-8);
        }
    }

    private static double factorial(int n) {
        double r = 1.0;
        for (int i = 2; i <= n; ++i) {
            r *= (double)i;
        }
        return r;
    }

    @Test
    public void beta() {
        Random r = RandomUtils.getRandom();
        for (int i = 0; i < 200; ++i) {
            double alpha = -50.0 * Math.log(1.0 - r.nextDouble());
            double beta = -50.0 * Math.log(1.0 - r.nextDouble());
            double ref = Math.exp(Gamma.logGamma((double)alpha) + Gamma.logGamma((double)beta) - Gamma.logGamma((double)(alpha + beta)));
            double actual = Gamma.beta((double)alpha, (double)beta);
            double err = (ref - actual) / ref;
            GammaTest.assertEquals((String)("beta at (" + alpha + ", " + beta + ") relative error = " + err), (double)0.0, (double)err, (double)1.0E-10);
        }
    }

    @Test
    public void incompleteBeta() throws IOException {
        Splitter onComma = Splitter.on((String)",").trimResults();
        InputSupplier input = Resources.newReaderSupplier((URL)Resources.getResource((String)"beta-test-data.csv"), (Charset)Charsets.UTF_8);
        boolean header = true;
        for (String line : CharStreams.readLines((InputSupplier)input)) {
            if (header) {
                header = false;
                continue;
            }
            Iterable values = onComma.split((CharSequence)line);
            double alpha = Double.parseDouble((String)Iterables.get((Iterable)values, (int)0));
            double beta = Double.parseDouble((String)Iterables.get((Iterable)values, (int)1));
            double x = Double.parseDouble((String)Iterables.get((Iterable)values, (int)2));
            double ref = Double.parseDouble((String)Iterables.get((Iterable)values, (int)3));
            double actual = Gamma.incompleteBeta((double)alpha, (double)beta, (double)x);
            GammaTest.assertEquals((String)(alpha + "," + beta + ',' + x), (double)ref, (double)actual, (double)(ref * 1.0E-5));
        }
    }
}

