/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataDeploymentException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

public class DefaultArtifactDeployer
extends AbstractLogEnabled
implements ArtifactDeployer {
    private WagonManager wagonManager;
    private ArtifactTransformationManager transformationManager;
    private RepositoryMetadataManager repositoryMetadataManager;
    private ArtifactMetadataSource metadataSource;
    private ArtifactRepositoryLayout defaultLayout;

    @Deprecated
    public void deploy(String basedir, String finalName, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.deploy(source, artifact, deploymentRepository, localRepository);
    }

    public void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        if (!this.wagonManager.isOnline()) {
            throw new ArtifactDeploymentException("System is offline. Cannot deploy artifact: " + artifact + ".");
        }
        if (!this.artifactHasBeenDeployed(artifact, localRepository, deploymentRepository)) {
            try {
                this.transformationManager.transformForDeployment(artifact, deploymentRepository, localRepository);
                File artifactFile = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
                if (!artifactFile.equals(source)) {
                    FileUtils.copyFile((File)source, (File)artifactFile);
                }
                this.wagonManager.putArtifact(source, artifact, deploymentRepository);
                for (ArtifactMetadata metadata : artifact.getMetadataList()) {
                    this.repositoryMetadataManager.deploy(metadata, localRepository, deploymentRepository);
                }
            }
            catch (TransferFailedException e) {
                throw new ArtifactDeploymentException("Error deploying artifact: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ArtifactDeploymentException("Error deploying artifact: " + e.getMessage(), e);
            }
            catch (RepositoryMetadataDeploymentException e) {
                throw new ArtifactDeploymentException("Error installing artifact's metadata: " + e.getMessage(), e);
            }
        } else {
            throw new ArtifactDeploymentException("The artifact " + artifact + " was already deployed to repository " + deploymentRepository.getId());
        }
    }

    private boolean artifactHasBeenDeployed(Artifact artifact, ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws ArtifactDeploymentException {
        try {
            if (artifact.isSnapshot()) {
                return false;
            }
            if (remoteRepository.getReleases() == null) {
                ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy();
                releasesPolicy.setEnabled(true);
                ((DefaultArtifactRepository)remoteRepository).setReleases(releasesPolicy);
            }
            DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(artifact.getVersion());
            List<ArtifactVersion> versions = this.metadataSource.retrieveAvailableVersionsFromDeploymentRepository(artifact, localRepository, remoteRepository);
            for (ArtifactVersion deployedArtifactVersion : versions) {
                if (artifactVersion.compareTo(deployedArtifactVersion) != 0) continue;
                this.getLogger().warn("The artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + " has already been deployed. Not deploying again.");
                return true;
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            this.getLogger().warn("Cannot retrieve the artifact metadata, or it does not exist. Assuming this artifact needs to be deployed.");
            this.getLogger().debug(e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }
}

