/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.doxia.module.common.ByLineSource;
import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.BlockParser;
import org.apache.maven.doxia.module.confluence.parser.BoldBlock;
import org.apache.maven.doxia.module.confluence.parser.ItalicBlock;
import org.apache.maven.doxia.module.confluence.parser.LinkBlock;
import org.apache.maven.doxia.module.confluence.parser.MonospaceBlock;
import org.apache.maven.doxia.module.confluence.parser.ParagraphBlock;
import org.apache.maven.doxia.module.confluence.parser.TextBlock;
import org.apache.maven.doxia.parser.ParseException;
import org.codehaus.plexus.util.StringUtils;

public class ParagraphBlockParser
implements BlockParser {
    public boolean accept(String line, ByLineSource source) {
        return true;
    }

    public Block visit(String line, ByLineSource source) throws ParseException {
        boolean insideBold = false;
        boolean insideItalic = false;
        boolean insideLink = false;
        ArrayList<Block> blocks = new ArrayList<Block>();
        StringBuffer text = new StringBuffer();
        while (line.trim().length() != 0) {
            block9: for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                switch (c) {
                    case '*': {
                        TextBlock tb;
                        if (insideBold) {
                            tb = new TextBlock(text.toString());
                            blocks.add(new BoldBlock(Arrays.asList(tb)));
                            text = new StringBuffer();
                            continue block9;
                        }
                        blocks.add(new TextBlock(text.toString()));
                        text = new StringBuffer();
                        insideBold = true;
                        continue block9;
                    }
                    case '_': {
                        TextBlock tb;
                        if (insideItalic) {
                            tb = new TextBlock(text.toString());
                            blocks.add(new ItalicBlock(Arrays.asList(tb)));
                            text = new StringBuffer();
                            continue block9;
                        }
                        blocks.add(new TextBlock(text.toString()));
                        text = new StringBuffer();
                        insideItalic = true;
                        continue block9;
                    }
                    case '[': {
                        insideLink = true;
                        blocks.add(new TextBlock(text.toString()));
                        text = new StringBuffer();
                        continue block9;
                    }
                    case ']': {
                        if (!insideLink) continue block9;
                        String link = text.toString();
                        if (link.indexOf("|") > 0) {
                            String[] pieces = StringUtils.split((String)text.toString(), (String)"|");
                            blocks.add(new LinkBlock(pieces[1], pieces[0]));
                        } else {
                            blocks.add(new LinkBlock(link, link));
                        }
                        text = new StringBuffer();
                        continue block9;
                    }
                    case '{': {
                        if (line.charAt(i + 1) == '{') {
                            ++i;
                            blocks.add(new TextBlock(text.toString()));
                            text = new StringBuffer();
                            continue block9;
                        }
                        text.append(c);
                        continue block9;
                    }
                    case '}': {
                        TextBlock tb;
                        System.out.println("line = " + line);
                        if (line.charAt(i + 1) == '}') {
                            ++i;
                            tb = new TextBlock(text.toString());
                            blocks.add(new MonospaceBlock(Arrays.asList(tb)));
                            text = new StringBuffer();
                            continue block9;
                        }
                        text.append(c);
                        continue block9;
                    }
                    default: {
                        text.append(c);
                    }
                }
            }
            line = source.getNextLine();
            if (line != null) continue;
        }
        if (text.length() > 0) {
            blocks.add(new TextBlock(text.toString()));
        }
        return new ParagraphBlock(blocks);
    }
}

