/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml;

import java.io.Reader;
import java.util.Stack;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

public class XhtmlParser
implements Parser {
    private Stack linktypes = new Stack();
    private Stack sections = new Stack();
    private static final String LINK = "link";
    private static final String ANCHOR = "anchor";

    public void parse(Reader reader, Sink sink) throws ParseException {
        try {
            MXParser parser = new MXParser();
            parser.setInput(reader);
            this.parseXdoc((XmlPullParser)parser, sink);
        }
        catch (Exception ex) {
            throw new ParseException("Error parsing the model.", ex);
        }
    }

    public void parseXdoc(XmlPullParser parser, Sink sink) throws Exception {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals("title")) {
                    sink.title();
                } else if (parser.getName().equals("address")) {
                    sink.author();
                } else if (parser.getName().equals("body")) {
                    sink.body();
                } else if (parser.getName().equals("h1") || parser.getName().equals("h2") || parser.getName().equals("h3") || parser.getName().equals("h4") || parser.getName().equals("h5")) {
                    this.closeSubordinatedSections(parser.getName(), sink);
                    this.startSection(this.sections.size(), sink);
                    this.startSectionTitle(this.sections.size(), sink);
                    this.sections.push(parser.getName());
                } else if (parser.getName().equals("p")) {
                    sink.paragraph();
                } else if (parser.getName().equals("pre")) {
                    sink.verbatim(true);
                } else if (parser.getName().equals("code") || parser.getName().equals("samp") || parser.getName().equals("tt")) {
                    sink.monospaced();
                } else if (parser.getName().equals("ul")) {
                    sink.list();
                } else if (parser.getName().equals("ol")) {
                    sink.numberedList(0);
                } else if (parser.getName().equals("li")) {
                    sink.listItem();
                } else if (parser.getName().equals("head")) {
                    sink.head();
                } else if (parser.getName().equals("b") || parser.getName().equals("strong")) {
                    sink.bold();
                } else if (parser.getName().equals("i") || parser.getName().equals("em")) {
                    sink.italic();
                } else if (parser.getName().equals("a")) {
                    String href = parser.getAttributeValue(null, "href");
                    String name = parser.getAttributeValue(null, "name");
                    String id = parser.getAttributeValue(null, "id");
                    if (href != null) {
                        sink.link(href);
                        this.linktypes.push(LINK);
                    } else if (name != null) {
                        sink.anchor(name);
                        this.linktypes.push(ANCHOR);
                    } else if (id != null) {
                        sink.anchor(id);
                        this.linktypes.push(ANCHOR);
                    }
                } else if (parser.getName().equals("br")) {
                    sink.pageBreak();
                } else if (parser.getName().equals("hr")) {
                    sink.horizontalRule();
                } else if (parser.getName().equals("img")) {
                    sink.figure();
                    String src = parser.getAttributeValue(null, "src");
                    String title = parser.getAttributeValue(null, "title");
                    String alt = parser.getAttributeValue(null, "alt");
                    if (src != null) {
                        sink.figureGraphics(src);
                    }
                    if (title != null) {
                        sink.figureCaption();
                        sink.text(title);
                        sink.figureCaption_();
                    } else if (alt != null) {
                        sink.figureCaption();
                        sink.text(alt);
                        sink.figureCaption_();
                    }
                    sink.figure_();
                } else if (parser.getName().equals("table")) {
                    sink.table();
                } else if (parser.getName().equals("tr")) {
                    sink.tableRow();
                } else if (parser.getName().equals("th")) {
                    sink.tableCell();
                } else if (parser.getName().equals("td")) {
                    sink.tableCell();
                }
            } else if (eventType == 3) {
                if (parser.getName().equals("title")) {
                    sink.title_();
                } else if (parser.getName().equals("address")) {
                    sink.author_();
                } else if (parser.getName().equals("body")) {
                    this.closeSubordinatedSections("h0", sink);
                    sink.body_();
                } else if (parser.getName().equals("h1") || parser.getName().equals("h2") || parser.getName().equals("h3") || parser.getName().equals("h4") || parser.getName().equals("h5")) {
                    this.closeSectionTitle(this.sections.size() - 1, sink);
                } else if (parser.getName().equals("p")) {
                    sink.paragraph_();
                } else if (parser.getName().equals("pre")) {
                    sink.verbatim_();
                } else if (parser.getName().equals("code") || parser.getName().equals("samp") || parser.getName().equals("tt")) {
                    sink.monospaced_();
                } else if (parser.getName().equals("ul")) {
                    sink.list_();
                } else if (parser.getName().equals("ol")) {
                    sink.numberedList_();
                } else if (parser.getName().equals("li")) {
                    sink.listItem_();
                } else if (parser.getName().equals("head")) {
                    sink.head_();
                } else if (parser.getName().equals("b") || parser.getName().equals("strong")) {
                    sink.bold_();
                } else if (parser.getName().equals("i") || parser.getName().equals("em")) {
                    sink.italic_();
                } else if (parser.getName().equals("a")) {
                    String linktype = (String)this.linktypes.pop();
                    if (linktype == LINK) {
                        sink.link_();
                    } else {
                        sink.anchor_();
                    }
                } else if (parser.getName().equals("table")) {
                    sink.table_();
                } else if (parser.getName().equals("tr")) {
                    sink.tableRow_();
                } else if (parser.getName().equals("th")) {
                    sink.tableCell_();
                } else if (parser.getName().equals("td")) {
                    sink.tableCell_();
                }
            } else if (eventType == 4) {
                sink.text(parser.getText());
            }
            eventType = parser.next();
        }
    }

    private void closeSubordinatedSections(String level, Sink sink) {
        int mylevel;
        String heading;
        int otherlevel;
        if (this.sections.size() > 0 && (otherlevel = Integer.parseInt((heading = (String)this.sections.peek()).substring(1))) >= (mylevel = Integer.parseInt(level.substring(1)))) {
            this.closeSection(this.sections.size(), sink);
            this.closeSubordinatedSections(level, sink);
        }
    }

    private void closeSection(int level, Sink sink) {
        this.sections.pop();
        switch (level) {
            case 1: {
                sink.section1_();
                break;
            }
            case 2: {
                sink.section2_();
                break;
            }
            case 3: {
                sink.section3_();
                break;
            }
            case 4: {
                sink.section4_();
                break;
            }
            case 5: {
                sink.section5_();
            }
        }
    }

    private void startSection(int level, Sink sink) {
        switch (level) {
            case 0: {
                sink.section1();
                break;
            }
            case 1: {
                sink.section2();
                break;
            }
            case 2: {
                sink.section3();
                break;
            }
            case 3: {
                sink.section4();
                break;
            }
            case 4: {
                sink.section5();
            }
        }
    }

    private void closeSectionTitle(int level, Sink sink) {
        switch (level) {
            case 0: {
                sink.sectionTitle1_();
                break;
            }
            case 1: {
                sink.sectionTitle2_();
                break;
            }
            case 2: {
                sink.sectionTitle3_();
                break;
            }
            case 3: {
                sink.sectionTitle4_();
                break;
            }
            case 4: {
                sink.sectionTitle5_();
            }
        }
    }

    private void startSectionTitle(int level, Sink sink) {
        switch (level) {
            case 0: {
                sink.sectionTitle1();
                break;
            }
            case 1: {
                sink.sectionTitle2();
                break;
            }
            case 2: {
                sink.sectionTitle3();
                break;
            }
            case 3: {
                sink.sectionTitle4();
                break;
            }
            case 4: {
                sink.sectionTitle5();
            }
        }
    }
}

