/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module;

import java.io.UnsupportedEncodingException;
import org.apache.maven.doxia.sink.StructureSink;

public class HtmlTools {
    public static String escapeHTML(String text) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block6: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static String encodeURL(String text) {
        StringBuffer encoded = new StringBuffer();
        int length = text.length();
        char[] unicode = new char[1];
        block5: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '!': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '_': 
                case '~': {
                    encoded.append(c);
                    continue block5;
                }
                default: {
                    byte[] bytes;
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        encoded.append(c);
                        continue block5;
                    }
                    try {
                        unicode[0] = c;
                        bytes = new String(unicode, 0, 1).getBytes("UTF8");
                    }
                    catch (UnsupportedEncodingException cannotHappen) {
                        bytes = new byte[]{};
                    }
                    for (int j = 0; j < bytes.length; ++j) {
                        String hex = Integer.toHexString(bytes[j] & 0xFF);
                        encoded.append('%');
                        if (hex.length() == 1) {
                            encoded.append('0');
                        }
                        encoded.append(hex);
                    }
                }
            }
        }
        return encoded.toString();
    }

    public static String encodeFragment(String text) {
        return HtmlTools.encodeURL(StructureSink.linkToKey(text));
    }
}

