/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.doxia.module.HtmlTools;
import org.apache.maven.doxia.module.xhtml.AbstractXhtmlSink;
import org.apache.maven.doxia.module.xhtml.StringsMap;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.sink.StructureSink;
import org.codehaus.plexus.util.StringUtils;

public class XhtmlSink
extends AbstractXhtmlSink {
    private StringBuffer buffer = new StringBuffer();
    private boolean headFlag;
    private int itemFlag;
    private boolean verbatimFlag;
    private int cellCount;
    private PrintWriter writer;
    private StringsMap directives;
    private RenderingContext renderingContext;
    private int[] cellJustif;
    private int rowMarker = 0;

    public XhtmlSink(Writer writer, RenderingContext renderingContext, Map directives) {
        this.writer = new PrintWriter(writer);
        this.directives = new StringsMap(directives);
        this.renderingContext = renderingContext;
    }

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected void setHeadFlag(boolean headFlag) {
        this.headFlag = headFlag;
    }

    protected void resetState() {
        this.headFlag = false;
        this.resetBuffer();
        this.itemFlag = 0;
        this.verbatimFlag = false;
        this.cellCount = 0;
    }

    protected void resetBuffer() {
        this.buffer = new StringBuffer();
    }

    public void head() {
        this.directive("head()");
        this.resetState();
        this.headFlag = true;
    }

    public void head_() {
        this.headFlag = false;
        this.directive("head_()");
    }

    public void title() {
        this.write("<title>");
    }

    public void title_() {
        this.write(this.buffer.toString());
        this.write("</title>");
        this.resetBuffer();
    }

    public void author_() {
        if (this.buffer.length() > 0) {
            this.write("<meta name=\"author\" content=\"");
            this.write(this.buffer.toString());
            this.write("\" />\n");
            this.resetBuffer();
        }
    }

    public void date_() {
        if (this.buffer.length() > 0) {
            this.write("<meta name=\"date\" content=\"");
            this.write(this.buffer.toString());
            this.write("\" />\n");
            this.resetBuffer();
        }
    }

    public void body() {
        String body = this.directiveValue("body()");
        this.write(body);
    }

    public void body_() {
        String body = this.directiveValue("body_()");
        this.write(body);
        this.resetState();
    }

    public void section1() {
        this.write("<div class=\"section\">");
    }

    public void section2() {
        this.write("<div class=\"section\">");
    }

    public void section3() {
        this.write("<div class=\"section\">");
    }

    public void section4() {
        this.write("<div class=\"section\">");
    }

    public void section5() {
        this.write("<div class=\"section\">");
    }

    public void section1_() {
        this.write("</div>");
    }

    public void section2_() {
        this.write("</div>");
    }

    public void section3_() {
        this.write("</div>");
    }

    public void section4_() {
        this.write("</div>");
    }

    public void section5_() {
        this.write("</div>");
    }

    public void sectionTitle1() {
        this.write("<h2>");
    }

    public void sectionTitle1_() {
        this.write("</h2>");
    }

    public void sectionTitle2() {
        this.write("<h3>");
    }

    public void sectionTitle2_() {
        this.write("</h3>");
    }

    public void sectionTitle3() {
        this.write("<h4>");
    }

    public void sectionTitle3_() {
        this.write("</h4>");
    }

    public void sectionTitle4() {
        this.write("<h5>");
    }

    public void sectionTitle4_() {
        this.write("</h5>");
    }

    public void sectionTitle5() {
        this.write("<h6>");
    }

    public void sectionTitle5_() {
        this.write("</h6>");
    }

    public void list() {
        this.write("<ul>");
    }

    public void list_() {
        this.write("</ul>");
    }

    public void listItem() {
        this.write("<li>");
        ++this.itemFlag;
    }

    public void listItem_() {
        this.write("</li>");
    }

    public void numberedList(int numbering) {
        this.write("<ol>");
    }

    public void numberedList_() {
        this.write("</ol>");
    }

    public void numberedListItem() {
        this.write("<li>");
        ++this.itemFlag;
    }

    public void numberedListItem_() {
        this.write("</li>");
    }

    public void definitionList() {
        this.write("<dl>");
    }

    public void definitionList_() {
        this.write("</dl>");
    }

    public void definedTerm() {
        this.write("<dt>");
    }

    public void definedTerm_() {
        this.write("</dt>");
    }

    public void definition() {
        this.write("<dd>");
        ++this.itemFlag;
    }

    public void definition_() {
        this.write("</dd>");
    }

    public void paragraph() {
        if (this.itemFlag == 0) {
            this.write("<p>");
        }
    }

    public void paragraph_() {
        if (this.itemFlag == 0) {
            this.write("</p>");
        } else {
            --this.itemFlag;
        }
    }

    public void verbatim(boolean boxed) {
        this.verbatimFlag = true;
        this.write("<div class=\"source\"><pre>");
    }

    public void verbatim_() {
        this.write("</pre></div>");
        this.verbatimFlag = false;
    }

    public void horizontalRule() {
        this.write("<hr />");
    }

    public void table() {
        this.write("<table class=\"bodyTable\">");
    }

    public void table_() {
        this.write("</table>");
    }

    public void tableRows(int[] justification, boolean grid) {
        this.write("<tbody>");
        this.cellJustif = justification;
    }

    public void tableRows_() {
        this.write("</tbody>");
        this.cellJustif = null;
    }

    public void tableRow() {
        if (this.rowMarker == 0) {
            this.write("<tr class=\"a\">");
            this.rowMarker = 1;
        } else {
            this.write("<tr class=\"b\">");
            this.rowMarker = 0;
        }
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.write("</tr>");
        this.cellCount = 0;
    }

    public void tableCell() {
        this.tableCell(false);
    }

    public void tableHeaderCell() {
        this.tableCell(true);
    }

    public void tableCell(boolean headerRow) {
        String justif = null;
        if (this.cellJustif != null) {
            switch (this.cellJustif[this.cellCount]) {
                case 1: {
                    justif = "left";
                    break;
                }
                case 2: {
                    justif = "right";
                    break;
                }
                case 0: {
                    justif = "center";
                }
            }
        }
        if (headerRow) {
            this.write("<th");
        } else {
            this.write("<td");
        }
        if (justif != null) {
            this.write(" align=\"" + justif + "\"");
        }
        this.write(">");
    }

    public void tableCell(String width) {
        this.tableCell(false, width);
    }

    public void tableHeaderCell(String width) {
        this.tableCell(true, width);
    }

    public void tableCell(boolean headerRow, String width) {
        String justif = null;
        if (this.cellJustif != null) {
            switch (this.cellJustif[this.cellCount]) {
                case 1: {
                    justif = "left";
                    break;
                }
                case 2: {
                    justif = "right";
                    break;
                }
                case 0: {
                    justif = "center";
                }
            }
        }
        String cellWidth = "width=\"" + width + "\"";
        if (headerRow) {
            this.write("<th ");
        } else {
            this.write("<td ");
        }
        if (justif != null) {
            this.write(" align=\"" + justif + "\"");
        }
        this.write(cellWidth + " >");
    }

    public void tableCell_() {
        this.tableCell_(false);
    }

    public void tableHeaderCell_() {
        this.tableCell_(true);
    }

    public void tableCell_(boolean headerRow) {
        if (headerRow) {
            this.write("</th>");
        } else {
            this.write("</td>");
        }
        ++this.cellCount;
    }

    public void tableCaption() {
        this.write("<caption>");
    }

    public void tableCaption_() {
        this.write("</caption>");
    }

    public void figure() {
        this.write("<img");
    }

    public void figure_() {
        this.write(" />");
    }

    public void figureCaption() {
        this.write(" alt=\"");
    }

    public void figureCaption_() {
        this.write("\"");
    }

    public void figureGraphics(String name) {
        this.write(" src=\"" + name + "\"");
    }

    public void anchor(String name) {
        if (!this.headFlag) {
            if (name != null && !name.startsWith("#")) {
                this.write("<a name=\"#" + name + "\">");
            } else {
                this.write("<a name=\"" + name + "\">");
            }
        }
    }

    public void anchor_() {
        if (!this.headFlag) {
            this.write("</a>");
        }
    }

    public void link(String name) {
        if (!this.headFlag) {
            this.write("<a href=\"" + name + "\">");
        }
    }

    public void link(String name, String target) {
        if (!this.headFlag) {
            this.write("<a href=\"" + name + "\" target=\"" + target + "\">");
        }
    }

    public void link_() {
        if (!this.headFlag) {
            this.write("</a>");
        }
    }

    public void italic() {
        if (!this.headFlag) {
            this.write("<i>");
        }
    }

    public void italic_() {
        if (!this.headFlag) {
            this.write("</i>");
        }
    }

    public void bold() {
        if (!this.headFlag) {
            this.write("<b>");
        }
    }

    public void bold_() {
        if (!this.headFlag) {
            this.write("</b>");
        }
    }

    public void monospaced() {
        if (!this.headFlag) {
            this.write("<tt>");
        }
    }

    public void monospaced_() {
        if (!this.headFlag) {
            this.write("</tt>");
        }
    }

    public void lineBreak() {
        if (this.headFlag) {
            this.buffer.append('\n');
        } else {
            this.write("<br />");
        }
    }

    public void nonBreakingSpace() {
        if (this.headFlag) {
            this.buffer.append(' ');
        } else {
            this.write("&#160;");
        }
    }

    public void text(String text) {
        if (this.headFlag) {
            this.buffer.append(text);
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    public void rawText(String text) {
        this.write(text);
    }

    protected void write(String text) {
        String relativePathToBasedir = this.renderingContext.getRelativePath();
        text = relativePathToBasedir != null ? StringUtils.replace((String)text, (String)"$relativePath", (String)relativePathToBasedir) : StringUtils.replace((String)text, (String)"$relativePath", (String)".");
        this.writer.write(text);
    }

    protected String directiveValue(String key) {
        return this.directives.get(key);
    }

    protected void directive(String key) {
        this.write(this.directives.get(key));
    }

    protected void content(String text) {
        this.write(XhtmlSink.escapeHTML(text));
    }

    protected void verbatimContent(String text) {
        this.write(XhtmlSink.escapeHTML(text));
    }

    public static String escapeHTML(String text) {
        return HtmlTools.escapeHTML(text);
    }

    public static String encodeFragment(String text) {
        return XhtmlSink.encodeURL(StructureSink.linkToKey(text));
    }

    public static String encodeURL(String text) {
        return HtmlTools.encodeURL(text);
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }

    public RenderingContext getRenderingContext() {
        return this.renderingContext;
    }
}

