/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.rtf;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.maven.doxia.module.rtf.AlphaNumerals;
import org.apache.maven.doxia.module.rtf.Font;
import org.apache.maven.doxia.module.rtf.PBMReader;
import org.apache.maven.doxia.module.rtf.RomanNumerals;
import org.apache.maven.doxia.module.rtf.WMFWriter;
import org.apache.maven.doxia.sink.SinkAdapter;

public class RtfSink
extends SinkAdapter {
    private static final String EOL = System.getProperty("line.separator");
    public static final double DEFAULT_PAPER_WIDTH = 21.0;
    public static final double DEFAULT_PAPER_HEIGHT = 29.7;
    public static final double DEFAULT_TOP_MARGIN = 2.0;
    public static final double DEFAULT_BOTTOM_MARGIN = 2.0;
    public static final double DEFAULT_LEFT_MARGIN = 2.0;
    public static final double DEFAULT_RIGHT_MARGIN = 2.0;
    public static final int DEFAULT_FONT_SIZE = 10;
    public static final int DEFAULT_SPACING = 10;
    public static final int DEFAULT_RESOLUTION = 72;
    public static final String DEFAULT_IMAGE_FORMAT = "bmp";
    public static final String DEFAULT_IMAGE_TYPE = "palette";
    public static final String DEFAULT_DATA_FORMAT = "ascii";
    public static final int DEFAULT_CODE_PAGE = 1252;
    public static final int DEFAULT_CHAR_SET = 0;
    public static final String IMG_FORMAT_BMP = "bmp";
    public static final String IMG_FORMAT_WMF = "wmf";
    public static final String IMG_TYPE_PALETTE = "palette";
    public static final String IMG_TYPE_RGB = "rgb";
    public static final String IMG_DATA_ASCII = "ascii";
    public static final String IMG_DATA_RAW = "raw";
    public static final int STYLE_ROMAN = 0;
    public static final int STYLE_ITALIC = 1;
    public static final int STYLE_BOLD = 2;
    public static final int STYLE_TYPEWRITER = 3;
    private static final int CONTEXT_UNDEFINED = 0;
    private static final int CONTEXT_VERBATIM = 1;
    private static final int CONTEXT_TABLE = 2;
    private static final int UNIT_MILLIMETER = 1;
    private static final int UNIT_CENTIMETER = 2;
    private static final int UNIT_INCH = 3;
    private static final int UNIT_PIXEL = 4;
    private static final int LIST_INDENT = 300;
    private static final String LIST_ITEM_HEADER = "-  ";
    private static final int DEFINITION_INDENT = 300;
    private static final int CELL_HORIZONTAL_PAD = 60;
    private static final int CELL_VERTICAL_PAD = 20;
    private static final int BORDER_WIDTH = 15;
    private double paperWidth = 21.0;
    private double paperHeight = 29.7;
    private double topMargin = 2.0;
    private double bottomMargin = 2.0;
    private double leftMargin = 2.0;
    private double rightMargin = 2.0;
    private int fontSize = 10;
    private int resolution = 72;
    private String imageFormat = "bmp";
    private String imageType = "palette";
    private String imageDataFormat = "ascii";
    private boolean imageCompression = true;
    private int codePage = 1252;
    private int charSet = 0;
    private Hashtable fontTable = new Hashtable();
    private Context context = new Context();
    private Paragraph paragraph;
    private Indentation indentation = new Indentation(0);
    private Space space = new Space(200);
    private int listItemIndent;
    private Vector numbering = new Vector();
    private Vector itemNumber = new Vector();
    private int style = 0;
    private int sectionLevel;
    private boolean emptyHeader;
    private StringBuffer verbatim;
    boolean frame;
    private Table table;
    private Row row;
    private Cell cell;
    private Line line;
    protected PrintWriter writer;
    protected OutputStream stream;

    public RtfSink() throws IOException {
        this(System.out);
    }

    public RtfSink(OutputStream output) throws IOException {
        this(output, null);
    }

    public RtfSink(OutputStream output, String encoding) throws IOException {
        Font font = this.getFont(2, this.fontSize);
        if (font != null) {
            this.listItemIndent = RtfSink.textWidth(LIST_ITEM_HEADER, font);
        }
        this.stream = new BufferedOutputStream(output);
        OutputStreamWriter w = encoding != null ? new OutputStreamWriter(this.stream, encoding) : new OutputStreamWriter(this.stream);
        this.writer = new PrintWriter(new BufferedWriter(w));
    }

    public void setPaperSize(double width, double height) {
        this.paperWidth = width;
        this.paperHeight = height;
    }

    public void setTopMargin(double margin) {
        this.topMargin = margin;
    }

    public void setBottomMargin(double margin) {
        this.bottomMargin = margin;
    }

    public void setLeftMargin(double margin) {
        this.leftMargin = margin;
    }

    public void setRightMargin(double margin) {
        this.rightMargin = margin;
    }

    public void setFontSize(int size) {
        this.fontSize = size;
    }

    public void setSpacing(int spacing) {
        this.space.set(20 * spacing);
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public void setImageFormat(String format) {
        this.imageFormat = format;
    }

    public void setImageType(String type) {
        this.imageType = type;
    }

    public void setImageDataFormat(String format) {
        this.imageDataFormat = format;
    }

    public void setImageCompression(boolean compression) {
        this.imageCompression = compression;
    }

    public void setCodePage(int cp) {
        this.codePage = cp;
    }

    public void setCharSet(int cs) {
        this.charSet = cs;
    }

    public void head() {
        this.writer.println("{\\rtf1\\ansi\\ansicpg" + this.codePage + "\\deff0");
        this.writer.println("{\\fonttbl");
        this.writer.println("{\\f0\\froman\\fcharset" + this.charSet + " Times;}");
        this.writer.println("{\\f1\\fmodern\\fcharset" + this.charSet + " Courier;}");
        this.writer.println("}");
        this.writer.println("{\\stylesheet");
        for (int level = 1; level <= 5; ++level) {
            this.writer.print("{\\s" + this.styleNumber(level));
            this.writer.print("\\outlinelevel" + level);
            this.writer.print(" Section Title " + level);
            this.writer.println(";}");
        }
        this.writer.println("}");
        this.writer.println("\\paperw" + this.toTwips(this.paperWidth, 2));
        this.writer.println("\\paperh" + this.toTwips(this.paperHeight, 2));
        this.writer.println("\\margl" + this.toTwips(this.leftMargin, 2));
        this.writer.println("\\margr" + this.toTwips(this.rightMargin, 2));
        this.writer.println("\\margt" + this.toTwips(this.topMargin, 2));
        this.writer.println("\\margb" + this.toTwips(this.bottomMargin, 2));
        this.space.set(this.space.get() / 2);
        this.space.setNext(0);
        this.emptyHeader = true;
    }

    public void head_() {
        this.space.restore();
        if (this.emptyHeader) {
            this.space.setNext(0);
        } else {
            this.space.setNext(2 * this.space.get());
        }
    }

    private int toTwips(double length, int unit) {
        double points;
        switch (unit) {
            case 1: {
                points = length / 25.4 * 72.0;
                break;
            }
            case 2: {
                points = length / 2.54 * 72.0;
                break;
            }
            case 3: {
                points = length * 72.0;
                break;
            }
            default: {
                points = length / (double)this.resolution * 72.0;
            }
        }
        return (int)Math.rint(points * 20.0);
    }

    public void title() {
        Paragraph paragraph = new Paragraph(2, this.fontSize + 6);
        paragraph.justification = 0;
        this.beginParagraph(paragraph);
        this.emptyHeader = false;
    }

    public void title_() {
        this.endParagraph();
    }

    public void author() {
        Paragraph paragraph = new Paragraph(0, this.fontSize + 2);
        paragraph.justification = 0;
        this.beginParagraph(paragraph);
        this.emptyHeader = false;
    }

    public void author_() {
        this.endParagraph();
    }

    public void date() {
        Paragraph paragraph = new Paragraph(0, this.fontSize);
        paragraph.justification = 0;
        this.beginParagraph(paragraph);
        this.emptyHeader = false;
    }

    public void date_() {
        this.endParagraph();
    }

    public void body() {
    }

    public void body_() {
        this.writer.println("}");
        this.writer.flush();
    }

    public void section1() {
        this.sectionLevel = 1;
    }

    public void section1_() {
    }

    public void section2() {
        this.sectionLevel = 2;
    }

    public void section2_() {
    }

    public void section3() {
        this.sectionLevel = 3;
    }

    public void section3_() {
    }

    public void section4() {
        this.sectionLevel = 4;
    }

    public void section4_() {
    }

    public void section5() {
        this.sectionLevel = 5;
    }

    public void section5_() {
    }

    public void sectionTitle() {
        int style = 2;
        int size = this.fontSize;
        switch (this.sectionLevel) {
            case 1: {
                size = this.fontSize + 6;
                break;
            }
            case 2: {
                size = this.fontSize + 4;
                break;
            }
            case 3: {
                size = this.fontSize + 2;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                style = 0;
            }
        }
        Paragraph paragraph = new Paragraph(style, size);
        paragraph.style = this.styleNumber(this.sectionLevel);
        this.beginParagraph(paragraph);
    }

    public void sectionTitle_() {
        this.endParagraph();
    }

    private int styleNumber(int level) {
        return level;
    }

    public void list() {
        this.indentation.add(300);
        this.space.set(this.space.get() / 2);
    }

    public void list_() {
        this.indentation.restore();
        this.space.restore();
    }

    public void listItem() {
        Paragraph paragraph = new Paragraph();
        paragraph.leftIndent = this.indentation.get() + this.listItemIndent;
        paragraph.firstLineIndent = -this.listItemIndent;
        this.beginParagraph(paragraph);
        this.beginStyle(2);
        this.writer.println(LIST_ITEM_HEADER);
        this.endStyle();
        this.indentation.add(this.listItemIndent);
        this.space.set(this.space.get() / 2);
    }

    public void listItem_() {
        this.endParagraph();
        this.indentation.restore();
        this.space.restore();
    }

    public void numberedList(int numbering) {
        this.numbering.addElement(new Integer(numbering));
        this.itemNumber.addElement(new Counter(0));
        this.indentation.add(300);
        this.space.set(this.space.get() / 2);
    }

    public void numberedList_() {
        this.numbering.removeElementAt(this.numbering.size() - 1);
        this.itemNumber.removeElementAt(this.itemNumber.size() - 1);
        this.indentation.restore();
        this.space.restore();
    }

    public void numberedListItem() {
        ((Counter)this.itemNumber.lastElement()).increment();
        int indent = 0;
        String header = this.getItemHeader();
        Font font = this.getFont(3, this.fontSize);
        if (font != null) {
            indent = RtfSink.textWidth(header, font);
        }
        Paragraph paragraph = new Paragraph();
        paragraph.leftIndent = this.indentation.get() + indent;
        paragraph.firstLineIndent = -indent;
        this.beginParagraph(paragraph);
        this.beginStyle(3);
        this.writer.println(header);
        this.endStyle();
        this.indentation.add(indent);
        this.space.set(this.space.get() / 2);
    }

    public void numberedListItem_() {
        this.endParagraph();
        this.indentation.restore();
        this.space.restore();
    }

    private String getItemHeader() {
        int numbering = (Integer)this.numbering.lastElement();
        int itemNumber = ((Counter)this.itemNumber.lastElement()).get();
        StringBuffer buf = new StringBuffer();
        switch (numbering) {
            default: {
                buf.append(itemNumber);
                buf.append(". ");
                while (buf.length() < 4) {
                    buf.append(' ');
                }
                break;
            }
            case 1: {
                buf.append(AlphaNumerals.toString(itemNumber, true));
                buf.append(") ");
                break;
            }
            case 2: {
                buf.append(AlphaNumerals.toString(itemNumber, false));
                buf.append(". ");
                break;
            }
            case 3: {
                buf.append(RomanNumerals.toString(itemNumber, true));
                buf.append(") ");
                while (buf.length() < 6) {
                    buf.append(' ');
                }
                break;
            }
            case 4: {
                buf.append(RomanNumerals.toString(itemNumber, false));
                buf.append(". ");
                while (buf.length() < 6) {
                    buf.append(' ');
                }
                break block0;
            }
        }
        return buf.toString();
    }

    public void definitionList() {
        int next = this.space.getNext();
        this.indentation.add(300);
        this.space.set(this.space.get() / 2);
        this.space.setNext(next);
    }

    public void definitionList_() {
        this.indentation.restore();
        this.space.restore();
    }

    public void definitionListItem() {
        int next = this.space.getNext();
        this.space.set(this.space.get() / 2);
        this.space.setNext(next);
    }

    public void definitionListItem_() {
        this.space.restore();
    }

    public void definedTerm() {
    }

    public void definedTerm_() {
        this.endParagraph();
    }

    public void definition() {
        int next = this.space.getNext();
        this.indentation.add(300);
        this.space.set(this.space.get() / 2);
        this.space.setNext(next);
    }

    public void definition_() {
        this.endParagraph();
        this.indentation.restore();
        this.space.restore();
    }

    public void table() {
    }

    public void table_() {
    }

    public void tableRows(int[] justification, boolean grid) {
        this.table = new Table(justification, grid);
        this.context.set(2);
    }

    public void tableRows_() {
        boolean bb = false;
        boolean br = false;
        int offset = (this.pageWidth() - (this.table.width() + this.indentation.get())) / 2;
        int x0 = this.indentation.get() + offset;
        this.space.skip();
        for (int i = 0; i < this.table.rows.size(); ++i) {
            int j;
            Row row = (Row)this.table.rows.elementAt(i);
            this.writer.print("\\trowd");
            this.writer.print("\\trleft" + x0);
            this.writer.print("\\trgaph60");
            this.writer.println("\\trrh" + row.height());
            if (this.table.grid) {
                if (i == this.table.rows.size() - 1) {
                    bb = true;
                }
                br = false;
            }
            int x = x0;
            for (j = 0; j < this.table.numColumns; ++j) {
                if (this.table.grid) {
                    if (j == this.table.numColumns - 1) {
                        br = true;
                    }
                    this.setBorder(true, bb, true, br);
                    x += 15;
                }
                this.writer.println("\\clvertalc\\cellx" + (x += this.table.columnWidths[j]));
            }
            for (j = 0; j < this.table.numColumns && j < row.cells.size(); ++j) {
                Cell cell = (Cell)row.cells.elementAt(j);
                this.writer.print("\\pard\\intbl");
                this.setJustification(this.table.justification[j]);
                this.writer.println("\\plain\\f0\\fs" + 2 * this.fontSize);
                for (int k = 0; k < cell.lines.size(); ++k) {
                    if (k > 0) {
                        this.writer.println("\\line");
                    }
                    Line line = (Line)cell.lines.elementAt(k);
                    for (int n = 0; n < line.items.size(); ++n) {
                        Item item = (Item)line.items.elementAt(n);
                        this.writer.print("{");
                        this.setStyle(item.style);
                        this.writer.println(RtfSink.escape(item.text));
                        this.writer.println("}");
                    }
                }
                this.writer.println("\\cell");
            }
            this.writer.println("\\row");
        }
        this.context.restore();
    }

    private int pageWidth() {
        double width = this.paperWidth - (this.leftMargin + this.rightMargin);
        return this.toTwips(width, 2);
    }

    private void setBorder(boolean bt, boolean bb, boolean bl, boolean br) {
        if (bt) {
            this.writer.println("\\clbrdrt\\brdrs\\brdrw15");
        }
        if (bb) {
            this.writer.println("\\clbrdrb\\brdrs\\brdrw15");
        }
        if (bl) {
            this.writer.println("\\clbrdrl\\brdrs\\brdrw15");
        }
        if (br) {
            this.writer.println("\\clbrdrr\\brdrs\\brdrw15");
        }
    }

    private void setJustification(int justification) {
        switch (justification) {
            default: {
                this.writer.println("\\ql");
                break;
            }
            case 0: {
                this.writer.println("\\qc");
                break;
            }
            case 2: {
                this.writer.println("\\qr");
            }
        }
    }

    private void setStyle(int style) {
        switch (style) {
            case 1: {
                this.writer.println("\\i");
                break;
            }
            case 2: {
                this.writer.println("\\b");
                break;
            }
            case 3: {
                this.writer.println("\\f1");
                break;
            }
        }
    }

    public void tableRow() {
        this.row = new Row();
    }

    public void tableRow_() {
        this.table.add(this.row);
    }

    public void tableCell() {
        this.cell = new Cell();
        this.line = new Line();
    }

    public void tableCell_() {
        this.cell.add(this.line);
        this.row.add(this.cell);
    }

    public void tableCaption() {
        Paragraph paragraph = new Paragraph();
        paragraph.justification = 0;
        paragraph.spaceBefore /= 2;
        this.beginParagraph(paragraph);
    }

    public void tableCaption_() {
        this.endParagraph();
    }

    public void paragraph() {
        if (this.paragraph == null) {
            this.beginParagraph(new Paragraph());
        }
    }

    public void paragraph_() {
        this.endParagraph();
    }

    private void beginParagraph(Paragraph paragraph) {
        paragraph.begin();
        this.paragraph = paragraph;
        if (this.style != 0) {
            this.beginStyle(this.style);
        }
    }

    private void endParagraph() {
        if (this.paragraph != null) {
            if (this.style != 0) {
                this.endStyle();
            }
            this.paragraph.end();
            this.paragraph = null;
        }
    }

    public void verbatim(boolean boxed) {
        this.verbatim = new StringBuffer();
        this.frame = boxed;
        this.context.set(1);
    }

    public void verbatim_() {
        String text = this.verbatim.toString();
        Paragraph paragraph = new Paragraph();
        paragraph.fontStyle = 3;
        paragraph.frame = this.frame;
        this.beginParagraph(paragraph);
        StringTokenizer t = new StringTokenizer(text, EOL, true);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (s.equals(EOL) && t.hasMoreTokens()) {
                this.writer.println("\\line");
                continue;
            }
            this.writer.println(RtfSink.escape(s));
        }
        this.endParagraph();
        this.context.restore();
    }

    public void figure() {
    }

    public void figure_() {
    }

    public void figureGraphics(String name) {
        StringBuffer buf = new StringBuffer(name);
        buf.append(".ppm");
        name = buf.toString();
        Paragraph paragraph = new Paragraph();
        paragraph.justification = 0;
        this.beginParagraph(paragraph);
        try {
            this.writeImage(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
        this.endParagraph();
    }

    private void writeImage(String source) throws Exception {
        int bytesPerLine;
        PBMReader ppm = new PBMReader(source);
        WMFWriter.Dib dib = new WMFWriter.Dib();
        WMFWriter wmf = new WMFWriter();
        int srcWidth = ppm.width();
        int srcHeight = ppm.height();
        dib.biWidth = srcWidth;
        dib.biHeight = srcHeight;
        dib.biYPelsPerMeter = dib.biXPelsPerMeter = (int)((double)this.resolution * 100.0 / 2.54);
        if (this.imageType.equals(IMG_TYPE_RGB)) {
            dib.biBitCount = (short)24;
            dib.biCompression = 0;
            bytesPerLine = 4 * ((3 * srcWidth + 3) / 4);
            dib.bitmap = new byte[srcHeight * bytesPerLine];
            byte[] line = new byte[3 * srcWidth];
            for (int i = srcHeight - 1; i >= 0; --i) {
                ppm.read(line, 0, line.length);
                int k = i * bytesPerLine;
                for (int j = 0; j < line.length; j += 3) {
                    dib.bitmap[k++] = line[j + 2];
                    dib.bitmap[k++] = line[j + 1];
                    dib.bitmap[k++] = line[j];
                }
            }
        } else {
            int j;
            int i;
            dib.biBitCount = (short)8;
            bytesPerLine = 4 * ((srcWidth + 3) / 4);
            byte[] bitmap = new byte[srcHeight * bytesPerLine];
            Vector<Color> colors = new Vector<Color>(256);
            colors.addElement(Color.white);
            colors.addElement(Color.black);
            byte[] line = new byte[3 * srcWidth];
            for (i = srcHeight - 1; i >= 0; --i) {
                ppm.read(line, 0, line.length);
                j = 0;
                int k = i * bytesPerLine;
                while (j < line.length) {
                    int b;
                    int g;
                    Color color;
                    int index;
                    int r = line[j++] & 0xFF;
                    if ((index = colors.indexOf(color = new Color(r, g = line[j++] & 0xFF, b = line[j++] & 0xFF))) < 0) {
                        if (colors.size() < colors.capacity()) {
                            colors.addElement(color);
                            index = colors.size() - 1;
                        } else {
                            index = 1;
                        }
                    }
                    bitmap[k++] = (byte)index;
                }
            }
            dib.biClrImportant = dib.biClrUsed = colors.size();
            dib.palette = new byte[4 * dib.biClrUsed];
            i = 0;
            j = 0;
            while (i < dib.biClrUsed) {
                Color color = (Color)colors.elementAt(i);
                dib.palette[j++] = (byte)color.getBlue();
                dib.palette[j++] = (byte)color.getGreen();
                dib.palette[j++] = (byte)color.getRed();
                ++i;
                ++j;
            }
            if (this.imageCompression) {
                dib.biCompression = 1;
                dib.bitmap = new byte[bitmap.length + 2 * (bitmap.length / 255 + 1)];
                dib.biSizeImage = WMFWriter.Dib.rlEncode8(bitmap, 0, bitmap.length, dib.bitmap, 0);
            } else {
                dib.biCompression = 0;
                dib.bitmap = bitmap;
            }
        }
        if (this.imageFormat.equals(IMG_FORMAT_WMF)) {
            int[] parameters = new int[]{1};
            WMFWriter.Record record = new WMFWriter.Record(259, parameters);
            wmf.add(record);
            parameters = new int[2];
            record = new WMFWriter.Record(523, parameters);
            wmf.add(record);
            parameters = new int[]{srcHeight, srcWidth};
            record = new WMFWriter.Record(524, parameters);
            wmf.add(record);
            parameters = new int[8];
            parameters[1] = 204;
            parameters[0] = 32;
            parameters[5] = srcWidth;
            parameters[4] = srcHeight;
            record = new WMFWriter.DibBitBltRecord(parameters, dib);
            wmf.add(record);
        }
        if (this.imageFormat.equals(IMG_FORMAT_WMF)) {
            this.writer.print("{\\pict\\wmetafile1");
            this.writer.println("\\picbmp\\picbpp" + dib.biBitCount);
        } else {
            this.writer.print("{\\pict\\dibitmap0\\wbmplanes1");
            this.writer.print("\\wbmbitspixel" + dib.biBitCount);
            this.writer.println("\\wbmwidthbytes" + bytesPerLine);
        }
        this.writer.print("\\picw" + srcWidth);
        this.writer.print("\\pich" + srcHeight);
        this.writer.print("\\picwgoal" + this.toTwips(srcWidth, 4));
        this.writer.println("\\pichgoal" + this.toTwips(srcHeight, 4));
        if (this.imageFormat.equals(IMG_FORMAT_WMF)) {
            if (this.imageDataFormat.equals(IMG_DATA_RAW)) {
                this.writer.print("\\bin" + 2 * wmf.size() + " ");
                this.writer.flush();
                wmf.write(this.stream);
                this.stream.flush();
            } else {
                wmf.print(this.writer);
            }
        } else if (this.imageDataFormat.equals(IMG_DATA_RAW)) {
            this.writer.print("\\bin" + 2 * dib.size() + " ");
            this.writer.flush();
            dib.write(this.stream);
            this.stream.flush();
        } else {
            dib.print(this.writer);
        }
        this.writer.println("}");
    }

    public void figureCaption() {
        Paragraph paragraph = new Paragraph();
        paragraph.justification = 0;
        paragraph.spaceBefore /= 2;
        this.beginParagraph(paragraph);
    }

    public void figureCaption_() {
        this.endParagraph();
    }

    public void horizontalRule() {
        this.writer.print("\\pard\\li" + this.indentation.get());
        int skip = this.space.getNext();
        if (skip > 0) {
            this.writer.print("\\sb" + skip);
        }
        this.space.setNext(skip);
        this.writer.print("\\brdrb\\brdrs\\brdrw15");
        this.writer.println("\\plain\\fs1\\par");
    }

    public void pageBreak() {
        this.writer.println("\\page");
    }

    public void anchor(String name) {
    }

    public void anchor_() {
    }

    public void link(String name) {
    }

    public void link_() {
    }

    public void italic() {
        this.beginStyle(1);
    }

    public void italic_() {
        this.endStyle();
    }

    public void bold() {
        this.beginStyle(2);
    }

    public void bold_() {
        this.endStyle();
    }

    public void monospaced() {
        this.beginStyle(3);
    }

    public void monospaced_() {
        this.endStyle();
    }

    private void beginStyle(int style) {
        this.style = style;
        block0 : switch (this.context.get()) {
            case 2: {
                break;
            }
            default: {
                if (this.paragraph == null) break;
                switch (style) {
                    case 1: {
                        this.writer.println("{\\i");
                        break block0;
                    }
                    case 2: {
                        this.writer.println("{\\b");
                        break block0;
                    }
                    case 3: {
                        this.writer.println("{\\f1");
                        break block0;
                    }
                }
                this.writer.println("{");
            }
        }
    }

    private void endStyle() {
        this.style = 0;
        switch (this.context.get()) {
            case 2: {
                break;
            }
            default: {
                if (this.paragraph == null) break;
                this.writer.println("}");
            }
        }
    }

    public void lineBreak() {
        switch (this.context.get()) {
            case 2: {
                this.cell.add(this.line);
                this.line = new Line();
                break;
            }
            default: {
                this.writer.println("\\line");
            }
        }
    }

    public void nonBreakingSpace() {
        switch (this.context.get()) {
            case 2: {
                this.line.add(new Item(this.style, " "));
                break;
            }
            default: {
                this.writer.println("\\~");
            }
        }
    }

    public void text(String text) {
        switch (this.context.get()) {
            case 1: {
                this.verbatim.append(text);
                break;
            }
            case 2: {
                StringTokenizer t = new StringTokenizer(text, EOL, true);
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    if (token.equals(EOL)) {
                        this.cell.add(this.line);
                        this.line = new Line();
                        continue;
                    }
                    this.line.add(new Item(this.style, RtfSink.normalize(token)));
                }
                break;
            }
            default: {
                if (this.paragraph == null) {
                    this.beginParagraph(new Paragraph());
                }
                this.writer.println(RtfSink.escape(RtfSink.normalize(text)));
            }
        }
    }

    private static String normalize(String s) {
        int length = s.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                if (buffer.length() != 0 && buffer.charAt(buffer.length() - 1) == ' ') continue;
                buffer.append(' ');
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String escape(String s) {
        int length = s.length();
        StringBuffer buffer = new StringBuffer(length);
        block5: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block5;
                }
                case '{': {
                    buffer.append("\\{");
                    continue block5;
                }
                case '}': {
                    buffer.append("\\}");
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private Font getFont(int style, int size) {
        Font font = null;
        StringBuffer buf = new StringBuffer();
        buf.append(style);
        buf.append(size);
        String key = buf.toString();
        Object object = this.fontTable.get(key);
        if (object == null) {
            try {
                font = new Font(style, size);
                this.fontTable.put(key, font);
            }
            catch (Exception ignored) {}
        } else {
            font = (Font)object;
        }
        return font;
    }

    private static int textWidth(String text, Font font) {
        int width = 0;
        StringTokenizer t = new StringTokenizer(text, EOL);
        while (t.hasMoreTokens()) {
            int w = font.textExtents((String)t.nextToken()).width;
            if (w <= width) continue;
            width = w;
        }
        return width;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }

    static /* synthetic */ Indentation access$400(RtfSink x0) {
        return x0.indentation;
    }

    static /* synthetic */ Space access$500(RtfSink x0) {
        return x0.space;
    }

    private class Box {
        int width;
        int height;

        Box(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    private class Item {
        int style;
        String text;

        Item(int style, String text) {
            this.style = style;
            this.text = text;
        }
    }

    private class Line {
        Vector items = new Vector();

        private Line() {
        }

        void add(Item item) {
            this.items.addElement(item);
        }
    }

    private class Cell {
        Vector lines = new Vector();

        private Cell() {
        }

        void add(Line line) {
            this.lines.addElement(line);
        }

        Box boundingBox() {
            int width = 0;
            int height = 0;
            for (int i = 0; i < this.lines.size(); ++i) {
                int w = 0;
                int h = 0;
                Line line = (Line)this.lines.elementAt(i);
                for (int j = 0; j < line.items.size(); ++j) {
                    Item item = (Item)line.items.elementAt(j);
                    Font font = RtfSink.this.getFont(item.style, RtfSink.this.fontSize);
                    if (font == null) continue;
                    Font.TextExtents x = font.textExtents(item.text);
                    w += x.width;
                    if (x.height <= h) continue;
                    h = x.height;
                }
                if (w > width) {
                    width = w;
                }
                height += h;
            }
            width += 120;
            return new Box(width += RtfSink.this.toTwips(1.0, 4), height += 40);
        }
    }

    private class Row {
        Vector cells = new Vector();

        private Row() {
        }

        void add(Cell cell) {
            this.cells.addElement(cell);
        }

        int height() {
            int height = 0;
            int numCells = this.cells.size();
            for (int i = 0; i < numCells; ++i) {
                Cell cell = (Cell)this.cells.elementAt(i);
                Box box = cell.boundingBox();
                if (box.height <= height) continue;
                height = box.height;
            }
            return height;
        }
    }

    private class Table {
        int numColumns;
        int[] columnWidths;
        int[] justification;
        boolean grid;
        Vector rows;

        Table(int[] justification, boolean grid) {
            this.numColumns = justification.length;
            this.columnWidths = new int[this.numColumns];
            this.justification = justification;
            this.grid = grid;
            this.rows = new Vector();
        }

        void add(Row row) {
            this.rows.addElement(row);
            for (int i = 0; i < this.numColumns && i < row.cells.size(); ++i) {
                Cell cell = (Cell)row.cells.elementAt(i);
                int width = cell.boundingBox().width;
                if (width <= this.columnWidths[i]) continue;
                this.columnWidths[i] = width;
            }
        }

        int width() {
            int width = 0;
            for (int i = 0; i < this.numColumns; ++i) {
                width += this.columnWidths[i];
            }
            if (this.grid) {
                width += (this.numColumns + 1) * 15;
            }
            return width;
        }
    }

    private class Indentation {
        private int indent;
        private Vector stack = new Vector();

        Indentation(int indent) {
            this.indent = indent;
        }

        void set(int indent) {
            this.stack.addElement(new Integer(this.indent));
            this.indent = indent;
        }

        int get() {
            return this.indent;
        }

        void restore() {
            if (!this.stack.isEmpty()) {
                this.indent = (Integer)this.stack.lastElement();
                this.stack.removeElementAt(this.stack.size() - 1);
            }
        }

        void add(int indent) {
            this.set(this.indent + indent);
        }
    }

    private class Space {
        private int space;
        private int next;
        private Vector stack = new Vector();

        Space(int space) {
            this.space = space;
            this.next = space;
        }

        void set(int space) {
            this.stack.addElement(new Integer(this.space));
            this.space = space;
            this.next = space;
        }

        int get() {
            return this.space;
        }

        void restore() {
            if (!this.stack.isEmpty()) {
                this.space = (Integer)this.stack.lastElement();
                this.stack.removeElementAt(this.stack.size() - 1);
                this.next = this.space;
            }
        }

        void setNext(int space) {
            this.next = space;
        }

        int getNext() {
            int next = this.next;
            this.next = this.space;
            return next;
        }

        void skip() {
            this.skip(this.getNext());
        }

        void skip(int space) {
            RtfSink.this.writer.print("\\pard");
            if ((space -= 10) > 0) {
                RtfSink.this.writer.print("\\sb" + space);
            }
            RtfSink.this.writer.println("\\plain\\fs1\\par");
        }
    }

    private class Paragraph {
        int style = 0;
        int justification = 1;
        int leftIndent = RtfSink.access$400(RtfSink.this).get();
        int rightIndent = 0;
        int firstLineIndent = 0;
        int spaceBefore = RtfSink.access$500(RtfSink.this).getNext();
        int spaceAfter = 0;
        boolean frame = false;
        int fontStyle = 0;
        int fontSize = RtfSink.access$600(RtfSink.this);

        Paragraph() {
        }

        Paragraph(int style, int size) {
            this.fontStyle = style;
            this.fontSize = size;
        }

        void begin() {
            RtfSink.this.writer.print("\\pard");
            if (this.style > 0) {
                RtfSink.this.writer.print("\\s" + this.style);
            }
            switch (this.justification) {
                default: {
                    break;
                }
                case 0: {
                    RtfSink.this.writer.print("\\qc");
                    break;
                }
                case 2: {
                    RtfSink.this.writer.print("\\qr");
                }
            }
            if (this.leftIndent != 0) {
                RtfSink.this.writer.print("\\li" + this.leftIndent);
            }
            if (this.rightIndent != 0) {
                RtfSink.this.writer.print("\\ri" + this.rightIndent);
            }
            if (this.firstLineIndent != 0) {
                RtfSink.this.writer.print("\\fi" + this.firstLineIndent);
            }
            if (this.spaceBefore != 0) {
                RtfSink.this.writer.print("\\sb" + this.spaceBefore);
            }
            if (this.spaceAfter != 0) {
                RtfSink.this.writer.print("\\sa" + this.spaceAfter);
            }
            if (this.frame) {
                RtfSink.this.writer.print("\\box\\brdrs\\brdrw15");
            }
            RtfSink.this.writer.print("\\plain");
            switch (this.fontStyle) {
                default: {
                    RtfSink.this.writer.print("\\f0");
                    break;
                }
                case 1: {
                    RtfSink.this.writer.print("\\f0\\i");
                    break;
                }
                case 2: {
                    RtfSink.this.writer.print("\\f0\\b");
                    break;
                }
                case 3: {
                    RtfSink.this.writer.print("\\f1");
                }
            }
            RtfSink.this.writer.println("\\fs" + 2 * this.fontSize);
        }

        void end() {
            RtfSink.this.writer.println("\\par");
        }
    }

    private class Context {
        private int context = 0;
        private Vector stack = new Vector();

        private Context() {
        }

        void set(int context) {
            this.stack.addElement(new Integer(this.context));
            this.context = context;
        }

        void restore() {
            if (!this.stack.isEmpty()) {
                this.context = (Integer)this.stack.lastElement();
                this.stack.removeElementAt(this.stack.size() - 1);
            }
        }

        int get() {
            return this.context;
        }
    }

    private class Counter {
        private int value;

        Counter(int value) {
            this.set(value);
        }

        void set(int value) {
            this.value = value;
        }

        int get() {
            return this.value;
        }

        void increment() {
            this.increment(1);
        }

        void increment(int value) {
            this.value += value;
        }
    }
}

