/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xdoc;

import java.io.Writer;
import org.apache.maven.doxia.module.HtmlTools;
import org.apache.maven.doxia.sink.SinkAdapter;
import org.apache.maven.doxia.sink.StructureSink;
import org.apache.maven.doxia.util.LineBreaker;

public class XdocSink
extends SinkAdapter {
    private static final String EOL = System.getProperty("line.separator");
    private LineBreaker out;
    private StringBuffer buffer = new StringBuffer();
    private boolean headFlag;
    private int itemFlag;
    private boolean boxedFlag;
    private boolean verbatimFlag;
    private int[] cellJustif;
    private int cellCount;
    private String section;

    public XdocSink(Writer out) {
        this.out = new LineBreaker(out);
    }

    protected void resetState() {
        this.headFlag = false;
        this.buffer = new StringBuffer();
        this.itemFlag = 0;
        this.boxedFlag = false;
        this.verbatimFlag = false;
        this.cellJustif = null;
        this.cellCount = 0;
    }

    public void head() {
        this.resetState();
        this.headFlag = true;
        this.markup("<?xml version=\"1.0\" ?>" + EOL);
        this.markup("<document>" + EOL);
        this.markup("<properties>" + EOL);
    }

    public void head_() {
        this.headFlag = false;
        this.markup("</properties>" + EOL);
    }

    public void title_() {
        if (this.buffer.length() > 0) {
            this.markup("<title>");
            this.content(this.buffer.toString());
            this.markup("</title>" + EOL);
            this.buffer = new StringBuffer();
        }
    }

    public void author_() {
        if (this.buffer.length() > 0) {
            this.markup("<author>");
            this.content(this.buffer.toString());
            this.markup("</author>" + EOL);
            this.buffer = new StringBuffer();
        }
    }

    public void date_() {
        if (this.buffer.length() > 0) {
            this.markup("<date>");
            this.content(this.buffer.toString());
            this.markup("</date>");
            this.buffer = new StringBuffer();
        }
    }

    public void body() {
        this.markup("<body>" + EOL);
    }

    public void body_() {
        this.markup("</body>" + EOL);
        this.markup("</document>" + EOL);
        this.out.flush();
        this.resetState();
    }

    public void section1() {
        this.section = "section";
    }

    public void section2() {
        this.section = "subsection";
    }

    public void section3() {
        this.section = "subsection";
    }

    public void section4() {
        this.section = "subsection";
    }

    public void section5() {
        this.section = "subsection";
    }

    public void sectionTitle() {
        this.markup("<" + this.section + " name=\"");
    }

    public void sectionTitle_() {
        this.markup("\">");
    }

    public void section1_() {
        this.markup("</section>");
    }

    public void section2_() {
        this.markup("</subsection>");
    }

    public void section3_() {
        this.markup("</subsection>");
    }

    public void section4_() {
        this.markup("</subsection>");
    }

    public void section5_() {
        this.markup("</subsection>");
    }

    public void list() {
        this.markup("<ul>" + EOL);
    }

    public void list_() {
        this.markup("</ul>");
    }

    public void listItem() {
        this.markup("<li>");
        ++this.itemFlag;
    }

    public void listItem_() {
        this.markup("</li>" + EOL);
    }

    public void numberedList(int numbering) {
        String style;
        switch (numbering) {
            case 2: {
                style = "upper-alpha";
                break;
            }
            case 1: {
                style = "lower-alpha";
                break;
            }
            case 4: {
                style = "upper-roman";
                break;
            }
            case 3: {
                style = "lower-roman";
                break;
            }
            default: {
                style = "decimal";
            }
        }
        this.markup("<ol style=\"list-style-type: " + style + "\">" + EOL);
    }

    public void numberedList_() {
        this.markup("</ol>");
    }

    public void numberedListItem() {
        this.markup("<li>");
        ++this.itemFlag;
    }

    public void numberedListItem_() {
        this.markup("</li>" + EOL);
    }

    public void definitionList() {
        this.markup("<dl compact=\"compact\">" + EOL);
    }

    public void definitionList_() {
        this.markup("</dl>");
    }

    public void definedTerm() {
        this.markup("<dt><b>");
    }

    public void definedTerm_() {
        this.markup("</b></dt>" + EOL);
    }

    public void definition() {
        this.markup("<dd>");
        ++this.itemFlag;
    }

    public void definition_() {
        this.markup("</dd>" + EOL);
    }

    public void paragraph() {
        if (this.itemFlag == 0) {
            this.markup("<p>");
        }
    }

    public void paragraph_() {
        if (this.itemFlag == 0) {
            this.markup("</p>");
        } else {
            --this.itemFlag;
        }
    }

    public void verbatim(boolean boxed) {
        this.verbatimFlag = true;
        this.boxedFlag = boxed;
        if (boxed) {
            this.markup("<source>");
        } else {
            this.markup("<pre>");
        }
    }

    public void verbatim_() {
        if (this.boxedFlag) {
            this.markup("</source>");
        } else {
            this.markup("</pre>");
        }
        this.verbatimFlag = false;
        this.boxedFlag = false;
    }

    public void horizontalRule() {
        this.markup("<hr />");
    }

    public void table() {
        this.markup("<table align=\"center\">" + EOL);
    }

    public void table_() {
        this.markup("</table>");
    }

    public void tableRows(int[] justification, boolean grid) {
        this.markup("<table align=\"center\" border=\"" + (grid ? 1 : 0) + "\">" + EOL);
        this.cellJustif = justification;
    }

    public void tableRows_() {
        this.markup("</table>");
    }

    public void tableRow() {
        this.markup("<tr valign=\"top\">" + EOL);
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.markup("</tr>" + EOL);
        this.cellCount = 0;
    }

    public void tableCell() {
        this.tableCell(false);
    }

    public void tableHeaderCell() {
        this.tableCell(true);
    }

    public void tableCell(boolean headerRow) {
        String justif = null;
        if (this.cellJustif != null) {
            switch (this.cellJustif[this.cellCount]) {
                case 1: {
                    justif = "left";
                    break;
                }
                case 2: {
                    justif = "right";
                    break;
                }
                default: {
                    justif = "center";
                }
            }
        }
        if (justif != null) {
            this.markup("<t" + (headerRow ? (char)'h' : 'd') + " align=\"" + justif + "\">");
        } else {
            this.markup("<t" + (headerRow ? (char)'h' : 'd') + ">");
        }
    }

    public void tableCell_() {
        this.tableCell_(false);
    }

    public void tableHeaderCell_() {
        this.tableCell_(true);
    }

    public void tableCell_(boolean headerRow) {
        this.markup("</t" + (headerRow ? (char)'h' : 'd') + ">" + EOL);
        ++this.cellCount;
    }

    public void tableCaption() {
        this.markup("<p><i>");
    }

    public void tableCaption_() {
        this.markup("</i></p>");
    }

    public void anchor(String name) {
        if (!this.headFlag) {
            String id = StructureSink.linkToKey(name);
            this.markup("<a id=\"" + id + "\" name=\"" + id + "\">");
        }
    }

    public void anchor_() {
        if (!this.headFlag) {
            this.markup("</a>");
        }
    }

    public void link(String name) {
        if (!this.headFlag) {
            this.markup("<a href=\"" + name + "\">");
        }
    }

    public void link_() {
        if (!this.headFlag) {
            this.markup("</a>");
        }
    }

    public void italic() {
        if (!this.headFlag) {
            this.markup("<i>");
        }
    }

    public void italic_() {
        if (!this.headFlag) {
            this.markup("</i>");
        }
    }

    public void bold() {
        if (!this.headFlag) {
            this.markup("<b>");
        }
    }

    public void bold_() {
        if (!this.headFlag) {
            this.markup("</b>");
        }
    }

    public void monospaced() {
        if (!this.headFlag) {
            this.markup("<tt>");
        }
    }

    public void monospaced_() {
        if (!this.headFlag) {
            this.markup("</tt>");
        }
    }

    public void lineBreak() {
        if (this.headFlag) {
            this.buffer.append(EOL);
        } else {
            this.markup("<br />");
        }
    }

    public void nonBreakingSpace() {
        if (this.headFlag) {
            this.buffer.append(' ');
        } else {
            this.markup("&#160;");
        }
    }

    public void text(String text) {
        if (this.headFlag) {
            this.buffer.append(text);
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    protected void markup(String text) {
        this.out.write(text, true);
    }

    protected void content(String text) {
        this.out.write(XdocSink.escapeHTML(text), false);
    }

    protected void verbatimContent(String text) {
        this.out.write(XdocSink.escapeHTML(text), true);
    }

    public static String escapeHTML(String text) {
        return HtmlTools.escapeHTML(text);
    }

    public static String encodeURL(String text) {
        return HtmlTools.encodeURL(text);
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }
}

