package org.apache.maven.doxia.sink;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Empty implementation of the <code>Sink</code> interface. Useful for testing purposes.
 *
 * @since 1.0
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @author <a href="mailto:vincent.siveton@gmail.com">Vincent Siveton</a>
 * @version $Id: SinkAdapter.java 559578 2007-07-25 20:12:56Z ltheussl $
 */
public class SinkAdapter
    implements Sink
{
    /** {@inheritDoc} */
    public void head()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void head_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void body()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void body_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section1()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section1_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section2()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section2_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section3()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section3_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section4()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section4_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section5()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void section5_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void list()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void list_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void listItem()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void listItem_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void numberedList( int numbering )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void numberedList_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void numberedListItem()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void numberedListItem_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definitionList()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definitionList_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definitionListItem()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definitionListItem_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definition()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definition_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void figure()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void figure_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void table()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void table_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableRows( int[] justification, boolean grid )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableRows_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableRow()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableRow_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void title()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void title_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void author()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void author_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void date()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void date_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle1()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle1_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle2()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle2_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle3()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle3_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle4()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle4_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle5()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void sectionTitle5_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void paragraph()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void paragraph_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void verbatim( boolean boxed )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void verbatim_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definedTerm()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void definedTerm_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void figureCaption()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void figureCaption_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableCell()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableCell( String width )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableCell_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableHeaderCell()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableHeaderCell( String width )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableHeaderCell_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableCaption()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void tableCaption_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void figureGraphics( String name )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void horizontalRule()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void pageBreak()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void anchor( String name )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void anchor_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void link( String name )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void link_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void italic()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void italic_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void bold()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void bold_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void monospaced()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void monospaced_()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void lineBreak()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void nonBreakingSpace()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void text( String text )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void rawText( String text )
    {
        // nop
    }

    /** {@inheritDoc} */
    public void flush()
    {
        // nop
    }

    /** {@inheritDoc} */
    public void close()
    {
        // nop
    }
}
