/*
 * $Id$
 */

package org.apache.maven.doxia.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Contains meta-data information for the document cover page.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentCover
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The title to appear on the cover.
     *           
     */
    private String coverTitle;

    /**
     * 
     *             a sub-title to appear on the cover.
     *           
     */
    private String coverSubTitle;

    /**
     * 
     *             The version of the project that appears on the
     * cover page.
     *           
     */
    private String coverVersion;

    /**
     * 
     *             The type of the document. This might be used on
     * the cover page to
     *             specify the type of information contained in the
     * document
     *             (eg 'User Guide', 'Manual', etc.).
     *           
     */
    private String coverType;

    /**
     * 
     *             The date to appear on the cover.
     *           
     */
    private java.util.Date coverDate;

    /**
     * Field authors.
     */
    private java.util.List/*<DocumentAuthor>*/ authors;

    /**
     * 
     *             The name of the project.
     *           
     */
    private String projectName;

    /**
     * 
     *             The location of an image file that represents
     * the project logo.
     *           
     */
    private String projectLogo;

    /**
     * 
     *             The name of the entity that is responsible for
     * the content of the
     *             document, or a copyright holder.
     *           
     */
    private String companyName;

    /**
     * 
     *             The location of an image file that represents
     * the company logo.
     *           
     */
    private String companyLogo;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addAuthor.
     * 
     * @param documentAuthor
     */
    public void addAuthor( DocumentAuthor documentAuthor )
    {
        if ( !(documentAuthor instanceof DocumentAuthor) )
        {
            throw new ClassCastException( "DocumentCover.addAuthors(documentAuthor) parameter must be instanceof " + DocumentAuthor.class.getName() );
        }
        getAuthors().add( documentAuthor );
    } //-- void addAuthor( DocumentAuthor )

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof DocumentCover ) )
        {
            return false;
        }

        DocumentCover that = (DocumentCover) other;
        boolean result = true;

        result = result && ( getCoverTitle() == null ? that.getCoverTitle() == null : getCoverTitle().equals( that.getCoverTitle() ) );
        result = result && ( getCoverSubTitle() == null ? that.getCoverSubTitle() == null : getCoverSubTitle().equals( that.getCoverSubTitle() ) );
        result = result && ( getCoverVersion() == null ? that.getCoverVersion() == null : getCoverVersion().equals( that.getCoverVersion() ) );
        result = result && ( getCoverType() == null ? that.getCoverType() == null : getCoverType().equals( that.getCoverType() ) );
        result = result && ( getCoverDate() == null ? that.getCoverDate() == null : getCoverDate().equals( that.getCoverDate() ) );
        result = result && ( getAuthors() == null ? that.getAuthors() == null : getAuthors().equals( that.getAuthors() ) );
        result = result && ( getProjectName() == null ? that.getProjectName() == null : getProjectName().equals( that.getProjectName() ) );
        result = result && ( getProjectLogo() == null ? that.getProjectLogo() == null : getProjectLogo().equals( that.getProjectLogo() ) );
        result = result && ( getCompanyName() == null ? that.getCompanyName() == null : getCompanyName().equals( that.getCompanyName() ) );
        result = result && ( getCompanyLogo() == null ? that.getCompanyLogo() == null : getCompanyLogo().equals( that.getCompanyLogo() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Method getAuthors.
     * 
     * @return List
     */
    public java.util.List/*<DocumentAuthor>*/ getAuthors()
    {
        if ( this.authors == null )
        {
            this.authors = new java.util.ArrayList/*<DocumentAuthor>*/();
        }

        return this.authors;
    } //-- java.util.List/*<DocumentAuthor>*/ getAuthors()

    /**
     * Get 
     *             The location of an image file that represents
     * the company logo.
     *           
     * 
     * @return String
     */
    public String getCompanyLogo()
    {
        return this.companyLogo;
    } //-- String getCompanyLogo()

    /**
     * Get 
     *             The name of the entity that is responsible for
     * the content of the
     *             document, or a copyright holder.
     *           
     * 
     * @return String
     */
    public String getCompanyName()
    {
        return this.companyName;
    } //-- String getCompanyName()

    /**
     * Get 
     *             The date to appear on the cover.
     *           
     * 
     * @return Date
     */
    public java.util.Date getCoverDate()
    {
        return this.coverDate;
    } //-- java.util.Date getCoverDate()

    /**
     * Get 
     *             a sub-title to appear on the cover.
     *           
     * 
     * @return String
     */
    public String getCoverSubTitle()
    {
        return this.coverSubTitle;
    } //-- String getCoverSubTitle()

    /**
     * Get 
     *             The title to appear on the cover.
     *           
     * 
     * @return String
     */
    public String getCoverTitle()
    {
        return this.coverTitle;
    } //-- String getCoverTitle()

    /**
     * Get 
     *             The type of the document. This might be used on
     * the cover page to
     *             specify the type of information contained in the
     * document
     *             (eg 'User Guide', 'Manual', etc.).
     *           
     * 
     * @return String
     */
    public String getCoverType()
    {
        return this.coverType;
    } //-- String getCoverType()

    /**
     * Get 
     *             The version of the project that appears on the
     * cover page.
     *           
     * 
     * @return String
     */
    public String getCoverVersion()
    {
        return this.coverVersion;
    } //-- String getCoverVersion()

    /**
     * Get 
     *             The location of an image file that represents
     * the project logo.
     *           
     * 
     * @return String
     */
    public String getProjectLogo()
    {
        return this.projectLogo;
    } //-- String getProjectLogo()

    /**
     * Get 
     *             The name of the project.
     *           
     * 
     * @return String
     */
    public String getProjectName()
    {
        return this.projectName;
    } //-- String getProjectName()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( coverTitle != null ? coverTitle.hashCode() : 0 );
        result = 37 * result + ( coverSubTitle != null ? coverSubTitle.hashCode() : 0 );
        result = 37 * result + ( coverVersion != null ? coverVersion.hashCode() : 0 );
        result = 37 * result + ( coverType != null ? coverType.hashCode() : 0 );
        result = 37 * result + ( coverDate != null ? coverDate.hashCode() : 0 );
        result = 37 * result + ( authors != null ? authors.hashCode() : 0 );
        result = 37 * result + ( projectName != null ? projectName.hashCode() : 0 );
        result = 37 * result + ( projectLogo != null ? projectLogo.hashCode() : 0 );
        result = 37 * result + ( companyName != null ? companyName.hashCode() : 0 );
        result = 37 * result + ( companyLogo != null ? companyLogo.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Method removeAuthor.
     * 
     * @param documentAuthor
     */
    public void removeAuthor( DocumentAuthor documentAuthor )
    {
        if ( !(documentAuthor instanceof DocumentAuthor) )
        {
            throw new ClassCastException( "DocumentCover.removeAuthors(documentAuthor) parameter must be instanceof " + DocumentAuthor.class.getName() );
        }
        getAuthors().remove( documentAuthor );
    } //-- void removeAuthor( DocumentAuthor )

    /**
     * Set 
     *             The authors that appear on the cover page.
     *           
     * 
     * @param authors
     */
    public void setAuthors( java.util.List/*<DocumentAuthor>*/ authors )
    {
        this.authors = authors;
    } //-- void setAuthors( java.util.List )

    /**
     * Set 
     *             The location of an image file that represents
     * the company logo.
     *           
     * 
     * @param companyLogo
     */
    public void setCompanyLogo( String companyLogo )
    {
        this.companyLogo = companyLogo;
    } //-- void setCompanyLogo( String )

    /**
     * Set 
     *             The name of the entity that is responsible for
     * the content of the
     *             document, or a copyright holder.
     *           
     * 
     * @param companyName
     */
    public void setCompanyName( String companyName )
    {
        this.companyName = companyName;
    } //-- void setCompanyName( String )

    /**
     * Set 
     *             The date to appear on the cover.
     *           
     * 
     * @param coverDate
     */
    public void setCoverDate( java.util.Date coverDate )
    {
        this.coverDate = coverDate;
    } //-- void setCoverDate( java.util.Date )

    /**
     * Set 
     *             a sub-title to appear on the cover.
     *           
     * 
     * @param coverSubTitle
     */
    public void setCoverSubTitle( String coverSubTitle )
    {
        this.coverSubTitle = coverSubTitle;
    } //-- void setCoverSubTitle( String )

    /**
     * Set 
     *             The title to appear on the cover.
     *           
     * 
     * @param coverTitle
     */
    public void setCoverTitle( String coverTitle )
    {
        this.coverTitle = coverTitle;
    } //-- void setCoverTitle( String )

    /**
     * Set 
     *             The type of the document. This might be used on
     * the cover page to
     *             specify the type of information contained in the
     * document
     *             (eg 'User Guide', 'Manual', etc.).
     *           
     * 
     * @param coverType
     */
    public void setCoverType( String coverType )
    {
        this.coverType = coverType;
    } //-- void setCoverType( String )

    /**
     * Set 
     *             The version of the project that appears on the
     * cover page.
     *           
     * 
     * @param coverVersion
     */
    public void setCoverVersion( String coverVersion )
    {
        this.coverVersion = coverVersion;
    } //-- void setCoverVersion( String )

    /**
     * Set 
     *             The location of an image file that represents
     * the project logo.
     *           
     * 
     * @param projectLogo
     */
    public void setProjectLogo( String projectLogo )
    {
        this.projectLogo = projectLogo;
    } //-- void setProjectLogo( String )

    /**
     * Set 
     *             The name of the project.
     *           
     * 
     * @param projectName
     */
    public void setProjectName( String projectName )
    {
        this.projectName = projectName;
    } //-- void setProjectName( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "coverTitle = '" );
        buf.append( getCoverTitle() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "coverSubTitle = '" );
        buf.append( getCoverSubTitle() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "coverVersion = '" );
        buf.append( getCoverVersion() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "coverType = '" );
        buf.append( getCoverType() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "coverDate = '" );
        buf.append( getCoverDate() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "authors = '" );
        buf.append( getAuthors() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "projectName = '" );
        buf.append( getProjectName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "projectLogo = '" );
        buf.append( getProjectLogo() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "companyName = '" );
        buf.append( getCompanyName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "companyLogo = '" );
        buf.append( getCompanyLogo() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


}
