/*
 * $Id$
 */

package org.apache.maven.doxia.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         <p>
 *           Metadata is general information about a document.
 *         </p>
 * 
 *         <p>
 *           The metadata elements used here were mostly inspired
 * by the
 *           <a href="http://docs.oasis-open.org/office/v1.1/">Open
 * Document Format Specification v. 1.1</a>,
 *           which in turn borrows heavily upon the metadata
 * standards developed by the
 *           <a href="http://www.dublincore.org">Dublin Core
 * Metadata Initiative</a>.
 *         </p>
 *       
 * 
 * @version $Revision$ $Date$
 */
public class DocumentMeta
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The title of the document.
     *           
     */
    private String title;

    /**
     * 
     *             A shortcut for the unique author of the
     * document, usually as a String of "firstName lastName". For
     *             more authors, you could use the &lt;authors/&gt;
     * tag.
     *           
     */
    private String author;

    /**
     * Field authors.
     */
    private java.util.List/*<DocumentAuthor>*/ authors;

    /**
     * 
     *             The subject of the document.
     *           
     */
    private String subject;

    /**
     * 
     *             Keywords for the document.
     *           
     */
    private String keywords;

    /**
     * Field keyWords.
     */
    private java.util.List/*<String>*/ keyWords;

    /**
     * 
     *             The pagesize of the document.
     *             At least "US", "USLetter" and "A4" should be
     * supported.
     *           
     */
    private String pageSize;

    /**
     * 
     *              A string that identifies the application or
     * tool that was
     *              used to create or last modify the document.
     *           
     */
    private String generator;

    /**
     * 
     *              A brief description of the document.
     *           
     */
    private String description;

    /**
     * 
     *             The name of the person who created the document
     * initially.
     *           
     */
    private String initialCreator;

    /**
     * 
     *             The name of the person who last modified the
     * document.
     *           
     */
    private String creator;

    /**
     * 
     *             The name of the person who last printed the
     * document.
     *           
     */
    private String printedBy;

    /**
     * 
     *             The date and time when the document was created
     * initially.
     *           
     */
    private java.util.Date creationDate;

    /**
     * 
     *             The date and time when the document was last
     * modified.
     *           
     */
    private java.util.Date date;

    /**
     * 
     *             The date and time when the document was last
     * printed.
     *           
     */
    private java.util.Date printDate;

    /**
     * 
     *             A template that was used to create the document.
     *           
     */
    private DocumentTemplate template;

    /**
     * 
     *             The hyperlink-behaviour element specifies the
     * default behavior
     *             for hyperlinks in the document.
     *           
     */
    private DocumentHyperlinkBehaviour hyperlinkBehaviour;

    /**
     * 
     *             The default language of the document. The
     * language is represented by
     *             a two or three letter Language Code taken from
     * the ISO 639 standard,
     *             optionally followed by a hyphen (-) and a
     * two-letter Country Code
     *             taken from the ISO 3166 standard.
     *           
     */
    private String language = "en-US";

    /**
     * 
     *             The number of editing cycles the document has
     * been through.
     *           
     */
    private long editingCycles = 0L;

    /**
     * 
     *             The total time spent editing the document.
     *           
     */
    private long editingDuration = 0L;

    /**
     * 
     *             The statistics of the document, for example, the
     * page count,
     *             word count, etc.
     *           
     */
    private DocumentStatistic documentStatistic;

    /**
     * 
     *             whether the content of the document is in some
     * sense confidential.
     *           
     */
    private boolean confidential = false;

    /**
     * 
     *             whether the content of the document is in some
     * sense preliminary.
     *           
     */
    private boolean draft = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addAuthor.
     * 
     * @param documentAuthor
     */
    public void addAuthor( DocumentAuthor documentAuthor )
    {
        if ( !(documentAuthor instanceof DocumentAuthor) )
        {
            throw new ClassCastException( "DocumentMeta.addAuthors(documentAuthor) parameter must be instanceof " + DocumentAuthor.class.getName() );
        }
        getAuthors().add( documentAuthor );
    } //-- void addAuthor( DocumentAuthor )

    /**
     * Method addKeyWord.
     * 
     * @param string
     */
    public void addKeyWord( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "DocumentMeta.addKeyWords(string) parameter must be instanceof " + String.class.getName() );
        }
        getKeyWords().add( string );
    } //-- void addKeyWord( String )

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof DocumentMeta ) )
        {
            return false;
        }

        DocumentMeta that = (DocumentMeta) other;
        boolean result = true;

        result = result && ( getTitle() == null ? that.getTitle() == null : getTitle().equals( that.getTitle() ) );
        result = result && ( getAuthor() == null ? that.getAuthor() == null : getAuthor().equals( that.getAuthor() ) );
        result = result && ( getAuthors() == null ? that.getAuthors() == null : getAuthors().equals( that.getAuthors() ) );
        result = result && ( getSubject() == null ? that.getSubject() == null : getSubject().equals( that.getSubject() ) );
        result = result && ( getKeywords() == null ? that.getKeywords() == null : getKeywords().equals( that.getKeywords() ) );
        result = result && ( getKeyWords() == null ? that.getKeyWords() == null : getKeyWords().equals( that.getKeyWords() ) );
        result = result && ( getPageSize() == null ? that.getPageSize() == null : getPageSize().equals( that.getPageSize() ) );
        result = result && ( getGenerator() == null ? that.getGenerator() == null : getGenerator().equals( that.getGenerator() ) );
        result = result && ( getDescription() == null ? that.getDescription() == null : getDescription().equals( that.getDescription() ) );
        result = result && ( getInitialCreator() == null ? that.getInitialCreator() == null : getInitialCreator().equals( that.getInitialCreator() ) );
        result = result && ( getCreator() == null ? that.getCreator() == null : getCreator().equals( that.getCreator() ) );
        result = result && ( getPrintedBy() == null ? that.getPrintedBy() == null : getPrintedBy().equals( that.getPrintedBy() ) );
        result = result && ( getCreationDate() == null ? that.getCreationDate() == null : getCreationDate().equals( that.getCreationDate() ) );
        result = result && ( getDate() == null ? that.getDate() == null : getDate().equals( that.getDate() ) );
        result = result && ( getPrintDate() == null ? that.getPrintDate() == null : getPrintDate().equals( that.getPrintDate() ) );
        result = result && ( getTemplate() == null ? that.getTemplate() == null : getTemplate().equals( that.getTemplate() ) );
        result = result && ( getHyperlinkBehaviour() == null ? that.getHyperlinkBehaviour() == null : getHyperlinkBehaviour().equals( that.getHyperlinkBehaviour() ) );
        result = result && ( getLanguage() == null ? that.getLanguage() == null : getLanguage().equals( that.getLanguage() ) );
        result = result && editingCycles == that.editingCycles;
        result = result && editingDuration == that.editingDuration;
        result = result && ( getDocumentStatistic() == null ? that.getDocumentStatistic() == null : getDocumentStatistic().equals( that.getDocumentStatistic() ) );
        result = result && confidential == that.confidential;
        result = result && draft == that.draft;

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             A shortcut for the unique author of the
     * document, usually as a String of "firstName lastName". For
     *             more authors, you could use the &lt;authors/&gt;
     * tag.
     *           
     * 
     * @return String
     */
    public String getAuthor()
    {
        return this.author;
    } //-- String getAuthor()

    /**
     * Method getAuthors.
     * 
     * @return List
     */
    public java.util.List/*<DocumentAuthor>*/ getAuthors()
    {
        if ( this.authors == null )
        {
            this.authors = new java.util.ArrayList/*<DocumentAuthor>*/();
        }

        return this.authors;
    } //-- java.util.List/*<DocumentAuthor>*/ getAuthors()

    /**
     * Get 
     *             The date and time when the document was created
     * initially.
     *           
     * 
     * @return Date
     */
    public java.util.Date getCreationDate()
    {
        return this.creationDate;
    } //-- java.util.Date getCreationDate()

    /**
     * Get 
     *             The name of the person who last modified the
     * document.
     *           
     * 
     * @return String
     */
    public String getCreator()
    {
        return this.creator;
    } //-- String getCreator()

    /**
     * Get 
     *             The date and time when the document was last
     * modified.
     *           
     * 
     * @return Date
     */
    public java.util.Date getDate()
    {
        return this.date;
    } //-- java.util.Date getDate()

    /**
     * Get 
     *              A brief description of the document.
     *           
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription()

    /**
     * Get 
     *             The statistics of the document, for example, the
     * page count,
     *             word count, etc.
     *           
     * 
     * @return DocumentStatistic
     */
    public DocumentStatistic getDocumentStatistic()
    {
        return this.documentStatistic;
    } //-- DocumentStatistic getDocumentStatistic()

    /**
     * Get 
     *             The number of editing cycles the document has
     * been through.
     *           
     * 
     * @return long
     */
    public long getEditingCycles()
    {
        return this.editingCycles;
    } //-- long getEditingCycles()

    /**
     * Get 
     *             The total time spent editing the document.
     *           
     * 
     * @return long
     */
    public long getEditingDuration()
    {
        return this.editingDuration;
    } //-- long getEditingDuration()

    /**
     * Get 
     *              A string that identifies the application or
     * tool that was
     *              used to create or last modify the document.
     *           
     * 
     * @return String
     */
    public String getGenerator()
    {
        return this.generator;
    } //-- String getGenerator()

    /**
     * Get 
     *             The hyperlink-behaviour element specifies the
     * default behavior
     *             for hyperlinks in the document.
     *           
     * 
     * @return DocumentHyperlinkBehaviour
     */
    public DocumentHyperlinkBehaviour getHyperlinkBehaviour()
    {
        return this.hyperlinkBehaviour;
    } //-- DocumentHyperlinkBehaviour getHyperlinkBehaviour()

    /**
     * Get 
     *             The name of the person who created the document
     * initially.
     *           
     * 
     * @return String
     */
    public String getInitialCreator()
    {
        return this.initialCreator;
    } //-- String getInitialCreator()

    /**
     * Method getKeyWords.
     * 
     * @return List
     */
    public java.util.List/*<String>*/ getKeyWords()
    {
        if ( this.keyWords == null )
        {
            this.keyWords = new java.util.ArrayList/*<String>*/();
        }

        return this.keyWords;
    } //-- java.util.List/*<String>*/ getKeyWords()

    /**
     * Get 
     *             Keywords for the document.
     *           
     * 
     * @return String
     */
    public String getKeywords()
    {
        return this.keywords;
    } //-- String getKeywords()

    /**
     * Get 
     *             The default language of the document. The
     * language is represented by
     *             a two or three letter Language Code taken from
     * the ISO 639 standard,
     *             optionally followed by a hyphen (-) and a
     * two-letter Country Code
     *             taken from the ISO 3166 standard.
     *           
     * 
     * @return String
     */
    public String getLanguage()
    {
        return this.language;
    } //-- String getLanguage()

    /**
     * Get 
     *             The pagesize of the document.
     *             At least "US", "USLetter" and "A4" should be
     * supported.
     *           
     * 
     * @return String
     */
    public String getPageSize()
    {
        return this.pageSize;
    } //-- String getPageSize()

    /**
     * Get 
     *             The date and time when the document was last
     * printed.
     *           
     * 
     * @return Date
     */
    public java.util.Date getPrintDate()
    {
        return this.printDate;
    } //-- java.util.Date getPrintDate()

    /**
     * Get 
     *             The name of the person who last printed the
     * document.
     *           
     * 
     * @return String
     */
    public String getPrintedBy()
    {
        return this.printedBy;
    } //-- String getPrintedBy()

    /**
     * Get 
     *             The subject of the document.
     *           
     * 
     * @return String
     */
    public String getSubject()
    {
        return this.subject;
    } //-- String getSubject()

    /**
     * Get 
     *             A template that was used to create the document.
     *           
     * 
     * @return DocumentTemplate
     */
    public DocumentTemplate getTemplate()
    {
        return this.template;
    } //-- DocumentTemplate getTemplate()

    /**
     * Get 
     *             The title of the document.
     *           
     * 
     * @return String
     */
    public String getTitle()
    {
        return this.title;
    } //-- String getTitle()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( title != null ? title.hashCode() : 0 );
        result = 37 * result + ( author != null ? author.hashCode() : 0 );
        result = 37 * result + ( authors != null ? authors.hashCode() : 0 );
        result = 37 * result + ( subject != null ? subject.hashCode() : 0 );
        result = 37 * result + ( keywords != null ? keywords.hashCode() : 0 );
        result = 37 * result + ( keyWords != null ? keyWords.hashCode() : 0 );
        result = 37 * result + ( pageSize != null ? pageSize.hashCode() : 0 );
        result = 37 * result + ( generator != null ? generator.hashCode() : 0 );
        result = 37 * result + ( description != null ? description.hashCode() : 0 );
        result = 37 * result + ( initialCreator != null ? initialCreator.hashCode() : 0 );
        result = 37 * result + ( creator != null ? creator.hashCode() : 0 );
        result = 37 * result + ( printedBy != null ? printedBy.hashCode() : 0 );
        result = 37 * result + ( creationDate != null ? creationDate.hashCode() : 0 );
        result = 37 * result + ( date != null ? date.hashCode() : 0 );
        result = 37 * result + ( printDate != null ? printDate.hashCode() : 0 );
        result = 37 * result + ( template != null ? template.hashCode() : 0 );
        result = 37 * result + ( hyperlinkBehaviour != null ? hyperlinkBehaviour.hashCode() : 0 );
        result = 37 * result + ( language != null ? language.hashCode() : 0 );
        result = 37 * result + (int) ( editingCycles ^ ( editingCycles >>> 32 ) );
        result = 37 * result + (int) ( editingDuration ^ ( editingDuration >>> 32 ) );
        result = 37 * result + ( documentStatistic != null ? documentStatistic.hashCode() : 0 );
        result = 37 * result + ( confidential ? 0 : 1 );
        result = 37 * result + ( draft ? 0 : 1 );

        return result;
    } //-- int hashCode()

    /**
     * Get 
     *             whether the content of the document is in some
     * sense confidential.
     *           
     * 
     * @return boolean
     */
    public boolean isConfidential()
    {
        return this.confidential;
    } //-- boolean isConfidential()

    /**
     * Get 
     *             whether the content of the document is in some
     * sense preliminary.
     *           
     * 
     * @return boolean
     */
    public boolean isDraft()
    {
        return this.draft;
    } //-- boolean isDraft()

    /**
     * Method removeAuthor.
     * 
     * @param documentAuthor
     */
    public void removeAuthor( DocumentAuthor documentAuthor )
    {
        if ( !(documentAuthor instanceof DocumentAuthor) )
        {
            throw new ClassCastException( "DocumentMeta.removeAuthors(documentAuthor) parameter must be instanceof " + DocumentAuthor.class.getName() );
        }
        getAuthors().remove( documentAuthor );
    } //-- void removeAuthor( DocumentAuthor )

    /**
     * Method removeKeyWord.
     * 
     * @param string
     */
    public void removeKeyWord( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "DocumentMeta.removeKeyWords(string) parameter must be instanceof " + String.class.getName() );
        }
        getKeyWords().remove( string );
    } //-- void removeKeyWord( String )

    /**
     * Set 
     *             A shortcut for the unique author of the
     * document, usually as a String of "firstName lastName". For
     *             more authors, you could use the &lt;authors/&gt;
     * tag.
     *           
     * 
     * @param author
     */
    public void setAuthor( String author )
    {
        this.author = author;
    } //-- void setAuthor( String )

    /**
     * Set 
     *             The authors of the document. The names of the
     * entities that
     *             are primarily responsible for the content of the
     * document.
     *           
     * 
     * @param authors
     */
    public void setAuthors( java.util.List/*<DocumentAuthor>*/ authors )
    {
        this.authors = authors;
    } //-- void setAuthors( java.util.List )

    /**
     * Set 
     *             whether the content of the document is in some
     * sense confidential.
     *           
     * 
     * @param confidential
     */
    public void setConfidential( boolean confidential )
    {
        this.confidential = confidential;
    } //-- void setConfidential( boolean )

    /**
     * Set 
     *             The date and time when the document was created
     * initially.
     *           
     * 
     * @param creationDate
     */
    public void setCreationDate( java.util.Date creationDate )
    {
        this.creationDate = creationDate;
    } //-- void setCreationDate( java.util.Date )

    /**
     * Set 
     *             The name of the person who last modified the
     * document.
     *           
     * 
     * @param creator
     */
    public void setCreator( String creator )
    {
        this.creator = creator;
    } //-- void setCreator( String )

    /**
     * Set 
     *             The date and time when the document was last
     * modified.
     *           
     * 
     * @param date
     */
    public void setDate( java.util.Date date )
    {
        this.date = date;
    } //-- void setDate( java.util.Date )

    /**
     * Set 
     *              A brief description of the document.
     *           
     * 
     * @param description
     */
    public void setDescription( String description )
    {
        this.description = description;
    } //-- void setDescription( String )

    /**
     * Set 
     *             The statistics of the document, for example, the
     * page count,
     *             word count, etc.
     *           
     * 
     * @param documentStatistic
     */
    public void setDocumentStatistic( DocumentStatistic documentStatistic )
    {
        this.documentStatistic = documentStatistic;
    } //-- void setDocumentStatistic( DocumentStatistic )

    /**
     * Set 
     *             whether the content of the document is in some
     * sense preliminary.
     *           
     * 
     * @param draft
     */
    public void setDraft( boolean draft )
    {
        this.draft = draft;
    } //-- void setDraft( boolean )

    /**
     * Set 
     *             The number of editing cycles the document has
     * been through.
     *           
     * 
     * @param editingCycles
     */
    public void setEditingCycles( long editingCycles )
    {
        this.editingCycles = editingCycles;
    } //-- void setEditingCycles( long )

    /**
     * Set 
     *             The total time spent editing the document.
     *           
     * 
     * @param editingDuration
     */
    public void setEditingDuration( long editingDuration )
    {
        this.editingDuration = editingDuration;
    } //-- void setEditingDuration( long )

    /**
     * Set 
     *              A string that identifies the application or
     * tool that was
     *              used to create or last modify the document.
     *           
     * 
     * @param generator
     */
    public void setGenerator( String generator )
    {
        this.generator = generator;
    } //-- void setGenerator( String )

    /**
     * Set 
     *             The hyperlink-behaviour element specifies the
     * default behavior
     *             for hyperlinks in the document.
     *           
     * 
     * @param hyperlinkBehaviour
     */
    public void setHyperlinkBehaviour( DocumentHyperlinkBehaviour hyperlinkBehaviour )
    {
        this.hyperlinkBehaviour = hyperlinkBehaviour;
    } //-- void setHyperlinkBehaviour( DocumentHyperlinkBehaviour )

    /**
     * Set 
     *             The name of the person who created the document
     * initially.
     *           
     * 
     * @param initialCreator
     */
    public void setInitialCreator( String initialCreator )
    {
        this.initialCreator = initialCreator;
    } //-- void setInitialCreator( String )

    /**
     * Set 
     *             A keyword pertaining to the document. The
     * metadata can contain any
     *             number of keyword elements, each element
     * specifying one keyword.
     *           
     * 
     * @param keyWords
     */
    public void setKeyWords( java.util.List/*<String>*/ keyWords )
    {
        this.keyWords = keyWords;
    } //-- void setKeyWords( java.util.List )

    /**
     * Set 
     *             Keywords for the document.
     *           
     * 
     * @param keywords
     */
    public void setKeywords( String keywords )
    {
        this.keywords = keywords;
    } //-- void setKeywords( String )

    /**
     * Set 
     *             The default language of the document. The
     * language is represented by
     *             a two or three letter Language Code taken from
     * the ISO 639 standard,
     *             optionally followed by a hyphen (-) and a
     * two-letter Country Code
     *             taken from the ISO 3166 standard.
     *           
     * 
     * @param language
     */
    public void setLanguage( String language )
    {
        this.language = language;
    } //-- void setLanguage( String )

    /**
     * Set 
     *             The pagesize of the document.
     *             At least "US", "USLetter" and "A4" should be
     * supported.
     *           
     * 
     * @param pageSize
     */
    public void setPageSize( String pageSize )
    {
        this.pageSize = pageSize;
    } //-- void setPageSize( String )

    /**
     * Set 
     *             The date and time when the document was last
     * printed.
     *           
     * 
     * @param printDate
     */
    public void setPrintDate( java.util.Date printDate )
    {
        this.printDate = printDate;
    } //-- void setPrintDate( java.util.Date )

    /**
     * Set 
     *             The name of the person who last printed the
     * document.
     *           
     * 
     * @param printedBy
     */
    public void setPrintedBy( String printedBy )
    {
        this.printedBy = printedBy;
    } //-- void setPrintedBy( String )

    /**
     * Set 
     *             The subject of the document.
     *           
     * 
     * @param subject
     */
    public void setSubject( String subject )
    {
        this.subject = subject;
    } //-- void setSubject( String )

    /**
     * Set 
     *             A template that was used to create the document.
     *           
     * 
     * @param template
     */
    public void setTemplate( DocumentTemplate template )
    {
        this.template = template;
    } //-- void setTemplate( DocumentTemplate )

    /**
     * Set 
     *             The title of the document.
     *           
     * 
     * @param title
     */
    public void setTitle( String title )
    {
        this.title = title;
    } //-- void setTitle( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "title = '" );
        buf.append( getTitle() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "author = '" );
        buf.append( getAuthor() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "authors = '" );
        buf.append( getAuthors() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "subject = '" );
        buf.append( getSubject() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "keywords = '" );
        buf.append( getKeywords() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "keyWords = '" );
        buf.append( getKeyWords() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "pageSize = '" );
        buf.append( getPageSize() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "generator = '" );
        buf.append( getGenerator() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "description = '" );
        buf.append( getDescription() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "initialCreator = '" );
        buf.append( getInitialCreator() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "creator = '" );
        buf.append( getCreator() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "printedBy = '" );
        buf.append( getPrintedBy() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "creationDate = '" );
        buf.append( getCreationDate() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "date = '" );
        buf.append( getDate() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "printDate = '" );
        buf.append( getPrintDate() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "template = '" );
        buf.append( getTemplate() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "hyperlinkBehaviour = '" );
        buf.append( getHyperlinkBehaviour() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "language = '" );
        buf.append( getLanguage() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "editingCycles = '" );
        buf.append( getEditingCycles() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "editingDuration = '" );
        buf.append( getEditingDuration() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "documentStatistic = '" );
        buf.append( getDocumentStatistic() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "confidential = '" );
        buf.append( isConfidential() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "draft = '" );
        buf.append( isDraft() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


}
