/*
 * $Id$
 */

package org.apache.maven.doxia.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A Table Of Content for the document.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentTOC
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The name to use for the Table of Contents.
     *           
     */
    private String name;

    /**
     * 
     *             Specifies up to which level toc items are
     * included by default.
     *             Defaults to 0 which means all entries are
     * included. A depth of 1
     *             means only top-level elements, 2 includes one
     * level of sub-items, etc.
     *             This may be overridden for individual entries by
     * using the collapse
     *             attribute of the corresponding toc item.
     *           
     */
    private int depth = 0;

    /**
     * Field items.
     */
    private java.util.List/*<DocumentTOCItem>*/ items;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addItem.
     * 
     * @param documentTOCItem
     */
    public void addItem( DocumentTOCItem documentTOCItem )
    {
        if ( !(documentTOCItem instanceof DocumentTOCItem) )
        {
            throw new ClassCastException( "DocumentTOC.addItems(documentTOCItem) parameter must be instanceof " + DocumentTOCItem.class.getName() );
        }
        getItems().add( documentTOCItem );
    } //-- void addItem( DocumentTOCItem )

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof DocumentTOC ) )
        {
            return false;
        }

        DocumentTOC that = (DocumentTOC) other;
        boolean result = true;

        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && depth == that.depth;
        result = result && ( getItems() == null ? that.getItems() == null : getItems().equals( that.getItems() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             Specifies up to which level toc items are
     * included by default.
     *             Defaults to 0 which means all entries are
     * included. A depth of 1
     *             means only top-level elements, 2 includes one
     * level of sub-items, etc.
     *             This may be overridden for individual entries by
     * using the collapse
     *             attribute of the corresponding toc item.
     *           
     * 
     * @return int
     */
    public int getDepth()
    {
        return this.depth;
    } //-- int getDepth()

    /**
     * Method getItems.
     * 
     * @return List
     */
    public java.util.List/*<DocumentTOCItem>*/ getItems()
    {
        if ( this.items == null )
        {
            this.items = new java.util.ArrayList/*<DocumentTOCItem>*/();
        }

        return this.items;
    } //-- java.util.List/*<DocumentTOCItem>*/ getItems()

    /**
     * Get 
     *             The name to use for the Table of Contents.
     *           
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + (int) depth;
        result = 37 * result + ( items != null ? items.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Method removeItem.
     * 
     * @param documentTOCItem
     */
    public void removeItem( DocumentTOCItem documentTOCItem )
    {
        if ( !(documentTOCItem instanceof DocumentTOCItem) )
        {
            throw new ClassCastException( "DocumentTOC.removeItems(documentTOCItem) parameter must be instanceof " + DocumentTOCItem.class.getName() );
        }
        getItems().remove( documentTOCItem );
    } //-- void removeItem( DocumentTOCItem )

    /**
     * Set 
     *             Specifies up to which level toc items are
     * included by default.
     *             Defaults to 0 which means all entries are
     * included. A depth of 1
     *             means only top-level elements, 2 includes one
     * level of sub-items, etc.
     *             This may be overridden for individual entries by
     * using the collapse
     *             attribute of the corresponding toc item.
     *           
     * 
     * @param depth
     */
    public void setDepth( int depth )
    {
        this.depth = depth;
    } //-- void setDepth( int )

    /**
     * Set 
     *             TOC item.
     *           
     * 
     * @param items
     */
    public void setItems( java.util.List/*<DocumentTOCItem>*/ items )
    {
        this.items = items;
    } //-- void setItems( java.util.List )

    /**
     * Set 
     *             The name to use for the Table of Contents.
     *           
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "depth = '" );
        buf.append( getDepth() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "items = '" );
        buf.append( getItems() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


}
