/*
 * $Id$
 */

package org.apache.maven.doxia.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A template that was used to create the document.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentTemplate
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The location of the document template.
     *           
     */
    private String href;

    /**
     * 
     *             The name of the document template.
     *           
     */
    private String title;

    /**
     * 
     *             The date and time when the template was last
     * modified, prior
     *             to being used to create the current document.
     *           
     */
    private java.util.Date date;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof DocumentTemplate ) )
        {
            return false;
        }

        DocumentTemplate that = (DocumentTemplate) other;
        boolean result = true;

        result = result && ( getHref() == null ? that.getHref() == null : getHref().equals( that.getHref() ) );
        result = result && ( getTitle() == null ? that.getTitle() == null : getTitle().equals( that.getTitle() ) );
        result = result && ( getDate() == null ? that.getDate() == null : getDate().equals( that.getDate() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             The date and time when the template was last
     * modified, prior
     *             to being used to create the current document.
     *           
     * 
     * @return Date
     */
    public java.util.Date getDate()
    {
        return this.date;
    } //-- java.util.Date getDate()

    /**
     * Get 
     *             The location of the document template.
     *           
     * 
     * @return String
     */
    public String getHref()
    {
        return this.href;
    } //-- String getHref()

    /**
     * Get 
     *             The name of the document template.
     *           
     * 
     * @return String
     */
    public String getTitle()
    {
        return this.title;
    } //-- String getTitle()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( href != null ? href.hashCode() : 0 );
        result = 37 * result + ( title != null ? title.hashCode() : 0 );
        result = 37 * result + ( date != null ? date.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Set 
     *             The date and time when the template was last
     * modified, prior
     *             to being used to create the current document.
     *           
     * 
     * @param date
     */
    public void setDate( java.util.Date date )
    {
        this.date = date;
    } //-- void setDate( java.util.Date )

    /**
     * Set 
     *             The location of the document template.
     *           
     * 
     * @param href
     */
    public void setHref( String href )
    {
        this.href = href;
    } //-- void setHref( String )

    /**
     * Set 
     *             The name of the document template.
     *           
     * 
     * @param title
     */
    public void setTitle( String title )
    {
        this.title = title;
    } //-- void setTitle( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "href = '" );
        buf.append( getHref() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "title = '" );
        buf.append( getTitle() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "date = '" );
        buf.append( getDate() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


}
