/*
 * $Id$
 */

package org.apache.maven.doxia.document.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.doxia.document.DocumentAuthor;
import org.apache.maven.doxia.document.DocumentCover;
import org.apache.maven.doxia.document.DocumentHyperlinkBehaviour;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentStatistic;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.document.DocumentTemplate;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class DocumentXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentXpp3Writer
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private static final String NAMESPACE = null;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param documentModel
     * @throws java.io.IOException
     */
    public void write( Writer writer, DocumentModel documentModel )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( documentModel.getModelEncoding(), null );
        writeDocumentModel( documentModel, "document", serializer );
        serializer.endDocument();
    } //-- void write( Writer, DocumentModel )

    /**
     * Method writeDocumentAuthor.
     * 
     * @param documentAuthor
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeDocumentAuthor( DocumentAuthor documentAuthor, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( documentAuthor != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentAuthor.getFirstName() != null )
            {
                serializer.startTag( NAMESPACE, "firstName" ).text( documentAuthor.getFirstName() ).endTag( NAMESPACE, "firstName" );
            }
            if ( documentAuthor.getLastName() != null )
            {
                serializer.startTag( NAMESPACE, "lastName" ).text( documentAuthor.getLastName() ).endTag( NAMESPACE, "lastName" );
            }
            if ( documentAuthor.getInitials() != null )
            {
                serializer.startTag( NAMESPACE, "initials" ).text( documentAuthor.getInitials() ).endTag( NAMESPACE, "initials" );
            }
            if ( documentAuthor.getTitle() != null )
            {
                serializer.startTag( NAMESPACE, "title" ).text( documentAuthor.getTitle() ).endTag( NAMESPACE, "title" );
            }
            if ( documentAuthor.getPosition() != null )
            {
                serializer.startTag( NAMESPACE, "position" ).text( documentAuthor.getPosition() ).endTag( NAMESPACE, "position" );
            }
            if ( documentAuthor.getEmail() != null )
            {
                serializer.startTag( NAMESPACE, "email" ).text( documentAuthor.getEmail() ).endTag( NAMESPACE, "email" );
            }
            if ( documentAuthor.getPhoneNumber() != null )
            {
                serializer.startTag( NAMESPACE, "phoneNumber" ).text( documentAuthor.getPhoneNumber() ).endTag( NAMESPACE, "phoneNumber" );
            }
            if ( documentAuthor.getFaxNumber() != null )
            {
                serializer.startTag( NAMESPACE, "faxNumber" ).text( documentAuthor.getFaxNumber() ).endTag( NAMESPACE, "faxNumber" );
            }
            if ( documentAuthor.getCompanyName() != null )
            {
                serializer.startTag( NAMESPACE, "companyName" ).text( documentAuthor.getCompanyName() ).endTag( NAMESPACE, "companyName" );
            }
            if ( documentAuthor.getStreet() != null )
            {
                serializer.startTag( NAMESPACE, "street" ).text( documentAuthor.getStreet() ).endTag( NAMESPACE, "street" );
            }
            if ( documentAuthor.getCity() != null )
            {
                serializer.startTag( NAMESPACE, "city" ).text( documentAuthor.getCity() ).endTag( NAMESPACE, "city" );
            }
            if ( documentAuthor.getPostalCode() != null )
            {
                serializer.startTag( NAMESPACE, "postalCode" ).text( documentAuthor.getPostalCode() ).endTag( NAMESPACE, "postalCode" );
            }
            if ( documentAuthor.getCountry() != null )
            {
                serializer.startTag( NAMESPACE, "country" ).text( documentAuthor.getCountry() ).endTag( NAMESPACE, "country" );
            }
            if ( documentAuthor.getState() != null )
            {
                serializer.startTag( NAMESPACE, "state" ).text( documentAuthor.getState() ).endTag( NAMESPACE, "state" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentAuthor( DocumentAuthor, String, XmlSerializer )

    /**
     * Method writeDocumentCover.
     * 
     * @param documentCover
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeDocumentCover( DocumentCover documentCover, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( documentCover != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentCover.getCoverTitle() != null )
            {
                serializer.startTag( NAMESPACE, "coverTitle" ).text( documentCover.getCoverTitle() ).endTag( NAMESPACE, "coverTitle" );
            }
            if ( documentCover.getCoverSubTitle() != null )
            {
                serializer.startTag( NAMESPACE, "coverSubTitle" ).text( documentCover.getCoverSubTitle() ).endTag( NAMESPACE, "coverSubTitle" );
            }
            if ( documentCover.getCoverVersion() != null )
            {
                serializer.startTag( NAMESPACE, "coverVersion" ).text( documentCover.getCoverVersion() ).endTag( NAMESPACE, "coverVersion" );
            }
            if ( documentCover.getCoverType() != null )
            {
                serializer.startTag( NAMESPACE, "coverType" ).text( documentCover.getCoverType() ).endTag( NAMESPACE, "coverType" );
            }
            if ( documentCover.getCoverDate() != null )
            {
                serializer.startTag( NAMESPACE, "coverDate" ).text( new java.text.SimpleDateFormat( "yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US ).format( documentCover.getCoverDate() ) ).endTag( NAMESPACE, "coverDate" );
            }
            if ( ( documentCover.getAuthors() != null ) && ( documentCover.getAuthors().size() > 0 ) )
            {
                for ( Iterator iter = documentCover.getAuthors().iterator(); iter.hasNext(); )
                {
                    DocumentAuthor o = (DocumentAuthor) iter.next();
                    writeDocumentAuthor( o, "author", serializer );
                }
            }
            if ( documentCover.getProjectName() != null )
            {
                serializer.startTag( NAMESPACE, "projectName" ).text( documentCover.getProjectName() ).endTag( NAMESPACE, "projectName" );
            }
            if ( documentCover.getProjectLogo() != null )
            {
                serializer.startTag( NAMESPACE, "projectLogo" ).text( documentCover.getProjectLogo() ).endTag( NAMESPACE, "projectLogo" );
            }
            if ( documentCover.getCompanyName() != null )
            {
                serializer.startTag( NAMESPACE, "companyName" ).text( documentCover.getCompanyName() ).endTag( NAMESPACE, "companyName" );
            }
            if ( documentCover.getCompanyLogo() != null )
            {
                serializer.startTag( NAMESPACE, "companyLogo" ).text( documentCover.getCompanyLogo() ).endTag( NAMESPACE, "companyLogo" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentCover( DocumentCover, String, XmlSerializer )

    /**
     * Method writeDocumentHyperlinkBehaviour.
     * 
     * @param documentHyperlinkBehaviour
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeDocumentHyperlinkBehaviour( DocumentHyperlinkBehaviour documentHyperlinkBehaviour, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( documentHyperlinkBehaviour != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( ( documentHyperlinkBehaviour.getTargetFrame() != null ) && !documentHyperlinkBehaviour.getTargetFrame().equals( "_self" ) )
            {
                serializer.attribute( NAMESPACE, "targetFrame", documentHyperlinkBehaviour.getTargetFrame() );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentHyperlinkBehaviour( DocumentHyperlinkBehaviour, String, XmlSerializer )

    /**
     * Method writeDocumentMeta.
     * 
     * @param documentMeta
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeDocumentMeta( DocumentMeta documentMeta, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( documentMeta != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentMeta.getTitle() != null )
            {
                serializer.startTag( NAMESPACE, "title" ).text( documentMeta.getTitle() ).endTag( NAMESPACE, "title" );
            }
            if ( documentMeta.getAuthor() != null )
            {
                serializer.startTag( NAMESPACE, "author" ).text( documentMeta.getAuthor() ).endTag( NAMESPACE, "author" );
            }
            if ( ( documentMeta.getAuthors() != null ) && ( documentMeta.getAuthors().size() > 0 ) )
            {
                serializer.startTag( NAMESPACE, "authors" );
                for ( Iterator iter = documentMeta.getAuthors().iterator(); iter.hasNext(); )
                {
                    DocumentAuthor o = (DocumentAuthor) iter.next();
                    writeDocumentAuthor( o, "author", serializer );
                }
                serializer.endTag( NAMESPACE, "authors" );
            }
            if ( documentMeta.getSubject() != null )
            {
                serializer.startTag( NAMESPACE, "subject" ).text( documentMeta.getSubject() ).endTag( NAMESPACE, "subject" );
            }
            if ( documentMeta.getKeywords() != null )
            {
                serializer.startTag( NAMESPACE, "keywords" ).text( documentMeta.getKeywords() ).endTag( NAMESPACE, "keywords" );
            }
            if ( ( documentMeta.getKeyWords() != null ) && ( documentMeta.getKeyWords().size() > 0 ) )
            {
                for ( Iterator iter = documentMeta.getKeyWords().iterator(); iter.hasNext(); )
                {
                    String keyWord = (String) iter.next();
                    serializer.startTag( NAMESPACE, "keyWord" ).text( keyWord ).endTag( NAMESPACE, "keyWord" );
                }
            }
            if ( documentMeta.getPageSize() != null )
            {
                serializer.startTag( NAMESPACE, "pageSize" ).text( documentMeta.getPageSize() ).endTag( NAMESPACE, "pageSize" );
            }
            if ( documentMeta.getGenerator() != null )
            {
                serializer.startTag( NAMESPACE, "generator" ).text( documentMeta.getGenerator() ).endTag( NAMESPACE, "generator" );
            }
            if ( documentMeta.getDescription() != null )
            {
                serializer.startTag( NAMESPACE, "description" ).text( documentMeta.getDescription() ).endTag( NAMESPACE, "description" );
            }
            if ( documentMeta.getInitialCreator() != null )
            {
                serializer.startTag( NAMESPACE, "initialCreator" ).text( documentMeta.getInitialCreator() ).endTag( NAMESPACE, "initialCreator" );
            }
            if ( documentMeta.getCreator() != null )
            {
                serializer.startTag( NAMESPACE, "creator" ).text( documentMeta.getCreator() ).endTag( NAMESPACE, "creator" );
            }
            if ( documentMeta.getPrintedBy() != null )
            {
                serializer.startTag( NAMESPACE, "printedBy" ).text( documentMeta.getPrintedBy() ).endTag( NAMESPACE, "printedBy" );
            }
            if ( documentMeta.getCreationDate() != null )
            {
                serializer.startTag( NAMESPACE, "creationDate" ).text( new java.text.SimpleDateFormat( "yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US ).format( documentMeta.getCreationDate() ) ).endTag( NAMESPACE, "creationDate" );
            }
            if ( documentMeta.getDate() != null )
            {
                serializer.startTag( NAMESPACE, "date" ).text( new java.text.SimpleDateFormat( "yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US ).format( documentMeta.getDate() ) ).endTag( NAMESPACE, "date" );
            }
            if ( documentMeta.getPrintDate() != null )
            {
                serializer.startTag( NAMESPACE, "printDate" ).text( new java.text.SimpleDateFormat( "yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US ).format( documentMeta.getPrintDate() ) ).endTag( NAMESPACE, "printDate" );
            }
            if ( documentMeta.getTemplate() != null )
            {
                writeDocumentTemplate( (DocumentTemplate) documentMeta.getTemplate(), "template", serializer );
            }
            if ( documentMeta.getHyperlinkBehaviour() != null )
            {
                writeDocumentHyperlinkBehaviour( (DocumentHyperlinkBehaviour) documentMeta.getHyperlinkBehaviour(), "hyperlinkBehaviour", serializer );
            }
            if ( ( documentMeta.getLanguage() != null ) && !documentMeta.getLanguage().equals( "en-US" ) )
            {
                serializer.startTag( NAMESPACE, "language" ).text( documentMeta.getLanguage() ).endTag( NAMESPACE, "language" );
            }
            if ( documentMeta.getEditingCycles() != 0L )
            {
                serializer.startTag( NAMESPACE, "editingCycles" ).text( String.valueOf( documentMeta.getEditingCycles() ) ).endTag( NAMESPACE, "editingCycles" );
            }
            if ( documentMeta.getEditingDuration() != 0L )
            {
                serializer.startTag( NAMESPACE, "editingDuration" ).text( String.valueOf( documentMeta.getEditingDuration() ) ).endTag( NAMESPACE, "editingDuration" );
            }
            if ( documentMeta.getDocumentStatistic() != null )
            {
                writeDocumentStatistic( (DocumentStatistic) documentMeta.getDocumentStatistic(), "documentStatistic", serializer );
            }
            if ( documentMeta.isConfidential() != false )
            {
                serializer.startTag( NAMESPACE, "confidential" ).text( String.valueOf( documentMeta.isConfidential() ) ).endTag( NAMESPACE, "confidential" );
            }
            if ( documentMeta.isDraft() != false )
            {
                serializer.startTag( NAMESPACE, "draft" ).text( String.valueOf( documentMeta.isDraft() ) ).endTag( NAMESPACE, "draft" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentMeta( DocumentMeta, String, XmlSerializer )

    /**
     * Method writeDocumentModel.
     * 
     * @param documentModel
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeDocumentModel( DocumentModel documentModel, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( documentModel != null )
        {
            serializer.setPrefix( "", "http://maven.apache.org/DOCUMENT/1.0.0" );
            serializer.startTag( NAMESPACE, tagName );
            if ( documentModel.getOutputName() != null )
            {
                serializer.attribute( NAMESPACE, "outputName", documentModel.getOutputName() );
            }
            if ( documentModel.getMeta() != null )
            {
                writeDocumentMeta( (DocumentMeta) documentModel.getMeta(), "meta", serializer );
            }
            if ( documentModel.getToc() != null )
            {
                writeDocumentTOC( (DocumentTOC) documentModel.getToc(), "toc", serializer );
            }
            if ( documentModel.getCover() != null )
            {
                writeDocumentCover( (DocumentCover) documentModel.getCover(), "cover", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentModel( DocumentModel, String, XmlSerializer )

    /**
     * Method writeDocumentStatistic.
     * 
     * @param documentStatistic
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeDocumentStatistic( DocumentStatistic documentStatistic, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( documentStatistic != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentStatistic.getPageCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "pageCount", String.valueOf( documentStatistic.getPageCount() ) );
            }
            if ( documentStatistic.getTableCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "tableCount", String.valueOf( documentStatistic.getTableCount() ) );
            }
            if ( documentStatistic.getDrawCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "drawCount", String.valueOf( documentStatistic.getDrawCount() ) );
            }
            if ( documentStatistic.getImageCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "imageCount", String.valueOf( documentStatistic.getImageCount() ) );
            }
            if ( documentStatistic.getObjectCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "objectCount", String.valueOf( documentStatistic.getObjectCount() ) );
            }
            if ( documentStatistic.getOleObjectCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "oleObjectCount", String.valueOf( documentStatistic.getOleObjectCount() ) );
            }
            if ( documentStatistic.getParagraphCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "paragraphCount", String.valueOf( documentStatistic.getParagraphCount() ) );
            }
            if ( documentStatistic.getWordCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "wordCount", String.valueOf( documentStatistic.getWordCount() ) );
            }
            if ( documentStatistic.getCharacterCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "characterCount", String.valueOf( documentStatistic.getCharacterCount() ) );
            }
            if ( documentStatistic.getRowCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "rowCount", String.valueOf( documentStatistic.getRowCount() ) );
            }
            if ( documentStatistic.getFrameCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "frameCount", String.valueOf( documentStatistic.getFrameCount() ) );
            }
            if ( documentStatistic.getSentenceCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "sentenceCount", String.valueOf( documentStatistic.getSentenceCount() ) );
            }
            if ( documentStatistic.getSyllableCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "syllableCount", String.valueOf( documentStatistic.getSyllableCount() ) );
            }
            if ( documentStatistic.getNonWhitespaceCharacterCount() != 0L )
            {
                serializer.attribute( NAMESPACE, "nonWhitespaceCharacterCount", String.valueOf( documentStatistic.getNonWhitespaceCharacterCount() ) );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentStatistic( DocumentStatistic, String, XmlSerializer )

    /**
     * Method writeDocumentTOC.
     * 
     * @param documentTOC
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeDocumentTOC( DocumentTOC documentTOC, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( documentTOC != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentTOC.getName() != null )
            {
                serializer.attribute( NAMESPACE, "name", documentTOC.getName() );
            }
            if ( documentTOC.getDepth() != 0 )
            {
                serializer.attribute( NAMESPACE, "depth", String.valueOf( documentTOC.getDepth() ) );
            }
            if ( ( documentTOC.getItems() != null ) && ( documentTOC.getItems().size() > 0 ) )
            {
                for ( Iterator iter = documentTOC.getItems().iterator(); iter.hasNext(); )
                {
                    DocumentTOCItem o = (DocumentTOCItem) iter.next();
                    writeDocumentTOCItem( o, "item", serializer );
                }
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentTOC( DocumentTOC, String, XmlSerializer )

    /**
     * Method writeDocumentTOCItem.
     * 
     * @param documentTOCItem
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeDocumentTOCItem( DocumentTOCItem documentTOCItem, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( documentTOCItem != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentTOCItem.getName() != null )
            {
                serializer.attribute( NAMESPACE, "name", documentTOCItem.getName() );
            }
            if ( documentTOCItem.getRef() != null )
            {
                serializer.attribute( NAMESPACE, "ref", documentTOCItem.getRef() );
            }
            if ( documentTOCItem.isCollapse() != false )
            {
                serializer.attribute( NAMESPACE, "collapse", String.valueOf( documentTOCItem.isCollapse() ) );
            }
            if ( ( documentTOCItem.getItems() != null ) && ( documentTOCItem.getItems().size() > 0 ) )
            {
                for ( Iterator iter = documentTOCItem.getItems().iterator(); iter.hasNext(); )
                {
                    DocumentTOCItem o = (DocumentTOCItem) iter.next();
                    writeDocumentTOCItem( o, "item", serializer );
                }
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentTOCItem( DocumentTOCItem, String, XmlSerializer )

    /**
     * Method writeDocumentTemplate.
     * 
     * @param documentTemplate
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeDocumentTemplate( DocumentTemplate documentTemplate, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( documentTemplate != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentTemplate.getHref() != null )
            {
                serializer.attribute( NAMESPACE, "href", documentTemplate.getHref() );
            }
            if ( documentTemplate.getTitle() != null )
            {
                serializer.attribute( NAMESPACE, "title", documentTemplate.getTitle() );
            }
            if ( documentTemplate.getDate() != null )
            {
                serializer.attribute( NAMESPACE, "date", new java.text.SimpleDateFormat( "yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US ).format( documentTemplate.getDate() ) );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentTemplate( DocumentTemplate, String, XmlSerializer )


}
