/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.sink.AbstractXmlSink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.SinkUtils;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class XhtmlBaseSink
extends AbstractXmlSink
implements HtmlMarkup {
    private PrintWriter writer;
    private StringWriter tempWriter;
    private StringBuffer textBuffer = new StringBuffer();
    private boolean headFlag;
    private boolean figureCaptionFlag;
    private boolean paragraphFlag;
    private boolean verbatimFlag;
    private int[] cellJustif;
    private boolean isCellJustif;
    private int cellCount;
    private boolean evenTableRow = true;
    private MutableAttributeSet tableAttributes;
    private boolean legacyFigure;
    private boolean legacyFigureCaption;
    private boolean inFigure;
    private boolean tableRows = false;
    private Map warnMessages;

    public XhtmlBaseSink(Writer out) {
        this.writer = new PrintWriter(out);
        this.tempWriter = new StringWriter();
    }

    protected StringBuffer getTextBuffer() {
        return this.textBuffer;
    }

    protected void setHeadFlag(boolean headFlag) {
        this.headFlag = headFlag;
    }

    protected boolean isHeadFlag() {
        return this.headFlag;
    }

    protected void setVerbatimFlag(boolean verb) {
        this.verbatimFlag = verb;
    }

    protected boolean isVerbatimFlag() {
        return this.verbatimFlag;
    }

    protected void setCellJustif(int[] justif) {
        this.cellJustif = justif;
        this.isCellJustif = true;
    }

    protected int[] getCellJustif() {
        return this.cellJustif;
    }

    protected void setCellCount(int count) {
        this.cellCount = count;
    }

    protected int getCellCount() {
        return this.cellCount;
    }

    protected void resetState() {
        this.resetTextBuffer();
        this.headFlag = false;
        this.verbatimFlag = false;
        this.cellJustif = null;
        this.isCellJustif = false;
        this.cellCount = 0;
        this.evenTableRow = true;
    }

    protected void resetTextBuffer() {
        this.textBuffer = new StringBuffer();
    }

    public void section(int level, SinkEventAttributes attributes) {
        this.onSection(level, attributes);
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.onSectionTitle(level, attributes);
    }

    public void sectionTitle_(int level) {
        this.onSectionTitle_(level);
    }

    public void section_(int level) {
        this.onSection_(level);
    }

    public void section1() {
        this.onSection(1, null);
    }

    public void sectionTitle1() {
        this.onSectionTitle(1, null);
    }

    public void sectionTitle1_() {
        this.onSectionTitle_(1);
    }

    public void section1_() {
        this.onSection_(1);
    }

    public void section2() {
        this.onSection(2, null);
    }

    public void sectionTitle2() {
        this.onSectionTitle(2, null);
    }

    public void sectionTitle2_() {
        this.onSectionTitle_(2);
    }

    public void section2_() {
        this.onSection_(2);
    }

    public void section3() {
        this.onSection(3, null);
    }

    public void sectionTitle3() {
        this.onSectionTitle(3, null);
    }

    public void sectionTitle3_() {
        this.onSectionTitle_(3);
    }

    public void section3_() {
        this.onSection_(3);
    }

    public void section4() {
        this.onSection(4, null);
    }

    public void sectionTitle4() {
        this.onSectionTitle(4, null);
    }

    public void sectionTitle4_() {
        this.onSectionTitle_(4);
    }

    public void section4_() {
        this.onSection_(4);
    }

    public void section5() {
        this.onSection(5, null);
    }

    public void sectionTitle5() {
        this.onSectionTitle(5, null);
    }

    public void sectionTitle5_() {
        this.onSectionTitle_(5);
    }

    public void section5_() {
        this.onSection_(5);
    }

    protected void onSection(int depth, SinkEventAttributes attributes) {
        if (depth >= 1 && depth <= 5) {
            SinkEventAttributeSet att = new SinkEventAttributeSet();
            att.addAttribute(HTML.Attribute.CLASS, "section");
            att.addAttributes(SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES));
            att.removeAttribute(HTML.Attribute.ID.toString());
            this.writeStartTag(HtmlMarkup.DIV, (MutableAttributeSet)((Object)att));
        }
    }

    protected void onSection_(int depth) {
        if (depth >= 1 && depth <= 5) {
            this.writeEndTag(HtmlMarkup.DIV);
        }
    }

    protected void onSectionTitle(int depth, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (depth == 1) {
            this.writeStartTag(HtmlMarkup.H2, atts);
        } else if (depth == 2) {
            this.writeStartTag(HtmlMarkup.H3, atts);
        } else if (depth == 3) {
            this.writeStartTag(HtmlMarkup.H4, atts);
        } else if (depth == 4) {
            this.writeStartTag(HtmlMarkup.H5, atts);
        } else if (depth == 5) {
            this.writeStartTag(HtmlMarkup.H6, atts);
        }
    }

    protected void onSectionTitle_(int depth) {
        if (depth == 1) {
            this.writeEndTag(HtmlMarkup.H2);
        } else if (depth == 2) {
            this.writeEndTag(HtmlMarkup.H3);
        } else if (depth == 3) {
            this.writeEndTag(HtmlMarkup.H4);
        } else if (depth == 4) {
            this.writeEndTag(HtmlMarkup.H5);
        } else if (depth == 5) {
            this.writeEndTag(HtmlMarkup.H6);
        }
    }

    public void list() {
        this.list(null);
    }

    public void list(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.UL, atts);
    }

    public void list_() {
        this.writeEndTag(HtmlMarkup.UL);
    }

    public void listItem() {
        this.listItem(null);
    }

    public void listItem(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.LI, atts);
    }

    public void listItem_() {
        this.writeEndTag(HtmlMarkup.LI);
    }

    public void numberedList(int numbering) {
        this.numberedList(numbering, null);
    }

    public void numberedList(int numbering, SinkEventAttributes attributes) {
        String style;
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        switch (numbering) {
            case 2: {
                style = "upper-alpha";
                break;
            }
            case 1: {
                style = "lower-alpha";
                break;
            }
            case 4: {
                style = "upper-roman";
                break;
            }
            case 3: {
                style = "lower-roman";
                break;
            }
            default: {
                style = "decimal";
            }
        }
        Object atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet(1);
        }
        atts.addAttribute(HTML.Attribute.STYLE, "list-style-type: " + style);
        this.writeStartTag(HtmlMarkup.OL, (MutableAttributeSet)atts);
    }

    public void numberedList_() {
        this.writeEndTag(HtmlMarkup.OL);
    }

    public void numberedListItem() {
        this.numberedListItem(null);
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.LI, atts);
    }

    public void numberedListItem_() {
        this.writeEndTag(HtmlMarkup.LI);
    }

    public void definitionList() {
        this.definitionList(null);
    }

    public void definitionList(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DL, atts);
    }

    public void definitionList_() {
        this.writeEndTag(HtmlMarkup.DL);
    }

    public void definedTerm(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DT, atts);
    }

    public void definedTerm() {
        this.definedTerm(null);
    }

    public void definedTerm_() {
        this.writeEndTag(HtmlMarkup.DT);
    }

    public void definition() {
        this.definition(null);
    }

    public void definition(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DD, atts);
    }

    public void definition_() {
        this.writeEndTag(HtmlMarkup.DD);
    }

    public void figure() {
        this.write(String.valueOf('<') + HtmlMarkup.IMG);
        this.legacyFigure = true;
    }

    public void figure(SinkEventAttributes attributes) {
        this.inFigure = true;
        Object atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet(1);
        }
        if (!atts.isDefined("class")) {
            atts.addAttribute("class", "figure");
        }
        this.writeStartTag(HtmlMarkup.DIV, (MutableAttributeSet)atts);
    }

    public void figure_() {
        if (this.legacyFigure) {
            if (!this.figureCaptionFlag) {
                this.write(String.valueOf(' ') + HTML.Attribute.ALT + '=' + '\"' + '\"');
            }
            this.write(String.valueOf(' ') + '/' + '>');
            this.legacyFigure = false;
        } else {
            this.writeEndTag(HtmlMarkup.DIV);
            this.inFigure = false;
        }
        this.figureCaptionFlag = false;
    }

    public void figureGraphics(String name) {
        this.write(String.valueOf(' ') + HTML.Attribute.SRC + '=' + '\"' + name + '\"');
    }

    public void figureGraphics(String src, SinkEventAttributes attributes) {
        if (this.inFigure) {
            SinkEventAttributeSet atts = new SinkEventAttributeSet(1);
            atts.addAttribute("align", "center");
            this.writeStartTag(HtmlMarkup.P, (MutableAttributeSet)((Object)atts));
        }
        int count = attributes == null ? 1 : attributes.getAttributeCount() + 1;
        SinkEventAttributeSet atts = new SinkEventAttributeSet(count);
        atts.addAttribute(HTML.Attribute.SRC, src);
        atts.addAttributes(SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_IMG_ATTRIBUTES));
        if (atts.getAttribute(HTML.Attribute.ALT.toString()) == null) {
            atts.addAttribute(HTML.Attribute.ALT.toString(), "");
        }
        this.writeStartTag(HtmlMarkup.IMG, (MutableAttributeSet)((Object)atts), true);
        if (this.inFigure) {
            this.writeEndTag(HtmlMarkup.P);
        }
    }

    public void figureCaption() {
        this.figureCaptionFlag = true;
        this.write(String.valueOf(' ') + HTML.Attribute.ALT + '=' + '\"');
        this.legacyFigureCaption = true;
    }

    public void figureCaption(SinkEventAttributes attributes) {
        if (this.legacyFigureCaption) {
            this.write(String.valueOf(' ') + HTML.Attribute.ALT + '=' + '\"');
            this.legacyFigureCaption = false;
            this.figureCaptionFlag = true;
        } else {
            SinkEventAttributeSet atts = new SinkEventAttributeSet(1);
            atts.addAttribute("align", "center");
            atts.addAttributes(SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES));
            this.paragraph(atts);
            this.italic();
        }
    }

    public void figureCaption_() {
        if (this.legacyFigureCaption) {
            this.write(String.valueOf('\"'));
        } else {
            this.italic_();
            this.paragraph_();
        }
    }

    public void paragraph() {
        this.paragraph(null);
    }

    public void paragraph(SinkEventAttributes attributes) {
        this.paragraphFlag = true;
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.P, atts);
    }

    public void paragraph_() {
        if (this.paragraphFlag) {
            this.writeEndTag(HtmlMarkup.P);
            this.paragraphFlag = false;
        }
    }

    public void verbatim(boolean boxed) {
        if (boxed) {
            this.verbatim(SinkEventAttributeSet.BOXED);
        } else {
            this.verbatim(null);
        }
    }

    public void verbatim(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        this.verbatimFlag = true;
        Object atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_VERBATIM_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet();
        }
        boolean boxed = false;
        if (atts.isDefined("decoration")) {
            boxed = "boxed".equals(atts.getAttribute("decoration").toString());
        }
        if (boxed) {
            atts.addAttribute(HTML.Attribute.CLASS, "source");
        }
        atts.removeAttribute("decoration");
        String width = (String)atts.getAttribute(HTML.Attribute.WIDTH.toString());
        atts.removeAttribute(HTML.Attribute.WIDTH.toString());
        this.writeStartTag(HtmlMarkup.DIV, (MutableAttributeSet)atts);
        if (width != null) {
            atts.addAttribute(HTML.Attribute.WIDTH.toString(), width);
        }
        atts.removeAttribute(HTML.Attribute.ALIGN.toString());
        atts.removeAttribute(HTML.Attribute.CLASS.toString());
        this.writeStartTag(HtmlMarkup.PRE, (MutableAttributeSet)atts);
    }

    public void verbatim_() {
        this.writeEndTag(HtmlMarkup.PRE);
        this.writeEndTag(HtmlMarkup.DIV);
        this.verbatimFlag = false;
    }

    public void horizontalRule() {
        this.horizontalRule(null);
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_HR_ATTRIBUTES);
        this.writeSimpleTag(HtmlMarkup.HR, atts);
    }

    public void table() {
        this.table(null);
    }

    public void table(SinkEventAttributes attributes) {
        this.tableRows = false;
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        this.tableAttributes = attributes == null ? new SinkEventAttributeSet(0) : SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_TABLE_ATTRIBUTES);
    }

    public void table_() {
        this.tableRows = false;
        this.writeEndTag(HtmlMarkup.TABLE);
        String content = this.tempWriter.toString();
        String startTable = '<' + HtmlMarkup.TABLE.toString();
        if (content.lastIndexOf(startTable) == -1) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"table() NOT call firstly");
            }
            return;
        }
        content = content.substring(content.lastIndexOf(startTable));
        String startCaption = '<' + HtmlMarkup.CAPTION.toString() + '>';
        String endCaption = "" + '<' + '/' + HtmlMarkup.CAPTION.toString() + '>';
        if (content.indexOf(startCaption) != -1 && content.indexOf(endCaption) != -1) {
            int iStartCaption = content.indexOf(startCaption);
            int iEndCaption = content.indexOf(endCaption) + endCaption.length();
            String captionTag = content.substring(iStartCaption, iEndCaption);
            String contentWithoutCaption = StringUtils.replace((String)content, (String)captionTag, (String)"");
            String startTr = '<' + HtmlMarkup.TR.toString();
            StringBuffer text = new StringBuffer();
            text.append(contentWithoutCaption.substring(0, contentWithoutCaption.indexOf(startTr)));
            text.append(captionTag);
            text.append(contentWithoutCaption.substring(contentWithoutCaption.indexOf(startTr)));
            String contentWithCaption = this.tempWriter.toString();
            this.tempWriter = new StringWriter();
            this.tempWriter.write(StringUtils.replace((String)contentWithCaption, (String)content, (String)text.toString()));
        }
    }

    public void tableRows(int[] justification, boolean grid) {
        this.tableRows = true;
        this.cellJustif = justification;
        this.isCellJustif = true;
        if (this.tableAttributes == null) {
            this.tableAttributes = new SinkEventAttributeSet(0);
        }
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (!this.tableAttributes.isDefined(HTML.Attribute.ALIGN.toString())) {
            att.addAttribute(HTML.Attribute.ALIGN, "center");
        }
        if (!this.tableAttributes.isDefined(HTML.Attribute.BORDER.toString())) {
            att.addAttribute(HTML.Attribute.BORDER, grid ? "1" : "0");
        }
        if (!this.tableAttributes.isDefined(HTML.Attribute.CLASS.toString())) {
            att.addAttribute(HTML.Attribute.CLASS, "bodyTable");
        }
        att.addAttributes(this.tableAttributes);
        this.tableAttributes.removeAttributes(this.tableAttributes);
        this.writeStartTag(HtmlMarkup.TABLE, (MutableAttributeSet)((Object)att));
    }

    public void tableRows_() {
        this.tableRows = false;
        this.cellJustif = null;
        this.isCellJustif = false;
        this.evenTableRow = true;
    }

    public void tableRow() {
        if (!this.tableRows) {
            this.tableRows(null, false);
        }
        this.tableRow(null);
    }

    public void tableRow(SinkEventAttributes attributes) {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (this.evenTableRow) {
            att.addAttribute(HTML.Attribute.CLASS, "a");
        } else {
            att.addAttribute(HTML.Attribute.CLASS, "b");
        }
        att.addAttributes(SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_TR_ATTRIBUTES));
        this.writeStartTag(HtmlMarkup.TR, (MutableAttributeSet)((Object)att));
        this.evenTableRow = !this.evenTableRow;
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.writeEndTag(HtmlMarkup.TR);
        this.cellCount = 0;
    }

    public void tableCell() {
        this.tableCell((SinkEventAttributes)null);
    }

    public void tableHeaderCell() {
        this.tableHeaderCell((SinkEventAttributes)null);
    }

    public void tableCell(String width) {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute(HTML.Attribute.WIDTH, width);
        this.tableCell(false, (MutableAttributeSet)((Object)att));
    }

    public void tableHeaderCell(String width) {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute(HTML.Attribute.WIDTH, width);
        this.tableCell(true, (MutableAttributeSet)((Object)att));
    }

    public void tableCell(SinkEventAttributes attributes) {
        this.tableCell(false, (MutableAttributeSet)attributes);
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableCell(true, (MutableAttributeSet)attributes);
    }

    private void tableCell(boolean headerRow, MutableAttributeSet attributes) {
        String justif = null;
        if (this.cellJustif != null && this.isCellJustif) {
            switch (this.cellJustif[Math.min(this.cellCount, this.cellJustif.length - 1)]) {
                case 1: {
                    justif = "left";
                    break;
                }
                case 2: {
                    justif = "right";
                    break;
                }
                default: {
                    justif = "center";
                }
            }
        }
        HTML.Tag t = headerRow ? HtmlMarkup.TH : HtmlMarkup.TD;
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (justif != null) {
            att.addAttribute(HTML.Attribute.ALIGN, justif);
        }
        att.addAttributes(SinkUtils.filterAttributes(attributes, SinkUtils.SINK_TD_ATTRIBUTES));
        this.writeStartTag(t, (MutableAttributeSet)((Object)att));
    }

    public void tableCell_() {
        this.tableCell_(false);
    }

    public void tableHeaderCell_() {
        this.tableCell_(true);
    }

    private void tableCell_(boolean headerRow) {
        HTML.Tag t = headerRow ? HtmlMarkup.TH : HtmlMarkup.TD;
        this.writeEndTag(t);
        if (this.isCellJustif) {
            ++this.cellCount;
        }
    }

    public void tableCaption() {
        this.tableCaption(null);
    }

    public void tableCaption(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.CAPTION, atts);
    }

    public void tableCaption_() {
        this.writeEndTag(HtmlMarkup.CAPTION);
    }

    public void anchor(String name) {
        this.anchor(name, null);
    }

    public void anchor(String name, SinkEventAttributes attributes) {
        if (name == null) {
            throw new NullPointerException("Anchor name cannot be null!");
        }
        if (this.headFlag) {
            return;
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        String id = name;
        if (!DoxiaUtils.isValidId(id)) {
            id = DoxiaUtils.encodeId(name, true);
            String msg = "Modified invalid anchor name: '" + name + "' to '" + id + "'";
            this.logMessage("modifiedLink", msg);
        }
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute(HTML.Attribute.NAME, id);
        att.addAttributes(atts);
        this.writeStartTag(HtmlMarkup.A, (MutableAttributeSet)((Object)att));
    }

    public void anchor_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.A);
        }
    }

    public void link(String name) {
        this.link(name, null);
    }

    public void link(String name, SinkEventAttributes attributes) {
        if (attributes == null) {
            this.link(name, null, null);
        } else {
            String target = (String)attributes.getAttribute((Object)HTML.Attribute.TARGET.toString());
            MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_LINK_ATTRIBUTES);
            this.link(name, target, atts);
        }
    }

    private void link(String href, String target, MutableAttributeSet attributes) {
        if (href == null) {
            throw new NullPointerException("Link name cannot be null!");
        }
        if (this.headFlag) {
            return;
        }
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (DoxiaUtils.isExternalLink(href)) {
            att.addAttribute(HTML.Attribute.CLASS, "externalLink");
        }
        att.addAttribute(HTML.Attribute.HREF, HtmlTools.escapeHTML(href));
        if (target != null) {
            att.addAttribute(HTML.Attribute.TARGET, target);
        }
        if (attributes != null) {
            attributes.removeAttribute(HTML.Attribute.HREF.toString());
            attributes.removeAttribute(HTML.Attribute.TARGET.toString());
            att.addAttributes(attributes);
        }
        this.writeStartTag(HtmlMarkup.A, (MutableAttributeSet)((Object)att));
    }

    public void link_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.A);
        }
    }

    public void italic() {
        if (!this.headFlag) {
            this.writeStartTag(HtmlMarkup.I);
        }
    }

    public void italic_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.I);
        }
    }

    public void bold() {
        if (!this.headFlag) {
            this.writeStartTag(HtmlMarkup.B);
        }
    }

    public void bold_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.B);
        }
    }

    public void monospaced() {
        if (!this.headFlag) {
            this.writeStartTag(HtmlMarkup.TT);
        }
    }

    public void monospaced_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.TT);
        }
    }

    public void lineBreak() {
        this.lineBreak(null);
    }

    public void lineBreak(SinkEventAttributes attributes) {
        if (this.headFlag || this.isVerbatimFlag()) {
            this.getTextBuffer().append(EOL);
        } else {
            MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, SinkUtils.SINK_BR_ATTRIBUTES);
            this.writeSimpleTag(HtmlMarkup.BR, atts);
        }
    }

    public void pageBreak() {
        this.comment("PB");
    }

    public void nonBreakingSpace() {
        if (this.headFlag) {
            this.getTextBuffer().append(' ');
        } else {
            this.write("&#160;");
        }
    }

    public void text(String text) {
        if (this.headFlag) {
            this.getTextBuffer().append(text);
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    public void text(String text, SinkEventAttributes attributes) {
        if (attributes == null) {
            this.text(text);
        } else {
            if (attributes.containsAttribute((Object)"decoration", (Object)"underline")) {
                this.writeStartTag(HtmlMarkup.U);
            }
            if (attributes.containsAttribute((Object)"decoration", (Object)"line-through")) {
                this.writeStartTag(HtmlMarkup.S);
            }
            if (attributes.containsAttribute((Object)"valign", (Object)"sub")) {
                this.writeStartTag(HtmlMarkup.SUB);
            }
            if (attributes.containsAttribute((Object)"valign", (Object)"sup")) {
                this.writeStartTag(HtmlMarkup.SUP);
            }
            this.text(text);
            if (attributes.containsAttribute((Object)"valign", (Object)"sup")) {
                this.writeEndTag(HtmlMarkup.SUP);
            }
            if (attributes.containsAttribute((Object)"valign", (Object)"sub")) {
                this.writeEndTag(HtmlMarkup.SUB);
            }
            if (attributes.containsAttribute((Object)"decoration", (Object)"line-through")) {
                this.writeEndTag(HtmlMarkup.S);
            }
            if (attributes.containsAttribute((Object)"decoration", (Object)"underline")) {
                this.writeEndTag(HtmlMarkup.U);
            }
        }
    }

    public void rawText(String text) {
        if (this.headFlag) {
            this.getTextBuffer().append(text);
        } else {
            this.write(text);
        }
    }

    public void comment(String comment) {
        if (StringUtils.isNotEmpty((String)comment) && comment.indexOf("--") != -1) {
            String originalComment = comment;
            while (comment.indexOf("--") != -1) {
                comment = StringUtils.replace((String)comment, (String)"--", (String)"- -");
            }
            this.getLog().warn((CharSequence)("[Xhtml Sink] Modified invalid comment: '" + originalComment + "' to '" + comment + "'"));
        }
        StringBuffer buf = new StringBuffer(comment.length() + 9);
        buf.append('<').append('!').append('-').append('-').append(' ');
        buf.append(comment);
        buf.append(' ').append('-').append('-').append('>');
        this.write(buf.toString());
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        if (requiredParams == null || !(requiredParams[0] instanceof Integer)) {
            String msg = "No type information for unknown event: '" + name + "', ignoring!";
            this.logMessage("noTypeInfo", msg);
            return;
        }
        int tagType = (Integer)requiredParams[0];
        if (tagType == 4) {
            this.rawText(name);
            return;
        }
        if (tagType == 5) {
            this.rawText(EOL + "//<![CDATA[" + requiredParams[1] + "]]>" + EOL);
            return;
        }
        HTML.Tag tag = HtmlTools.getHtmlTag(name);
        if (tag == null) {
            String msg = "No HTML tag found for unknown event: '" + name + "', ignoring!";
            this.logMessage("noHtmlTag", msg);
        } else if (tagType == 1) {
            this.writeSimpleTag(tag, (MutableAttributeSet)attributes);
        } else if (tagType == 2) {
            this.writeStartTag(tag, (MutableAttributeSet)attributes);
        } else if (tagType == 3) {
            this.writeEndTag(tag);
        } else {
            String msg = "No type information for unknown event: '" + name + "', ignoring!";
            this.logMessage("noTypeInfo", msg);
        }
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.write(this.tempWriter.toString());
        this.tempWriter = new StringWriter();
        this.writer.close();
        if (this.getLog().isWarnEnabled() && this.warnMessages != null) {
            Iterator it = this.warnMessages.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Set set = (Set)entry.getValue();
                Iterator it2 = set.iterator();
                while (it2.hasNext()) {
                    String msg = (String)it2.next();
                    this.getLog().warn((CharSequence)msg);
                }
            }
            this.warnMessages = null;
        }
    }

    protected void content(String text) {
        text = XhtmlBaseSink.escapeHTML(text);
        text = StringUtils.replace((String)text, (String)"&amp;#", (String)"&#");
        this.write(text);
    }

    protected void verbatimContent(String text) {
        this.write(XhtmlBaseSink.escapeHTML(text));
    }

    protected static String escapeHTML(String text) {
        return HtmlTools.escapeHTML(text, false);
    }

    protected static String encodeURL(String text) {
        return HtmlTools.encodeURL(text);
    }

    protected void write(String text) {
        this.tempWriter.write(XhtmlBaseSink.unifyEOLs(text));
    }

    private void logMessage(String key, String msg) {
        TreeSet<String> set;
        msg = "[XHTML Sink] " + msg;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)msg);
            return;
        }
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap();
        }
        if ((set = (TreeSet<String>)this.warnMessages.get(key)) == null) {
            set = new TreeSet<String>();
        }
        set.add(msg);
        this.warnMessages.put(key, set);
    }
}

