/*
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 1.1 on 2010-05-24 22:50:43,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.doxia.document;

/**
 * A template that was used to create the document.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentTemplate
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The location of the document template.
     *           
     */
    private String href;

    /**
     * 
     *             The name of the document template.
     *           
     */
    private String title;

    /**
     * 
     *             The date and time when the template was last
     * modified, prior
     *             to being used to create the current document.
     *             Use the ISO 8601 format
     * "yyyy-MM-dd'T'HH:mm:ss.SSS" in xml.
     *           
     */
    private java.util.Date date;

    /**
     * 
     *             The date as String (recommended format is ISO
     * 8601) when the template was last modified.
     *             Only used if <code>date</code> is not set.
     *             @since 1.1.1
     *           .
     */
    private String modifydate;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof DocumentTemplate ) )
        {
            return false;
        }

        DocumentTemplate that = (DocumentTemplate) other;
        boolean result = true;

        result = result && ( getHref() == null ? that.getHref() == null : getHref().equals( that.getHref() ) );
        result = result && ( getTitle() == null ? that.getTitle() == null : getTitle().equals( that.getTitle() ) );
        result = result && ( getDate() == null ? that.getDate() == null : getDate().equals( that.getDate() ) );
        result = result && ( getModifydate() == null ? that.getModifydate() == null : getModifydate().equals( that.getModifydate() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get the date and time when the template was last modified,
     * prior
     *             to being used to create the current document.
     *             Use the ISO 8601 format
     * "yyyy-MM-dd'T'HH:mm:ss.SSS" in xml.
     * 
     * @return Date
     */
    public java.util.Date getDate()
    {
        return this.date;
    } //-- java.util.Date getDate()

    /**
     * Get the location of the document template.
     * 
     * @return String
     */
    public String getHref()
    {
        return this.href;
    } //-- String getHref()

    /**
     * Get the name of the document template.
     * 
     * @return String
     */
    public String getTitle()
    {
        return this.title;
    } //-- String getTitle()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( href != null ? href.hashCode() : 0 );
        result = 37 * result + ( title != null ? title.hashCode() : 0 );
        result = 37 * result + ( date != null ? date.hashCode() : 0 );
        result = 37 * result + ( modifydate != null ? modifydate.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Set the date and time when the template was last modified,
     * prior
     *             to being used to create the current document.
     *             Use the ISO 8601 format
     * "yyyy-MM-dd'T'HH:mm:ss.SSS" in xml.
     * 
     * @param date
     */
    public void setDate( java.util.Date date )
    {
        this.date = date;
    } //-- void setDate( java.util.Date )

    /**
     * Set the location of the document template.
     * 
     * @param href
     */
    public void setHref( String href )
    {
        this.href = href;
    } //-- void setHref( String )

    /**
     * Set the date as String (recommended format is ISO 8601) when
     * the template was last modified.
     *             Only used if <code>date</code> is not set.
     *             @since 1.1.1.
     * 
     * @param modifydate
     */
    public void setModifydate( String modifydate )
    {
        this.modifydate = modifydate;
    } //-- void setModifydate( String )

    /**
     * Set the name of the document template.
     * 
     * @param title
     */
    public void setTitle( String title )
    {
        this.title = title;
    } //-- void setTitle( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer( 128 );

        buf.append( "href = '" );
        buf.append( getHref() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "title = '" );
        buf.append( getTitle() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "date = '" );
        buf.append( getDate() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "modifydate = '" );
        buf.append( getModifydate() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()

    
            
    /** ISO 8601 date format, i.e. <code>yyyy-MM-dd</code> **/
    private static final java.text.DateFormat ISO_8601_FORMAT = new java.text.SimpleDateFormat( "yyyy-MM-dd", java.util.Locale.ENGLISH );

    /**
     * Get the date and time when the template was last modified.
     *
     * @return the <code>getDate()</code> if setted, formatted using ISO-8601 English format, otherwise return
     * the <code>modifydate</code>.
     * @since 1.1.1
     * @see #getDate()
     */
    public String getModifydate()
    {
        if ( getDate() != null )
        {
            return ISO_8601_FORMAT.format( getDate() );
        }

        return this.modifydate;
    }
            
          
}
