/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.document;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.document.DocumentAuthor;
import org.apache.maven.doxia.document.DocumentCover;
import org.apache.maven.doxia.document.DocumentHyperlinkBehaviour;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentStatistic;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.document.DocumentTemplate;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Reader;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Writer;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DocumentModelTest
extends PlexusTestCase {
    private static final DateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);

    public void testDocumentModel() throws Exception {
        DocumentModel model = this.getModel();
        this.verifyModel(model);
        DocumentModel copy = this.writeAndRecover(model);
        this.verifyModel(copy);
        DocumentModelTest.assertTrue((boolean)copy.equals((Object)model));
    }

    private DocumentModel getModel() {
        DocumentModel model = new DocumentModel();
        model.setOutputName("outputName");
        model.setModelEncoding("ISO-8859-1");
        model.setCover(this.getDocumentCover());
        model.setToc(this.getDocumentToc());
        model.setMeta(this.getDocumentMeta());
        return model;
    }

    private void verifyModel(DocumentModel model) {
        DocumentModelTest.assertTrue((boolean)model.equals((Object)model));
        DocumentModelTest.assertFalse((boolean)model.equals(null));
        DocumentModelTest.assertTrue((model.hashCode() != 0 ? 1 : 0) != 0);
        DocumentModelTest.assertTrue((model.toString().length() > 0 ? 1 : 0) != 0);
        DocumentModelTest.assertEquals((String)"outputName", (String)model.getOutputName());
        DocumentModelTest.assertEquals((String)"ISO-8859-1", (String)model.getModelEncoding());
        this.verifyDocumentCover(model.getCover());
        this.verifyDocumentTOC(model.getToc());
        this.verifyDocumentMeta(model.getMeta());
    }

    private DocumentAuthor getAuthor(int i) {
        DocumentAuthor author = new DocumentAuthor();
        author.setCity("city" + i);
        author.setCompanyName("companyName" + i);
        author.setCountry("country" + i);
        author.setEmail("email" + i);
        author.setFaxNumber("faxNumber" + i);
        author.setName("name" + i);
        author.setFirstName("firstName" + i);
        author.setInitials("initials" + i);
        author.setLastName("lastName" + i);
        author.setPhoneNumber("phoneNumber" + i);
        author.setPosition("position" + i);
        author.setPostalCode("postalCode" + i);
        author.setState("state" + i);
        author.setStreet("street" + i);
        author.setTitle("title" + i);
        return author;
    }

    private void verifyAuthor(DocumentAuthor documentAuthor, int i) {
        DocumentModelTest.assertEquals((String)("city" + i), (String)documentAuthor.getCity());
        DocumentModelTest.assertEquals((String)("companyName" + i), (String)documentAuthor.getCompanyName());
        DocumentModelTest.assertEquals((String)("country" + i), (String)documentAuthor.getCountry());
        DocumentModelTest.assertEquals((String)("email" + i), (String)documentAuthor.getEmail());
        DocumentModelTest.assertEquals((String)("faxNumber" + i), (String)documentAuthor.getFaxNumber());
        DocumentModelTest.assertEquals((String)("name" + i), (String)documentAuthor.getName());
        DocumentModelTest.assertEquals((String)("firstName" + i), (String)documentAuthor.getFirstName());
        DocumentModelTest.assertEquals((String)("initials" + i), (String)documentAuthor.getInitials());
        DocumentModelTest.assertEquals((String)("lastName" + i), (String)documentAuthor.getLastName());
        DocumentModelTest.assertEquals((String)("phoneNumber" + i), (String)documentAuthor.getPhoneNumber());
        DocumentModelTest.assertEquals((String)("position" + i), (String)documentAuthor.getPosition());
        DocumentModelTest.assertEquals((String)("postalCode" + i), (String)documentAuthor.getPostalCode());
        DocumentModelTest.assertEquals((String)("state" + i), (String)documentAuthor.getState());
        DocumentModelTest.assertEquals((String)("street" + i), (String)documentAuthor.getStreet());
        DocumentModelTest.assertEquals((String)("title" + i), (String)documentAuthor.getTitle());
    }

    private DocumentCover getDocumentCover() {
        DocumentCover cover = new DocumentCover();
        cover.addAuthor(this.getAuthor(1));
        cover.setAuthor("Author");
        cover.setCompanyLogo("companyLogo");
        cover.setCompanyName("companyName");
        cover.setCoverDate(new Date(0L));
        cover.setCoverSubTitle("coverSubTitle");
        cover.setCoverTitle("coverTitle");
        cover.setCoverType("coverType");
        cover.setCoverVersion("coverVersion");
        cover.setProjectLogo("projectLogo");
        cover.setProjectName("projectName");
        return cover;
    }

    private void verifyDocumentCover(DocumentCover cover) {
        List authors = cover.getAuthors();
        DocumentModelTest.assertEquals((int)1, (int)authors.size());
        this.verifyAuthor((DocumentAuthor)authors.get(0), 1);
        DocumentModelTest.assertEquals((String)"Author", (String)cover.getAuthor());
        DocumentModelTest.assertEquals((String)"companyLogo", (String)cover.getCompanyLogo());
        DocumentModelTest.assertEquals((String)"companyName", (String)cover.getCompanyName());
        DocumentModelTest.assertEquals((long)0L, (long)cover.getCoverDate().getTime());
        DocumentModelTest.assertEquals((String)ISO_8601_FORMAT.format(new Date(0L)), (String)cover.getCoverdate());
        DocumentModelTest.assertEquals((String)"coverSubTitle", (String)cover.getCoverSubTitle());
        DocumentModelTest.assertEquals((String)"coverTitle", (String)cover.getCoverTitle());
        DocumentModelTest.assertEquals((String)"coverType", (String)cover.getCoverType());
        DocumentModelTest.assertEquals((String)"coverVersion", (String)cover.getCoverVersion());
        DocumentModelTest.assertEquals((String)"projectLogo", (String)cover.getProjectLogo());
        DocumentModelTest.assertEquals((String)"projectName", (String)cover.getProjectName());
    }

    private DocumentStatistic getDocumentStatistic() {
        DocumentStatistic statistic = new DocumentStatistic();
        statistic.setCharacterCount(2L);
        statistic.setDrawCount(3L);
        statistic.setFrameCount(4L);
        statistic.setImageCount(5L);
        statistic.setNonWhitespaceCharacterCount(6L);
        statistic.setObjectCount(1L);
        statistic.setOleObjectCount(8L);
        statistic.setPageCount(7L);
        statistic.setParagraphCount(5L);
        statistic.setRowCount(6L);
        statistic.setSentenceCount(3L);
        statistic.setSyllableCount(10L);
        statistic.setTableCount(2L);
        statistic.setWordCount(11L);
        return statistic;
    }

    private void verifyDocumentStatistic(DocumentStatistic documentStatistic) {
        DocumentModelTest.assertEquals((long)2L, (long)documentStatistic.getCharacterCount());
        DocumentModelTest.assertEquals((long)3L, (long)documentStatistic.getDrawCount());
        DocumentModelTest.assertEquals((long)4L, (long)documentStatistic.getFrameCount());
        DocumentModelTest.assertEquals((long)5L, (long)documentStatistic.getImageCount());
        DocumentModelTest.assertEquals((long)6L, (long)documentStatistic.getNonWhitespaceCharacterCount());
        DocumentModelTest.assertEquals((long)1L, (long)documentStatistic.getObjectCount());
        DocumentModelTest.assertEquals((long)8L, (long)documentStatistic.getOleObjectCount());
        DocumentModelTest.assertEquals((long)7L, (long)documentStatistic.getPageCount());
        DocumentModelTest.assertEquals((long)5L, (long)documentStatistic.getParagraphCount());
        DocumentModelTest.assertEquals((long)6L, (long)documentStatistic.getRowCount());
        DocumentModelTest.assertEquals((long)3L, (long)documentStatistic.getSentenceCount());
        DocumentModelTest.assertEquals((long)10L, (long)documentStatistic.getSyllableCount());
        DocumentModelTest.assertEquals((long)2L, (long)documentStatistic.getTableCount());
        DocumentModelTest.assertEquals((long)11L, (long)documentStatistic.getWordCount());
    }

    private DocumentHyperlinkBehaviour getDocumentHyperlinkBehaviour() {
        DocumentHyperlinkBehaviour hylink = new DocumentHyperlinkBehaviour();
        hylink.setTargetFrame("targetFrame");
        return hylink;
    }

    private void verifyDocumentHyperlinkBehaviour(DocumentHyperlinkBehaviour hyperlinkBehaviour) {
        DocumentModelTest.assertEquals((String)"targetFrame", (String)hyperlinkBehaviour.getTargetFrame());
    }

    private DocumentMeta getDocumentMeta() {
        DocumentMeta meta = new DocumentMeta();
        meta.setAuthor("author");
        meta.addAuthor(this.getAuthor(2));
        meta.setConfidential(true);
        meta.setCreationDate(new Date(1L));
        meta.setCreator("creator");
        meta.setDate(new Date(2L));
        meta.setDescription("description");
        meta.setDocumentStatistic(this.getDocumentStatistic());
        meta.setDraft(true);
        meta.setEditingCycles(15L);
        meta.setEditingDuration(3L);
        meta.setGenerator("generator");
        meta.setHyperlinkBehaviour(this.getDocumentHyperlinkBehaviour());
        meta.setInitialCreator("initialCreator");
        meta.addKeyWord("keyword1");
        meta.addKeyWord("keyword2");
        meta.setLanguage("language");
        meta.setPageSize("pageSize");
        meta.setPrintDate(new Date(4L));
        meta.setPrintedBy("printedBy");
        meta.setSubject("subject");
        meta.setTemplate(this.getDocumentTemplate());
        meta.setTitle("title");
        return meta;
    }

    private void verifyDocumentMeta(DocumentMeta meta) {
        DocumentModelTest.assertEquals((String)"author", (String)meta.getAuthor());
        List authors = meta.getAuthors();
        DocumentModelTest.assertEquals((int)1, (int)authors.size());
        this.verifyAuthor((DocumentAuthor)authors.get(0), 2);
        DocumentModelTest.assertTrue((boolean)meta.isConfidential());
        DocumentModelTest.assertEquals((long)1L, (long)meta.getCreationDate().getTime());
        DocumentModelTest.assertEquals((String)"creator", (String)meta.getCreator());
        DocumentModelTest.assertEquals((long)2L, (long)meta.getDate().getTime());
        DocumentModelTest.assertEquals((String)"description", (String)meta.getDescription());
        this.verifyDocumentStatistic(meta.getDocumentStatistic());
        DocumentModelTest.assertTrue((boolean)meta.isDraft());
        DocumentModelTest.assertEquals((long)15L, (long)meta.getEditingCycles());
        DocumentModelTest.assertEquals((long)3L, (long)meta.getEditingDuration());
        DocumentModelTest.assertEquals((String)"generator", (String)meta.getGenerator());
        this.verifyDocumentHyperlinkBehaviour(meta.getHyperlinkBehaviour());
        DocumentModelTest.assertEquals((String)"initialCreator", (String)meta.getInitialCreator());
        DocumentModelTest.assertEquals((String)"keyword1, keyword2", (String)meta.getAllKeyWords());
        DocumentModelTest.assertEquals((String)"language", (String)meta.getLanguage());
        DocumentModelTest.assertEquals((String)"pageSize", (String)meta.getPageSize());
        DocumentModelTest.assertEquals((long)4L, (long)meta.getPrintDate().getTime());
        DocumentModelTest.assertEquals((String)"printedBy", (String)meta.getPrintedBy());
        DocumentModelTest.assertEquals((String)"subject", (String)meta.getSubject());
        this.verifyDocumentTemplate(meta.getTemplate());
        DocumentModelTest.assertEquals((String)"title", (String)meta.getTitle());
    }

    private DocumentTemplate getDocumentTemplate() {
        DocumentTemplate template = new DocumentTemplate();
        template.setDate(new Date(3L));
        template.setHref("href");
        template.setTitle("title");
        return template;
    }

    private void verifyDocumentTemplate(DocumentTemplate template) {
        DocumentModelTest.assertEquals((long)3L, (long)template.getDate().getTime());
        DocumentModelTest.assertEquals((String)"href", (String)template.getHref());
        DocumentModelTest.assertEquals((String)"title", (String)template.getTitle());
    }

    private DocumentTOC getDocumentToc() {
        DocumentTOCItem item1 = new DocumentTOCItem();
        item1.setName("First document");
        item1.setRef("doc1.apt");
        DocumentTOCItem item2 = new DocumentTOCItem();
        item2.setName("Second document");
        item2.setRef("doc2.xml");
        DocumentTOC toc = new DocumentTOC();
        toc.setName("name");
        toc.addItem(item1);
        toc.addItem(item2);
        return toc;
    }

    private void verifyDocumentTOC(DocumentTOC toc) {
        DocumentModelTest.assertEquals((String)"name", (String)toc.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentModel writeAndRecover(DocumentModel model) throws IOException {
        DocumentModel documentModel;
        File dir = DocumentModelTest.getTestFile((String)"target/test-output/xpp3/");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File testFile = DocumentModelTest.getTestFile((String)dir.getAbsolutePath(), (String)"testModel.xml");
        XmlStreamWriter w = null;
        try {
            w = WriterFactory.newXmlWriter((File)testFile);
            new DocumentXpp3Writer().write((Writer)w, model);
        }
        finally {
            IOUtil.close((Writer)w);
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)testFile);
            documentModel = new DocumentXpp3Reader().read((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw (IOException)new IOException("Error parsing document descriptor").initCause(e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return documentModel;
    }
}

