/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.util.Iterator;
import org.apache.maven.doxia.parser.XhtmlBaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventElement;
import org.apache.maven.doxia.sink.SinkEventTestingSink;
import org.codehaus.plexus.PlexusTestCase;

public class XhtmlBaseParserTest
extends PlexusTestCase {
    private XhtmlBaseParser parser;
    private final SinkEventTestingSink sink = new SinkEventTestingSink();

    protected void setUp() throws Exception {
        super.setUp();
        this.parser = new XhtmlBaseParser();
        this.parser.getLog().setLogLevel(3);
        this.sink.reset();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testHeadingEventsList() throws Exception {
        String text = "<p><h2></h2><h3></h3><h4></h4><h5></h5><h6></h6><h2></h2></p>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section1", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section2", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle2", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle2_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section3", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle3", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle3_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section4", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle4", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle4_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section5", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle5", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle5_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section5_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section4_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section3_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section2_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section1_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section1", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testNestedHeadingEventsList() throws Exception {
        String text = "<p><h2></h2><h6></h6><h3></h3></p>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section1", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section2", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section3", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section4", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section5", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle5", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle5_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section5_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section4_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section3_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section2_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"section2", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle2", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle2_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testFigureEventsList() throws Exception {
        String text = "<img src=\"source\" title=\"caption\" />";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"figureGraphics", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testTableEventsList() throws Exception {
        String text = "<table align=\"center\"><tr><th>Header</th></tr><tr><td>cell</td></tr></table>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"table", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRows", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableHeaderCell", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableHeaderCell_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableCell", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableCell_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRows_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"table_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testSignificantWhiteSpace() throws Exception {
        String text = "<p><b>word</b> <i>word</i></p>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"bold", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"bold_", (String)((SinkEventElement)it.next()).getName());
        SinkEventElement el = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)el.getName());
        XhtmlBaseParserTest.assertEquals((String)" ", (String)((String)el.getArgs()[0]));
        XhtmlBaseParserTest.assertEquals((String)"italic", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"italic_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
        String eol = System.getProperty("line.separator");
        text = "<p><b>word</b>" + eol + "<i>word</i></p>";
        this.sink.reset();
        this.parser.parse(text, (Sink)this.sink);
        it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"bold", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"bold_", (String)((SinkEventElement)it.next()).getName());
        el = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)el.getName());
        XhtmlBaseParserTest.assertEquals((String)"\n", (String)((String)el.getArgs()[0]));
        XhtmlBaseParserTest.assertEquals((String)"italic", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"italic_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
        text = "<p>There should be no space after the last <i>word</i>.</p>";
        this.sink.reset();
        this.parser.parse(text, (Sink)this.sink);
        it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"italic", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"italic_", (String)((SinkEventElement)it.next()).getName());
        el = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)el.getName());
        XhtmlBaseParserTest.assertEquals((String)".", (String)((String)el.getArgs()[0]));
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testPreFormattedText() throws Exception {
        String text = "<pre><a href=\"what.html\">what</a></pre>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"verbatim", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"link", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"verbatim_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
        text = "<pre><![CDATA[<a href=\"what.html\">what</a>]]></pre>";
        this.sink.reset();
        this.parser.parse(text, (Sink)this.sink);
        it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"verbatim", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"verbatim_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
        text = "<pre><![CDATA[<pre>what</pre>]]></pre>";
        this.sink.reset();
        this.parser.parse(text, (Sink)this.sink);
        it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"verbatim", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"verbatim_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testPreEOL() throws Exception {
        String text = "<pre><a href=\"what.html\">what</a>" + XhtmlBaseParser.EOL + "<a href=\"what.html\">what</a></pre>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"verbatim", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"link", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"link", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"verbatim_", (String)((SinkEventElement)it.next()).getName());
    }

    public void testDoxia250() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE test [").append(XhtmlBaseParser.EOL);
        sb.append("<!ENTITY foo \"&#x159;\">").append(XhtmlBaseParser.EOL);
        sb.append("<!ENTITY foo1 \"&nbsp;\">").append(XhtmlBaseParser.EOL);
        sb.append("<!ENTITY foo2 \"&#x161;\">").append(XhtmlBaseParser.EOL);
        sb.append("<!ENTITY tritPos \"&#x1d7ed;\">").append(XhtmlBaseParser.EOL);
        sb.append("]>").append(XhtmlBaseParser.EOL);
        sb.append("<b>&foo;&foo1;&foo2;&tritPos;</b>");
        this.parser.setValidate(false);
        this.parser.parse(sb.toString(), (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        SinkEventElement event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"bold", (String)event.getName());
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"\u0159", (String)((String)event.getArgs()[0]));
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"\u00a0", (String)((String)event.getArgs()[0]));
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"\u0161", (String)((String)event.getArgs()[0]));
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"\ud835\udfed", (String)((String)event.getArgs()[0]));
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"bold_", (String)event.getName());
    }

    public void testEntities() throws Exception {
        String text = "<!DOCTYPE test [<!ENTITY flo \"&#x159;\"><!ENTITY tritPos \"&#x1d7ed;\"><!ENTITY fo \"&#65;\"><!ENTITY myCustom \"&fo;\">]><body><h2>&amp;&flo;&#x159;&tritPos;&#x1d7ed;</h2><p>&amp;&flo;&#x159;&tritPos;&#x1d7ed;&myCustom;</p></body>";
        this.parser.setValidate(false);
        this.parser.parse("<!DOCTYPE test [<!ENTITY flo \"&#x159;\"><!ENTITY tritPos \"&#x1d7ed;\"><!ENTITY fo \"&#65;\"><!ENTITY myCustom \"&fo;\">]><body><h2>&amp;&flo;&#x159;&tritPos;&#x1d7ed;</h2><p>&amp;&flo;&#x159;&tritPos;&#x1d7ed;&myCustom;</p></body>", (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"section1", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1", (String)((SinkEventElement)it.next()).getName());
        SinkEventElement textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"&", (Object)textEvt.getArgs()[0]);
        textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\u0159", (Object)textEvt.getArgs()[0]);
        textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\u0159", (Object)textEvt.getArgs()[0]);
        textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((String)"\ud835\udfed", (String)((String)textEvt.getArgs()[0]));
        textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\ud835\udfed", (Object)textEvt.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)((SinkEventElement)it.next()).getName());
        textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"&", (Object)textEvt.getArgs()[0]);
        textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\u0159", (Object)textEvt.getArgs()[0]);
        textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\u0159", (Object)textEvt.getArgs()[0]);
        textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((String)"\ud835\udfed", (String)((String)textEvt.getArgs()[0]));
        textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\ud835\udfed", (Object)textEvt.getArgs()[0]);
        textEvt = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"A", (Object)textEvt.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testDecoration() throws Exception {
        String text = "<div><u>u</u><s>s</s><del>del</del><strike>strike</strike><sub>sub</sub><sup>sup</sup></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        SinkEventElement event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"u", (String)((String)event.getArgs()[0]));
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"s", (String)((String)event.getArgs()[0]));
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"del", (String)((String)event.getArgs()[0]));
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"strike", (String)((String)event.getArgs()[0]));
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"sub", (String)((String)event.getArgs()[0]));
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"sup", (String)((String)event.getArgs()[0]));
    }

    public void testLists() throws Exception {
        String text = "<div><ul><li></li></ul><ol><li></li></ol><dl><dt></dt><dd></dd></dl></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"list", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"listItem", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"listItem_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"list_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"numberedList", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"numberedListItem", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"numberedListItem_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"numberedList_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"definitionList", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"definitionListItem", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"definedTerm", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"definedTerm_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"definition", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"definition_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"definitionListItem_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"definitionList_", (String)((SinkEventElement)it.next()).getName());
    }

    public void testStyles() throws Exception {
        String text = "<div><b></b><strong></strong><i></i><em></em><code></code><samp></samp><tt></tt></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"bold", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"bold_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"bold", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"bold_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"italic", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"italic_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"italic", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"italic_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced_", (String)((SinkEventElement)it.next()).getName());
    }

    public void testSimpleTags() throws Exception {
        String text = "<div><br/><hr/><img src=\"img.src\"/></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"lineBreak", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"horizontalRule", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"figureGraphics", (String)((SinkEventElement)it.next()).getName());
    }

    public void testSpecial() throws Exception {
        String text = "<p><!-- a pagebreak: --><!-- PB -->&nbsp;&#160;<unknown /></p>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"comment", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"pageBreak", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"nonBreakingSpace", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"nonBreakingSpace", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)((SinkEventElement)it.next()).getName());
    }

    public void testTable() throws Exception {
        String text = "<table><caption></caption><tr><th></th></tr><tr><td></td></tr></table>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"table", (String)((SinkEventElement)it.next()).getName());
        SinkEventElement el = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"tableRows", (String)el.getName());
        XhtmlBaseParserTest.assertFalse((boolean)((Boolean)el.getArgs()[1]));
        XhtmlBaseParserTest.assertEquals((String)"tableCaption", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableCaption_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableHeaderCell", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableHeaderCell_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableCell", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableCell_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRows_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"table_", (String)((SinkEventElement)it.next()).getName());
    }

    public void testFigure() throws Exception {
        String text = "<div class=\"figure\"><p><img src=\"src.jpg\"/></p><p><i></i></p></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"figure", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"figureGraphics", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"figureCaption", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"figureCaption_", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertEquals((String)"figure_", (String)((SinkEventElement)it.next()).getName());
    }

    public void testAnchorLink() throws Exception {
        String text = "<div><a href=\"\"></a><a href=\"valid\"></a><a href=\"#1invalid\"></a><a href=\"http://www.fo.com/index.html#1invalid\"></a><a name=\"valid\"></a><a name=\"1invalid\"></a><a id=\"1invalid\"></a></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        SinkEventElement element = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"link", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)((SinkEventElement)it.next()).getName());
        element = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"link", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"valid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)((SinkEventElement)it.next()).getName());
        element = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"link", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"#a1invalid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)((SinkEventElement)it.next()).getName());
        element = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"link", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"http://www.fo.com/index.html#1invalid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)((SinkEventElement)it.next()).getName());
        element = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"anchor", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"valid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"anchor_", (String)((SinkEventElement)it.next()).getName());
        element = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"anchor", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"a1invalid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"anchor_", (String)((SinkEventElement)it.next()).getName());
        element = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"anchor", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"a1invalid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"anchor_", (String)((SinkEventElement)it.next()).getName());
    }

    public void testAttributeEntities() throws Exception {
        String text = "<script type=\"text/javascript\" src=\"http://ex.com/ex.js?v=l&amp;l=e\"></script>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator it = this.sink.getEventList().iterator();
        SinkEventElement event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"unknown", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((Object)"script", (Object)event.getArgs()[0]);
        SinkEventAttributeSet attribs = (SinkEventAttributeSet)event.getArgs()[2];
        XhtmlBaseParserTest.assertEquals((Object)"http://ex.com/ex.js?v=l&l=e", (Object)attribs.getAttribute((Object)"src"));
        XhtmlBaseParserTest.assertEquals((String)"unknown", (String)((SinkEventElement)it.next()).getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
        this.sink.reset();
        text = "<img src=\"http://ex.com/ex.jpg?v=l&amp;l=e\" alt=\"image\"/>";
        this.parser.parse(text, (Sink)this.sink);
        it = this.sink.getEventList().iterator();
        event = (SinkEventElement)it.next();
        XhtmlBaseParserTest.assertEquals((String)"figureGraphics", (String)event.getName());
        attribs = (SinkEventAttributeSet)event.getArgs()[1];
        XhtmlBaseParserTest.assertEquals((Object)"http://ex.com/ex.jpg?v=l&l=e", (Object)attribs.getAttribute((Object)"src"));
    }
}

