/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.doxia.AbstractModuleTest;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.logging.PlexusLoggerWrapper;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkTestDocument;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractSinkTest
extends AbstractModuleTest {
    private final CharArrayWriter testWriter = new CharArrayWriter();
    private Sink sink;

    protected void setUp() throws Exception {
        super.setUp();
        this.testWriter.reset();
        this.sink = this.createSink(this.testWriter);
        this.sink.enableLogging((Log)new PlexusLoggerWrapper(this.getContainer().getLogger()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testTestDocument() throws IOException {
        Writer writer = this.isXmlSink() ? this.getXmlTestWriter("testDocument") : this.getTestWriter("testDocument");
        Sink testSink = this.createSink(writer);
        try {
            SinkTestDocument.generate(testSink);
        }
        finally {
            testSink.close();
            IOUtil.close((Writer)writer);
        }
    }

    public void testTitle() {
        String title = "Grodek";
        this.sink.title();
        this.sink.text(title);
        this.sink.title_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getTitleBlock(title);
        AbstractSinkTest.assertEquals((String)"Wrong title!", (String)expected, (String)actual);
    }

    public void testAuthor() {
        String author = "Georg_Trakl";
        this.sink.author();
        this.sink.text(author);
        this.sink.author_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getAuthorBlock(author);
        AbstractSinkTest.assertEquals((String)"Wrong author!", (String)expected, (String)actual);
    }

    public void testDate() {
        String date = "1914";
        this.sink.date();
        this.sink.text(date);
        this.sink.date_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getDateBlock(date);
        AbstractSinkTest.assertEquals((String)"Wrong date!", (String)expected, (String)actual);
    }

    public void testHead() {
        this.sink.head();
        this.sink.head_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getHeadBlock();
        AbstractSinkTest.assertEquals((String)"Wrong head!", (String)expected, (String)actual);
    }

    public void testBody() {
        this.sink.body();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getBodyBlock();
        AbstractSinkTest.assertEquals((String)"Wrong body!", (String)expected, (String)actual);
    }

    public void testSectionTitle() {
        String title = "Title";
        this.sink.sectionTitle();
        this.sink.text(title);
        this.sink.sectionTitle_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getSectionTitleBlock(title);
        AbstractSinkTest.assertEquals((String)"Wrong sectionTitle!", (String)expected, (String)actual);
    }

    public void testSection1() {
        String title = "Title1";
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(title);
        this.sink.sectionTitle1_();
        this.sink.section1_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getSection1Block(title);
        AbstractSinkTest.assertEquals((String)"Wrong section1 block!", (String)expected, (String)actual);
    }

    public void testSection2() {
        String title = "Title2";
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(title);
        this.sink.sectionTitle2_();
        this.sink.section2_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getSection2Block(title);
        AbstractSinkTest.assertEquals((String)"Wrong section2 block!", (String)expected, (String)actual);
    }

    public void testSection3() {
        String title = "Title3";
        this.sink.section3();
        this.sink.sectionTitle3();
        this.sink.text(title);
        this.sink.sectionTitle3_();
        this.sink.section3_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getSection3Block(title);
        AbstractSinkTest.assertEquals((String)"Wrong section3 block!", (String)expected, (String)actual);
    }

    public void testSection4() {
        String title = "Title4";
        this.sink.section4();
        this.sink.sectionTitle4();
        this.sink.text(title);
        this.sink.sectionTitle4_();
        this.sink.section4_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getSection4Block(title);
        AbstractSinkTest.assertEquals((String)"Wrong section4 block!", (String)expected, (String)actual);
    }

    public void testSection5() {
        String title = "Title5";
        this.sink.section5();
        this.sink.sectionTitle5();
        this.sink.text(title);
        this.sink.sectionTitle5_();
        this.sink.section5_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getSection5Block(title);
        AbstractSinkTest.assertEquals((String)"Wrong section5 block!", (String)expected, (String)actual);
    }

    public void testList() {
        String item = "list_item";
        this.sink.list();
        this.sink.listItem();
        this.sink.text(item);
        this.sink.listItem_();
        this.sink.list_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getListBlock(item);
        AbstractSinkTest.assertEquals((String)"Wrong list!", (String)expected, (String)actual);
    }

    public void testNumberedList() {
        String item = "numbered_list_item";
        this.sink.numberedList(3);
        this.sink.numberedListItem();
        this.sink.text(item);
        this.sink.numberedListItem_();
        this.sink.numberedList_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getNumberedListBlock(item);
        AbstractSinkTest.assertEquals((String)"Wrong numbered list!", (String)expected, (String)actual);
    }

    public void testDefinitionList() {
        String definum = "definum";
        String definition = "definition";
        this.sink.definitionList();
        this.sink.definitionListItem();
        this.sink.definedTerm();
        this.sink.text(definum);
        this.sink.definedTerm_();
        this.sink.definition();
        this.sink.text(definition);
        this.sink.definition_();
        this.sink.definitionListItem_();
        this.sink.definitionList_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getDefinitionListBlock(definum, definition);
        AbstractSinkTest.assertEquals((String)"Wrong definition list!", (String)expected, (String)actual);
    }

    public void testFigure() {
        String source = "figure.jpg";
        String caption = "Figure_caption";
        this.sink.figure();
        this.sink.figureGraphics(source);
        this.sink.figureCaption();
        this.sink.text(caption);
        this.sink.figureCaption_();
        this.sink.figure_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getFigureBlock(source, caption);
        AbstractSinkTest.assertEquals((String)"Wrong figure!", (String)expected, (String)actual);
    }

    public void testTable() {
        String cell = "cell";
        String caption = "Table_caption";
        int[] justify = new int[]{0};
        this.sink.table();
        this.sink.tableRows(justify, false);
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.text(cell);
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRows_();
        this.sink.tableCaption();
        this.sink.text(caption);
        this.sink.tableCaption_();
        this.sink.table_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getTableBlock(cell, caption);
        AbstractSinkTest.assertEquals((String)"Wrong table!", (String)expected, (String)actual);
    }

    public void testParagraph() {
        String text = "Text";
        this.sink.paragraph();
        this.sink.text(text);
        this.sink.paragraph_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getParagraphBlock(text);
        AbstractSinkTest.assertEquals((String)"Wrong paragraph!", (String)expected, (String)actual);
    }

    public void testVerbatim() {
        String text = "Text";
        this.sink.verbatim(SinkEventAttributeSet.BOXED);
        this.sink.text(text);
        this.sink.verbatim_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getVerbatimBlock(text);
        AbstractSinkTest.assertEquals((String)"Wrong verbatim!", (String)expected, (String)actual);
    }

    public void testHorizontalRule() {
        this.sink.horizontalRule();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getHorizontalRuleBlock();
        AbstractSinkTest.assertEquals((String)"Wrong horizontal rule!", (String)expected, (String)actual);
    }

    public void testPageBreak() {
        this.sink.pageBreak();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getPageBreakBlock();
        AbstractSinkTest.assertEquals((String)"Wrong pageBreak!", (String)expected, (String)actual);
    }

    public void testAnchor() {
        String anchor = "Anchor";
        this.sink.anchor(anchor);
        this.sink.text(anchor);
        this.sink.anchor_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getAnchorBlock(anchor);
        AbstractSinkTest.assertEquals((String)"Wrong anchor!", (String)expected, (String)actual);
    }

    public void testLink() {
        String link = "#Link";
        String text = "Text";
        this.sink.link(link);
        this.sink.text(text);
        this.sink.link_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getLinkBlock(link, text);
        AbstractSinkTest.assertEquals((String)"Wrong link!", (String)expected, (String)actual);
    }

    public void testItalic() {
        String text = "Italic";
        this.sink.italic();
        this.sink.text(text);
        this.sink.italic_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getItalicBlock(text);
        AbstractSinkTest.assertEquals((String)"Wrong italic!", (String)expected, (String)actual);
    }

    public void testBold() {
        String text = "Bold";
        this.sink.bold();
        this.sink.text(text);
        this.sink.bold_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getBoldBlock(text);
        AbstractSinkTest.assertEquals((String)"Wrong bold!", (String)expected, (String)actual);
    }

    public void testMonospaced() {
        String text = "Monospaced";
        this.sink.monospaced();
        this.sink.text(text);
        this.sink.monospaced_();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getMonospacedBlock(text);
        AbstractSinkTest.assertEquals((String)"Wrong monospaced!", (String)expected, (String)actual);
    }

    public void testLineBreak() {
        this.sink.lineBreak();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getLineBreakBlock();
        AbstractSinkTest.assertEquals((String)"Wrong lineBreak!", (String)expected, (String)actual);
    }

    public void testNonBreakingSpace() {
        this.sink.nonBreakingSpace();
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getNonBreakingSpaceBlock();
        AbstractSinkTest.assertEquals((String)"Wrong nonBreakingSpace!", (String)expected, (String)actual);
    }

    public void testText() {
        String text = "~,_=,_-,_+,_*,_[,_],_<,_>,_{,_},_\\";
        this.sink.text(text);
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getTextBlock(text);
        AbstractSinkTest.assertEquals((String)"Wrong text!", (String)expected, (String)actual);
    }

    public void testRawText() {
        String text = "~,_=,_-,_+,_*,_[,_],_<,_>,_{,_},_\\";
        this.sink.rawText(text);
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getRawTextBlock(text);
        AbstractSinkTest.assertEquals((String)"Wrong rawText!", (String)expected, (String)actual);
    }

    public void testComment() {
        String comment = "Simple comment with ----";
        this.sink.comment(comment);
        this.sink.flush();
        this.sink.close();
        String actual = this.testWriter.toString();
        String expected = this.getCommentBlock(comment);
        AbstractSinkTest.assertEquals((String)"Wrong comment!", (String)expected, (String)actual);
    }

    protected Sink getSink() {
        return this.sink;
    }

    protected String getSinkContent() {
        return this.testWriter.toString();
    }

    protected String getOutputDir() {
        return "sink/";
    }

    protected abstract boolean isXmlSink();

    protected abstract Sink createSink(Writer var1);

    protected abstract String getTitleBlock(String var1);

    protected abstract String getAuthorBlock(String var1);

    protected abstract String getDateBlock(String var1);

    protected abstract String getHeadBlock();

    protected abstract String getBodyBlock();

    protected abstract String getSectionTitleBlock(String var1);

    protected abstract String getSection1Block(String var1);

    protected abstract String getSection2Block(String var1);

    protected abstract String getSection3Block(String var1);

    protected abstract String getSection4Block(String var1);

    protected abstract String getSection5Block(String var1);

    protected abstract String getListBlock(String var1);

    protected abstract String getNumberedListBlock(String var1);

    protected abstract String getDefinitionListBlock(String var1, String var2);

    protected abstract String getFigureBlock(String var1, String var2);

    protected abstract String getTableBlock(String var1, String var2);

    protected abstract String getParagraphBlock(String var1);

    protected abstract String getVerbatimBlock(String var1);

    protected abstract String getHorizontalRuleBlock();

    protected abstract String getPageBreakBlock();

    protected abstract String getAnchorBlock(String var1);

    protected abstract String getLinkBlock(String var1, String var2);

    protected abstract String getItalicBlock(String var1);

    protected abstract String getBoldBlock(String var1);

    protected abstract String getMonospacedBlock(String var1);

    protected abstract String getLineBreakBlock();

    protected abstract String getNonBreakingSpaceBlock();

    protected abstract String getTextBlock(String var1);

    protected abstract String getRawTextBlock(String var1);

    protected abstract String getCommentBlock(String var1);
}

