/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.PlexusTestCase;

public abstract class AbstractSinkTestCase
extends PlexusTestCase {
    private Writer testWriter;

    public void testApt() throws Exception {
        Parser parser = this.createParser();
        parser.parse(this.getTestReader(), this.createSink());
    }

    protected abstract String outputExtension();

    protected abstract Parser createParser();

    protected abstract Sink createSink() throws Exception;

    protected Writer getTestWriter() throws Exception {
        if (this.testWriter == null) {
            File outputDirectory = new File(this.getBasedirFile(), "target/output");
            if (!outputDirectory.exists()) {
                outputDirectory.mkdirs();
            }
            this.testWriter = new FileWriter(new File(outputDirectory, "test." + this.outputExtension()));
        }
        return this.testWriter;
    }

    protected Reader getTestReader() throws Exception {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test.apt");
        InputStreamReader reader = new InputStreamReader(is);
        return reader;
    }

    public File getBasedirFile() {
        return new File(AbstractSinkTestCase.getBasedir());
    }
}

