/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import junit.framework.TestCase;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkUtils;

public class SinkUtilsTest
extends TestCase {
    public void testGetAttributeString() {
        SinkUtilsTest.assertEquals((String)"", (String)SinkUtils.getAttributeString(null));
        SinkEventAttributeSet att = new SinkEventAttributeSet((AttributeSet)SinkEventAttributeSet.BOXED);
        String expResult = " decoration=\"boxed\"";
        String result = SinkUtils.getAttributeString((AttributeSet)att);
        SinkUtilsTest.assertEquals((String)expResult, (String)result);
        SinkEventAttributeSet at = new SinkEventAttributeSet((AttributeSet)SinkEventAttributeSet.BOLD);
        at.addAttributes((AttributeSet)att);
        expResult = " style=\"bold\" decoration=\"boxed\"";
        result = SinkUtils.getAttributeString((AttributeSet)at);
        SinkUtilsTest.assertEquals((String)expResult, (String)result);
        att = new SinkEventAttributeSet(new String[]{"color", "red", "margin-left", "20px"});
        at = new SinkEventAttributeSet();
        at.addAttribute((Object)"style", (Object)att);
        expResult = " style=\"color: red; margin-left: 20px\"";
        result = SinkUtils.getAttributeString((AttributeSet)at);
        SinkUtilsTest.assertEquals((String)expResult, (String)result);
    }

    public void testFilterAttributes() {
        SinkUtilsTest.assertNull((Object)SinkUtils.filterAttributes(null, null));
        SinkEventAttributeSet attributes = new SinkEventAttributeSet(1);
        String[] valids = null;
        MutableAttributeSet result = SinkUtils.filterAttributes((AttributeSet)attributes, valids);
        SinkUtilsTest.assertEquals((int)0, (int)result.getAttributeCount());
        valids = new String[]{};
        result = SinkUtils.filterAttributes((AttributeSet)attributes, (String[])valids);
        SinkUtilsTest.assertEquals((int)0, (int)result.getAttributeCount());
        result = SinkUtils.filterAttributes((AttributeSet)SinkEventAttributeSet.BOLD, (String[])SinkUtils.SINK_BASE_ATTRIBUTES);
        SinkUtilsTest.assertEquals((int)1, (int)result.getAttributeCount());
        result = SinkUtils.filterAttributes((AttributeSet)SinkEventAttributeSet.CENTER, (String[])SinkUtils.SINK_BASE_ATTRIBUTES);
        SinkUtilsTest.assertEquals((int)0, (int)result.getAttributeCount());
    }
}

