/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.XhtmlBaseSink;
import org.codehaus.plexus.PlexusTestCase;

public class XhtmlBaseSinkTest
extends PlexusTestCase {
    private final SinkEventAttributes attributes = new SinkEventAttributeSet(new String[]{"style", "bold"});
    private XhtmlBaseSink sink;
    private Writer writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.writer = new StringWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSpaceAfterClosingTag() throws Exception {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.paragraph();
            this.sink.text("There should be no space before the ");
            this.sink.italic();
            this.sink.text("period");
            this.sink.italic_();
            this.sink.text(".");
            this.sink.paragraph_();
        }
        finally {
            if (this.sink != null) {
                this.sink.close();
            }
        }
        String actual = this.writer.toString();
        String expected = "<p>There should be no space before the <i>period</i>.</p>";
        XhtmlBaseSinkTest.assertEquals((String)expected, (String)actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNestedTables() throws Exception {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.table();
            this.sink.tableRows(new int[]{0}, false);
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text("cell11");
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text("cell12");
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.table(SinkEventAttributeSet.LEFT);
            this.sink.tableRows(new int[]{1}, false);
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text("nestedTable1Cell11");
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text("nestedTable1Cell12");
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.table(SinkEventAttributeSet.RIGHT);
            this.sink.tableRows(new int[]{2}, false);
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text("nestedTable2Cell11");
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text("nestedTable2Cell12");
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text("nestedTable2Cell21");
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text("nestedTable2Cell22");
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.sink.tableRows_();
            this.sink.tableCaption();
            this.sink.text("caption3");
            this.sink.tableCaption_();
            this.sink.table_();
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text("nestedTable1Cell22");
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.sink.tableRows_();
            this.sink.tableCaption();
            this.sink.text("caption2");
            this.sink.tableCaption_();
            this.sink.table_();
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text("cell22");
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.sink.tableRows_();
            this.sink.tableCaption();
            this.sink.text("caption1");
            this.sink.tableCaption_();
            this.sink.table_();
        }
        finally {
            this.sink.close();
        }
        String actual = this.writer.toString();
        XhtmlBaseSinkTest.assertTrue((actual.indexOf("<table align=\"center\" border=\"0\" class=\"bodyTable\"><caption>caption1</caption>") != 1 ? 1 : 0) != 0);
        XhtmlBaseSinkTest.assertTrue((actual.indexOf("<table border=\"0\" class=\"bodyTable\" align=\"left\"><caption>caption2</caption>") != 1 ? 1 : 0) != 0);
        XhtmlBaseSinkTest.assertTrue((actual.indexOf("<table align=\"center\" border=\"0\" class=\"bodyTable\"><caption>caption3</caption>") != 1 ? 1 : 0) != 0);
        XhtmlBaseSinkTest.assertTrue((actual.indexOf("<td align=\"center\">cell11</td>") != 1 ? 1 : 0) != 0);
        XhtmlBaseSinkTest.assertTrue((actual.indexOf("<td align=\"left\">nestedTable1Cell11</td>") != 1 ? 1 : 0) != 0);
        XhtmlBaseSinkTest.assertTrue((actual.indexOf("<td align=\"right\">nestedTable2Cell11</td>") != 1 ? 1 : 0) != 0);
        XhtmlBaseSinkTest.assertTrue((actual.indexOf("<td align=\"left\">nestedTable1Cell22</td>") != 1 ? 1 : 0) != 0);
        XhtmlBaseSinkTest.assertTrue((actual.indexOf("<td align=\"center\">cell22</td>") != 1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSection() {
        boolean level = true;
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.section(1, this.attributes);
            this.sink.sectionTitle(1, this.attributes);
            this.sink.sectionTitle_(1);
            this.sink.section_(1);
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<div class=\"section\" style=\"bold\"><h2 style=\"bold\"></h2></div>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSection1() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.section1();
            this.sink.sectionTitle1();
            this.sink.sectionTitle1_();
            this.sink.section1_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<div class=\"section\"><h2></h2></div>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSection2() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.section2();
            this.sink.sectionTitle2();
            this.sink.sectionTitle2_();
            this.sink.section2_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<div class=\"section\"><h3></h3></div>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSection3() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.section3();
            this.sink.sectionTitle3();
            this.sink.sectionTitle3_();
            this.sink.section3_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<div class=\"section\"><h4></h4></div>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSection4() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.section4();
            this.sink.sectionTitle4();
            this.sink.sectionTitle4_();
            this.sink.section4_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<div class=\"section\"><h5></h5></div>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSection5() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.section5();
            this.sink.sectionTitle5();
            this.sink.sectionTitle5_();
            this.sink.section5_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<div class=\"section\"><h6></h6></div>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testList() throws Exception {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.list();
            this.sink.listItem();
            this.sink.listItem_();
            this.sink.list_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<ul><li></li></ul>", (String)this.writer.toString());
        this.writer = new StringWriter();
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.list(this.attributes);
            this.sink.listItem(this.attributes);
            this.sink.listItem_();
            this.sink.list_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<ul style=\"bold\"><li style=\"bold\"></li></ul>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNumberedList() {
        boolean numbering = false;
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.numberedList(0);
            this.sink.numberedListItem();
            this.sink.numberedListItem_();
            this.sink.numberedList_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<ol style=\"list-style-type: decimal\"><li></li></ol>", (String)this.writer.toString());
        this.writer = new StringWriter();
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.numberedList(0, this.attributes);
            this.sink.numberedListItem(this.attributes);
            this.sink.numberedListItem_();
            this.sink.numberedList_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<ol style=\"list-style-type: decimal\"><li style=\"bold\"></li></ol>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefinitionList() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.definitionList();
            this.sink.definedTerm();
            this.sink.definedTerm_();
            this.sink.definition();
            this.sink.definition_();
            this.sink.definitionList_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<dl><dt></dt><dd></dd></dl>", (String)this.writer.toString());
        this.writer = new StringWriter();
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.definitionList(this.attributes);
            this.sink.definedTerm(this.attributes);
            this.sink.definedTerm_();
            this.sink.definition(this.attributes);
            this.sink.definition_();
            this.sink.definitionList_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<dl style=\"bold\"><dt style=\"bold\"></dt><dd style=\"bold\"></dd></dl>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFigure() {
        String src = "src.jpg";
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.figure(this.attributes);
            this.sink.figureGraphics("src.jpg", this.attributes);
            this.sink.figureCaption(this.attributes);
            this.sink.figureCaption_();
            this.sink.figure_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<div style=\"bold\" class=\"figure\"><p align=\"center\"><img src=\"src.jpg\" style=\"bold\" alt=\"\" /></p><p align=\"center\" style=\"bold\"><i></i></p></div>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFigureGraphics() {
        String src = "source.png";
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.figureGraphics(src, this.attributes);
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<img src=\"source.png\" style=\"bold\" alt=\"\" />", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParagraph() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.paragraph();
            this.sink.paragraph_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<p></p>", (String)this.writer.toString());
        this.writer = new StringWriter();
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.paragraph(this.attributes);
            this.sink.paragraph_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<p style=\"bold\"></p>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVerbatim() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.verbatim(true);
            this.sink.verbatim_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<div class=\"source\"><pre></pre></div>", (String)this.writer.toString());
        this.writer = new StringWriter();
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.verbatim(this.attributes);
            this.sink.verbatim_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<div style=\"bold\"><pre style=\"bold\"></pre></div>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHorizontalRule() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.horizontalRule();
            this.sink.horizontalRule(this.attributes);
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<hr /><hr style=\"bold\" />", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTable() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.table(this.attributes);
            this.sink.table_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"</table>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableRows() {
        int[] justification = null;
        boolean grid = false;
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.tableRows(justification, false);
            this.sink.tableRows_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<table border=\"0\" class=\"bodyTable\">", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableRow() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.tableRow(this.attributes);
            this.sink.tableRow_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<tr class=\"a\" style=\"bold\"></tr>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableCell() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.tableCell(this.attributes);
            this.sink.tableCell_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<td style=\"bold\"></td>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableHeaderCell() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.tableHeaderCell(this.attributes);
            this.sink.tableHeaderCell_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<th style=\"bold\"></th>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableCaption() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.table();
            this.sink.tableRows(null, false);
            this.sink.tableCaption(this.attributes);
            this.sink.text("caption");
            this.sink.tableCaption_();
            this.sink.tableRows_();
            this.sink.table_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<table border=\"0\" class=\"bodyTable\"><caption style=\"bold\">caption</caption></table>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnchor() {
        String name = "anchor";
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.anchor(name, this.attributes);
            this.sink.anchor_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<a name=\"anchor\" style=\"bold\"></a>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLink() {
        String name = "link.html";
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.link("link.html", this.attributes);
            this.sink.link_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<a href=\"link.html\" style=\"bold\"></a>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testItalic() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.italic();
            this.sink.italic_();
            this.sink.bold();
            this.sink.bold_();
            this.sink.monospaced();
            this.sink.monospaced_();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<i></i><b></b><tt></tt>", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLineBreak() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.lineBreak(this.attributes);
            this.sink.pageBreak();
            this.sink.nonBreakingSpace();
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<br style=\"bold\" /><!-- PB -->&#160;", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testText() {
        String text = "a text & \u00c6";
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.text(text);
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"a text &amp; &#xc6;", (String)this.writer.toString());
        this.writer = new StringWriter();
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.text(text, this.attributes);
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"a text &amp; &#xc6;", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRawText() {
        String text = "raw text";
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.rawText(text);
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"raw text", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComment() {
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.comment("a comment");
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"<!-- a comment -->", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnknown() {
        String name = "unknown";
        Object[] requiredParams = null;
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.unknown("unknown", requiredParams, this.attributes);
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"", (String)this.writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttributeEntities() {
        Object[] startTag = new Object[]{new Integer(2)};
        Object[] endTag = new Object[]{new Integer(3)};
        String script = XhtmlBaseSink.SCRIPT.toString();
        SinkEventAttributeSet src = new SinkEventAttributeSet(new String[]{"src".toString(), "http://ex.com/ex.js?v=l&l=e"});
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.unknown(script, startTag, (SinkEventAttributes)src);
            this.sink.unknown(script, endTag, null);
            this.sink.figureGraphics("http://ex.com/ex.jpg?v=l&l=e", (SinkEventAttributes)src);
        }
        finally {
            this.sink.close();
        }
        String result = this.writer.toString();
        XhtmlBaseSinkTest.assertTrue((result.indexOf("ex.js?v=l&amp;l=e") != -1 ? 1 : 0) != 0);
        XhtmlBaseSinkTest.assertTrue((result.indexOf("ex.jpg?v=l&amp;l=e") != -1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntity() {
        String text = "a text '&#x1d7ed;'";
        try {
            this.sink = new XhtmlBaseSink(this.writer);
            this.sink.text(text);
        }
        finally {
            this.sink.close();
        }
        XhtmlBaseSinkTest.assertEquals((String)"a text '&#x1d7ed;'", (String)this.writer.toString());
    }
}

