/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.codehaus.plexus.PlexusTestCase;

public class DoxiaUtilsTest
extends PlexusTestCase {
    public void testIsInternalLink() {
        String link = "#anchor";
        DoxiaUtilsTest.assertTrue((String)("Should be an internal link: " + link), (boolean)DoxiaUtils.isInternalLink((String)link));
        link = "http://maven.apache.org/index.html#anchor";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be an internal link: " + link), (boolean)DoxiaUtils.isInternalLink((String)link));
        link = "./index.html";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be an internal link: " + link), (boolean)DoxiaUtils.isInternalLink((String)link));
    }

    public void testIsExternalLink() {
        String link = "http://maven.apache.org/";
        DoxiaUtilsTest.assertTrue((String)("Should be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "https://maven.apache.org/";
        DoxiaUtilsTest.assertTrue((String)("Should be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "HTTPS://MAVEN.APACHE.ORG/";
        DoxiaUtilsTest.assertTrue((String)("Should be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "ftp:/maven.apache.org/";
        DoxiaUtilsTest.assertTrue((String)("Should be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "mailto:maven@apache.org";
        DoxiaUtilsTest.assertTrue((String)("Should be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "file:/index.html";
        DoxiaUtilsTest.assertTrue((String)("Should be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "resource_type://domain:port/filepathname?query_string#anchor";
        DoxiaUtilsTest.assertTrue((String)("Should be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "index.html";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "example.pdf";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "./index.html";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "../index.html";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "file:\\index.html";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = ".\\index.html";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
        link = "..\\index.html";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be an external link: " + link), (boolean)DoxiaUtils.isExternalLink((String)link));
    }

    public void testIsLocalLink() {
        String link = "index.html";
        DoxiaUtilsTest.assertTrue((String)("Should be a local link: " + link), (boolean)DoxiaUtils.isLocalLink((String)link));
        link = "./index.html";
        DoxiaUtilsTest.assertTrue((String)("Should be a local link: " + link), (boolean)DoxiaUtils.isLocalLink((String)link));
        link = "../index.html";
        DoxiaUtilsTest.assertTrue((String)("Should be a local link: " + link), (boolean)DoxiaUtils.isLocalLink((String)link));
        link = "#anchor";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be a local link: " + link), (boolean)DoxiaUtils.isLocalLink((String)link));
        link = "http://maven.apache.org/";
        DoxiaUtilsTest.assertFalse((String)("Should NOT be a local link: " + link), (boolean)DoxiaUtils.isLocalLink((String)link));
    }

    public void testEncodeId() {
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId(null), null);
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)""), (String)"a");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)" "), (String)"a");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)" _ "), (String)"a_");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"1"), (String)"a1");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"1anchor"), (String)"a1anchor");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"_anchor"), (String)"a_anchor");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"a b-c123 "), (String)"a_b-c123");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"   anchor"), (String)"anchor");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"myAnchor"), (String)"myAnchor");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"my&Anchor"), (String)"my%26Anchor");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"H\u00e5kon"), (String)"H%c3%a5kon");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"H\u00e5kon", (boolean)true), (String)"Hkon");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"Theu\u00dfl"), (String)"Theu%c3%9fl");
        DoxiaUtilsTest.assertEquals((String)DoxiaUtils.encodeId((String)"Theu\u00dfl", (boolean)true), (String)"Theul");
    }

    public void testIsValidId() {
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId(null));
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId((String)""));
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId((String)" "));
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId((String)" _ "));
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId((String)"1"));
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId((String)"1anchor"));
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId((String)"_anchor"));
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId((String)"a b-c123 "));
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId((String)"   anchor"));
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId((String)"my&Anchor"));
        DoxiaUtilsTest.assertTrue((boolean)DoxiaUtils.isValidId((String)"myAnchor"));
        DoxiaUtilsTest.assertTrue((boolean)DoxiaUtils.isValidId((String)"a_"));
        DoxiaUtilsTest.assertTrue((boolean)DoxiaUtils.isValidId((String)"a-"));
        DoxiaUtilsTest.assertTrue((boolean)DoxiaUtils.isValidId((String)"a:"));
        DoxiaUtilsTest.assertTrue((boolean)DoxiaUtils.isValidId((String)"a."));
        DoxiaUtilsTest.assertTrue((boolean)DoxiaUtils.isValidId((String)"index.html"));
        DoxiaUtilsTest.assertFalse((boolean)DoxiaUtils.isValidId((String)"Theu\u00dfl"));
    }

    public void testParseDate() {
        int year = 1973;
        boolean month = true;
        int day = 27;
        try {
            Date feb27 = new GregorianCalendar(1973, 1, 27).getTime();
            DoxiaUtilsTest.assertEquals((Object)feb27, (Object)DoxiaUtils.parseDate((String)"27.02.1973"));
            DoxiaUtilsTest.assertEquals((Object)feb27, (Object)DoxiaUtils.parseDate((String)"27. 02. 1973"));
            DoxiaUtilsTest.assertEquals((Object)feb27, (Object)DoxiaUtils.parseDate((String)"1973-02-27"));
            DoxiaUtilsTest.assertEquals((Object)feb27, (Object)DoxiaUtils.parseDate((String)"1973/02/27"));
            DoxiaUtilsTest.assertEquals((Object)feb27, (Object)DoxiaUtils.parseDate((String)"27 Feb 1973"));
            DoxiaUtilsTest.assertEquals((Object)feb27, (Object)DoxiaUtils.parseDate((String)"27 Feb. 1973"));
            DoxiaUtilsTest.assertEquals((Object)feb27, (Object)DoxiaUtils.parseDate((String)"Feb. 27, 1973"));
            DoxiaUtilsTest.assertEquals((Object)feb27, (Object)DoxiaUtils.parseDate((String)"Feb 27, '73"));
            DoxiaUtilsTest.assertEquals((Object)feb27, (Object)DoxiaUtils.parseDate((String)"February 27, 1973"));
            DoxiaUtilsTest.assertEquals((Object)feb27, (Object)DoxiaUtils.parseDate((String)"19730227"));
            DoxiaUtilsTest.assertEquals((Object)new GregorianCalendar(1973, 0, 1).getTime(), (Object)DoxiaUtils.parseDate((String)"1973"));
            Date feb1 = new GregorianCalendar(1973, 1, 1).getTime();
            DoxiaUtilsTest.assertEquals((Object)feb1, (Object)DoxiaUtils.parseDate((String)"February 1973"));
            DoxiaUtilsTest.assertEquals((Object)feb1, (Object)DoxiaUtils.parseDate((String)"Feb. 1973"));
            DoxiaUtilsTest.assertEquals((Object)feb1, (Object)DoxiaUtils.parseDate((String)"February '73"));
            DoxiaUtilsTest.assertEquals((Object)feb1, (Object)DoxiaUtils.parseDate((String)"Feb. '73"));
            DoxiaUtilsTest.assertNotNull((Object)DoxiaUtils.parseDate((String)"Today"));
            DoxiaUtilsTest.assertNotNull((Object)DoxiaUtils.parseDate((String)"NOW"));
        }
        catch (ParseException ex) {
            DoxiaUtilsTest.fail((String)ex.getMessage());
        }
        try {
            DoxiaUtils.parseDate((String)"yesterday").getTime();
            DoxiaUtilsTest.fail();
        }
        catch (ParseException ex) {
            DoxiaUtilsTest.assertNotNull((Object)ex);
        }
    }
}

