/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.net.URLEncoder;
import java.util.Locale;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.PlexusTestCase;

public class HtmlToolsTest
extends PlexusTestCase {
    public void testEscapeHTML() {
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML(null), (String)"");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)""), (String)"");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"\t"), (String)"\t");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"\u0001"), (String)"\u0001");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"<"), (String)"&lt;");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)">"), (String)"&gt;");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"&"), (String)"&amp;");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"\""), (String)"&quot;");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"'"), (String)"&apos;");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"'", (boolean)false), (String)"'");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"&amp;"), (String)"&amp;amp;");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"\u00e4", (boolean)true), (String)"\u00e4");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"\u00e4", (boolean)false), (String)"&#xe4;");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"\u0159", (boolean)false), (String)"&#x159;");
        HtmlToolsTest.assertEquals((String)HtmlTools.escapeHTML((String)"\ud835\udfed", (boolean)false), (String)"&#x1d7ed;");
    }

    public void testUnescapeHTML() {
        HtmlToolsTest.assertNull((Object)HtmlTools.unescapeHTML(null));
        HtmlToolsTest.assertEquals((String)"", (String)HtmlTools.unescapeHTML((String)""));
        HtmlToolsTest.assertEquals((String)"\t", (String)HtmlTools.unescapeHTML((String)"\t"));
        HtmlToolsTest.assertEquals((String)"\u0001", (String)HtmlTools.unescapeHTML((String)"\u0001"));
        HtmlToolsTest.assertEquals((String)"<", (String)HtmlTools.unescapeHTML((String)"&lt;"));
        HtmlToolsTest.assertEquals((String)">", (String)HtmlTools.unescapeHTML((String)"&gt;"));
        HtmlToolsTest.assertEquals((String)"&", (String)HtmlTools.unescapeHTML((String)"&amp;"));
        HtmlToolsTest.assertEquals((String)"\"", (String)HtmlTools.unescapeHTML((String)"&quot;"));
        HtmlToolsTest.assertEquals((String)"&apos;", (String)HtmlTools.unescapeHTML((String)"&apos;"));
        HtmlToolsTest.assertEquals((String)"'", (String)HtmlTools.unescapeHTML((String)"&apos;", (boolean)true));
        HtmlToolsTest.assertEquals((String)"&amp;", (String)HtmlTools.unescapeHTML((String)"&amp;amp;"));
        HtmlToolsTest.assertEquals((String)"&lt;Fran&ccedil;ais&gt;", (String)HtmlTools.unescapeHTML((String)"&amp;lt;Fran&amp;ccedil;ais&amp;gt;"));
        HtmlToolsTest.assertEquals((String)"\u0159", (String)HtmlTools.unescapeHTML((String)"&#x159;"));
        HtmlToolsTest.assertEquals((String)"\ud808\udf45", (String)HtmlTools.unescapeHTML((String)"&#x12345;"));
        HtmlToolsTest.assertEquals((String)"\ud835\udfed", (String)HtmlTools.unescapeHTML((String)"&#x1d7ed;"));
        HtmlToolsTest.assertEquals((String)"\ud808\udf45\ud835\udfed", (String)HtmlTools.unescapeHTML((String)"&#x12345;&#x1d7ed;"));
        HtmlToolsTest.assertEquals((String)"&#x1d7ed &#x1d7ed", (String)HtmlTools.unescapeHTML((String)"&#x1d7ed &#x1d7ed"));
        HtmlToolsTest.assertEquals((String)"&#x1d7ed \ud835\udfed", (String)HtmlTools.unescapeHTML((String)"&#x1d7ed &#x1d7ed;"));
        HtmlToolsTest.assertEquals((String)"&#xQWER;", (String)HtmlTools.unescapeHTML((String)"&#xQWER;"));
        HtmlToolsTest.assertEquals((String)"\u00e5", (String)HtmlTools.unescapeHTML((String)"&#229;"));
        HtmlToolsTest.assertEquals((String)"<>&\"\u00e5\u0159\ud835\udfed", (String)HtmlTools.unescapeHTML((String)"&lt;&gt;&amp;&quot;&#229;&#x159;&#x1d7ed;"));
    }

    public void testEncodeId() {
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId(null), null);
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)""), (String)"a");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)" "), (String)"a");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)" _ "), (String)"a_");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)"1"), (String)"a1");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)"1anchor"), (String)"a1anchor");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)"_anchor"), (String)"a_anchor");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)"a b-c123 "), (String)"a_b-c123");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)"   anchor"), (String)"anchor");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)"myAnchor"), (String)"myAnchor");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)"H\u00e5kon"), (String)"Hkon");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeId((String)"Theu\u00dfl"), (String)"Theul");
    }

    public void testEncodeURL() throws Exception {
        HtmlToolsTest.assertNull((Object)HtmlTools.encodeURL(null));
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeURL((String)""), (String)"");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeURL((String)"http://www.example.com/?This is a simple test."), (String)"http://www.example.com/?This%20is%20a%20simple%20test.");
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeURL((String)"http://www.example.com/?This is a simple & short test."), (String)"http://www.example.com/?This%20is%20a%20simple%20&%20short%20test.");
        String url = "\ud808\udf45";
        HtmlToolsTest.assertEquals((String)HtmlTools.encodeURL((String)url), (String)URLEncoder.encode(url, "UTF-8").toLowerCase(Locale.ENGLISH));
    }

    public void testIsId() {
        HtmlToolsTest.assertFalse((boolean)HtmlTools.isId(null));
        HtmlToolsTest.assertFalse((boolean)HtmlTools.isId((String)""));
        HtmlToolsTest.assertFalse((boolean)HtmlTools.isId((String)" "));
        HtmlToolsTest.assertFalse((boolean)HtmlTools.isId((String)" _ "));
        HtmlToolsTest.assertFalse((boolean)HtmlTools.isId((String)"1"));
        HtmlToolsTest.assertFalse((boolean)HtmlTools.isId((String)"1anchor"));
        HtmlToolsTest.assertFalse((boolean)HtmlTools.isId((String)"_anchor"));
        HtmlToolsTest.assertFalse((boolean)HtmlTools.isId((String)"a b-c123 "));
        HtmlToolsTest.assertFalse((boolean)HtmlTools.isId((String)"   anchor"));
        HtmlToolsTest.assertTrue((boolean)HtmlTools.isId((String)"myAnchor"));
        HtmlToolsTest.assertTrue((boolean)HtmlTools.isId((String)"a_"));
        HtmlToolsTest.assertTrue((boolean)HtmlTools.isId((String)"a-"));
        HtmlToolsTest.assertTrue((boolean)HtmlTools.isId((String)"a:"));
        HtmlToolsTest.assertTrue((boolean)HtmlTools.isId((String)"a."));
        HtmlToolsTest.assertFalse((boolean)HtmlTools.isId((String)"Theu\u00dfl"));
    }

    public void testGetHtmlTag() {
        HtmlToolsTest.assertNull((Object)HtmlTools.getHtmlTag((String)""));
        HtmlToolsTest.assertNull((Object)HtmlTools.getHtmlTag((String)"weirdHtmlTag"));
        HtmlToolsTest.assertNotNull((Object)HtmlTools.getHtmlTag((String)"strong"));
    }
}

