/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.xsd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.AssertionFailedError;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.xml.XmlUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractXmlValidatorTest
extends PlexusTestCase {
    protected static final String EOL = System.getProperty("line.separator");
    private static final Map CACHE_DOXIA_TEST_DOCUMENTS = new Hashtable();
    private static final String MAVEN_RESOURCE_PATH = "META-INF/maven/org.apache.maven.doxia/doxia-test-docs/";
    private XMLReader xmlReader;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.xmlReader = null;
    }

    public void testValidateFiles() throws Exception {
        Iterator it = this.getTestDocuments().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug("Validate '" + entry.getKey() + "'");
            }
            List errors = this.parseXML(entry.getValue().toString());
            Iterator it2 = errors.iterator();
            while (it2.hasNext()) {
                ErrorMessage error = (ErrorMessage)it2.next();
                if (this.isFailErrorMessage(error.getMessage())) {
                    AbstractXmlValidatorTest.fail((String)(entry.getKey() + EOL + error.toString()));
                    continue;
                }
                if (!this.getContainer().getLogger().isDebugEnabled()) continue;
                this.getContainer().getLogger().debug(entry.getKey() + EOL + error.toString());
            }
        }
    }

    protected abstract String[] getIncludes();

    protected abstract String addNamespaces(String var1);

    protected Map getTestDocuments() throws IOException {
        if (this.getIncludes() == null) {
            return Collections.EMPTY_MAP;
        }
        Map testDocs = AbstractXmlValidatorTest.getAllTestDocuments();
        Hashtable ret = new Hashtable();
        ret.putAll(testDocs);
        Iterator it = testDocs.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            for (int i = 0; i < this.getIncludes().length; ++i) {
                if (SelectorUtils.matchPath((String)this.getIncludes()[i], (String)key.toLowerCase(Locale.ENGLISH))) continue;
                ret.remove(key);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map getAllTestDocuments() throws IOException {
        if (CACHE_DOXIA_TEST_DOCUMENTS != null && !CACHE_DOXIA_TEST_DOCUMENTS.isEmpty()) {
            return CACHE_DOXIA_TEST_DOCUMENTS;
        }
        URL testJar = AbstractXmlValidatorTest.class.getClassLoader().getResource(MAVEN_RESOURCE_PATH);
        if (testJar == null && (testJar = AbstractXmlValidatorTest.class.getClassLoader().getResource("doxia-site")) == null) {
            throw new RuntimeException("Could not find the Doxia test documents artefact i.e. doxia-test-docs-XXX.jar");
        }
        if (testJar.toString().startsWith("jar")) {
            JarURLConnection conn = (JarURLConnection)testJar.openConnection();
            JarFile jarFile = conn.getJarFile();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.getName().startsWith("META-INF") || entry.isDirectory()) continue;
                InputStream in = null;
                try {
                    in = (class$org$apache$maven$doxia$xsd$AbstractXmlValidatorTest == null ? AbstractXmlValidatorTest.class$("org.apache.maven.doxia.xsd.AbstractXmlValidatorTest") : class$org$apache$maven$doxia$xsd$AbstractXmlValidatorTest).getClassLoader().getResource(entry.getName()).openStream();
                    String content = IOUtil.toString((InputStream)in, (String)"UTF-8");
                    CACHE_DOXIA_TEST_DOCUMENTS.put("jar:" + conn.getJarFileURL() + "!/" + entry.getName(), content);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close((InputStream)in);
            }
        } else {
            File testDocsDir = new File(testJar.getFile()).getParentFile();
            List files = FileUtils.getFiles((File)testDocsDir, (String)"**/*.*", (String)FileUtils.getDefaultExcludesAsString(), (boolean)true);
            Iterator it = files.iterator();
            while (it.hasNext()) {
                File file = new File(it.next().toString());
                if (file.getAbsolutePath().indexOf("META-INF") != -1) continue;
                Object reader = null;
                reader = XmlUtil.isXml((File)file) ? ReaderFactory.newXmlReader((File)file) : ReaderFactory.newReader((File)file, (String)"UTF-8");
                String content = IOUtil.toString((Reader)reader);
                CACHE_DOXIA_TEST_DOCUMENTS.put(file.toURI().toString(), content);
            }
        }
        return CACHE_DOXIA_TEST_DOCUMENTS;
    }

    protected boolean isFailErrorMessage(String message) {
        return message.indexOf("schema_reference.4: Failed to read schema document 'http://www.w3.org/2001/xml.xsd'") == -1 && message.indexOf("cvc-complex-type.4: Attribute 'alt' must appear on element 'img'.") == -1 && message.indexOf("cvc-complex-type.2.4.a: Invalid content starting with element") == -1 && message.indexOf("cvc-complex-type.2.4.a: Invalid content was found starting with element") == -1 && message.indexOf("cvc-datatype-valid.1.2.1:") == -1 && message.indexOf("cvc-attribute.3:") == -1;
    }

    private XMLReader getXMLReader() {
        if (this.xmlReader == null) {
            try {
                this.xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.xmlReader.setErrorHandler(new MessagesErrorHandler());
                this.xmlReader.setEntityResolver((EntityResolver)new AbstractXmlParser.CachedFileEntityResolver());
            }
            catch (SAXNotRecognizedException e) {
                throw new AssertionFailedError("SAXNotRecognizedException: " + e.getMessage());
            }
            catch (SAXNotSupportedException e) {
                throw new AssertionFailedError("SAXNotSupportedException: " + e.getMessage());
            }
            catch (SAXException e) {
                throw new AssertionFailedError("SAXException: " + e.getMessage());
            }
        }
        ((MessagesErrorHandler)this.xmlReader.getErrorHandler()).clearMessages();
        return this.xmlReader;
    }

    private List parseXML(String xmlContent) throws IOException, SAXException {
        xmlContent = this.addNamespaces(xmlContent);
        MessagesErrorHandler errorHandler = (MessagesErrorHandler)this.getXMLReader().getErrorHandler();
        this.getXMLReader().parse(new InputSource(new StringReader(xmlContent)));
        return errorHandler.getMessages();
    }

    private static class MessagesErrorHandler
    extends DefaultHandler {
        private final List messages = new ArrayList();

        public void warning(SAXParseException e) throws SAXException {
            this.addMessage("Warning", e);
        }

        public void error(SAXParseException e) throws SAXException {
            this.addMessage("Error", e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.addMessage("Fatal error", e);
        }

        private void addMessage(String pre, SAXParseException e) {
            ErrorMessage error = new ErrorMessage(pre, e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e.getMessage());
            this.messages.add(error);
        }

        protected List getMessages() {
            return this.messages;
        }

        protected void clearMessages() {
            this.messages.clear();
        }
    }

    private static class ErrorMessage
    extends DefaultHandler {
        private final String level;
        private final String publicID;
        private final String systemID;
        private final int lineNumber;
        private final int columnNumber;
        private final String message;

        public ErrorMessage(String level, String publicID, String systemID, int lineNumber, int columnNumber, String message) {
            this.level = level;
            this.publicID = publicID;
            this.systemID = systemID;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
            this.message = message;
        }

        protected String getLevel() {
            return this.level;
        }

        protected String getPublicID() {
            return this.publicID;
        }

        protected String getSystemID() {
            return this.systemID;
        }

        protected int getLineNumber() {
            return this.lineNumber;
        }

        protected int getColumnNumber() {
            return this.columnNumber;
        }

        protected String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.level).append(EOL);
            sb.append("  Public ID: ").append(this.publicID).append(EOL);
            sb.append("  System ID: ").append(this.systemID).append(EOL);
            sb.append("  Line number: ").append(this.lineNumber).append(EOL);
            sb.append("  Column number: ").append(this.columnNumber).append(EOL);
            sb.append("  Message: ").append(this.message).append(EOL);
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.columnNumber;
            result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
            result = 31 * result + this.lineNumber;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.publicID == null ? 0 : this.publicID.hashCode());
            result = 31 * result + (this.systemID == null ? 0 : this.systemID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ErrorMessage other = (ErrorMessage)obj;
            if (this.columnNumber != other.columnNumber) {
                return false;
            }
            if (this.level == null ? other.level != null : !this.level.equals(other.level)) {
                return false;
            }
            if (this.lineNumber != other.lineNumber) {
                return false;
            }
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            if (this.publicID == null ? other.publicID != null : !this.publicID.equals(other.publicID)) {
                return false;
            }
            return !(this.systemID == null ? other.systemID != null : !this.systemID.equals(other.systemID));
        }
    }
}

