/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class XhtmlBaseParser
extends AbstractXmlParser {
    private boolean isLink;
    private boolean isAnchor;
    private int orderedListDepth = 0;
    private int sectionLevel;
    private int verbatimLevel;
    private boolean inFigure;
    private final SinkEventAttributeSet decoration = new SinkEventAttributeSet();

    protected boolean baseStartTag(XmlPullParser parser, Sink sink) {
        boolean visited = true;
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        if (this.isVerbatim()) {
            this.handleVerbatim(parser, sink);
        } else if (parser.getName().equals(HTML.Tag.H2.toString())) {
            this.handleSectionStart(sink, 1, attribs);
        } else if (parser.getName().equals(HTML.Tag.H3.toString())) {
            this.handleSectionStart(sink, 2, attribs);
        } else if (parser.getName().equals(HTML.Tag.H4.toString())) {
            this.handleSectionStart(sink, 3, attribs);
        } else if (parser.getName().equals(HTML.Tag.H5.toString())) {
            this.handleSectionStart(sink, 4, attribs);
        } else if (parser.getName().equals(HTML.Tag.H6.toString())) {
            this.handleSectionStart(sink, 5, attribs);
        } else if (parser.getName().equals(HTML.Tag.U.toString())) {
            this.decoration.addAttribute("decoration", "underline");
        } else if (parser.getName().equals(HTML.Tag.S.toString()) || parser.getName().equals(HTML.Tag.STRIKE.toString()) || parser.getName().equals("del")) {
            this.decoration.addAttribute("decoration", "line-through");
        } else if (parser.getName().equals(HTML.Tag.SUB.toString())) {
            this.decoration.addAttribute("valign", "sub");
        } else if (parser.getName().equals(HTML.Tag.SUP.toString())) {
            this.decoration.addAttribute("valign", "sup");
        } else if (parser.getName().equals(HTML.Tag.P.toString())) {
            this.handlePStart(sink, attribs);
        } else if (parser.getName().equals(HTML.Tag.DIV.toString())) {
            visited = this.handleDivStart(parser, attribs, sink);
        } else if (parser.getName().equals(HTML.Tag.PRE.toString())) {
            this.handlePreStart(attribs, sink);
        } else if (parser.getName().equals(HTML.Tag.UL.toString())) {
            sink.list((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HTML.Tag.OL.toString())) {
            this.handleOLStart(parser, sink, attribs);
        } else if (parser.getName().equals(HTML.Tag.LI.toString())) {
            this.handleLIStart(sink, attribs);
        } else if (parser.getName().equals(HTML.Tag.DL.toString())) {
            sink.definitionList((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HTML.Tag.DT.toString())) {
            sink.definitionListItem((SinkEventAttributes)attribs);
            sink.definedTerm((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HTML.Tag.DD.toString())) {
            sink.definition((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HTML.Tag.B.toString()) || parser.getName().equals(HTML.Tag.STRONG.toString())) {
            sink.bold();
        } else if (parser.getName().equals(HTML.Tag.I.toString()) || parser.getName().equals(HTML.Tag.EM.toString())) {
            this.handleFigureCaptionStart(sink, attribs);
        } else if (parser.getName().equals(HTML.Tag.CODE.toString()) || parser.getName().equals(HTML.Tag.SAMP.toString()) || parser.getName().equals(HTML.Tag.TT.toString())) {
            sink.monospaced();
        } else if (parser.getName().equals(HTML.Tag.A.toString())) {
            this.handleAStart(parser, sink, attribs);
        } else if (parser.getName().equals(HTML.Tag.TABLE.toString())) {
            this.handleTableStart(sink, attribs, parser);
        } else if (parser.getName().equals(HTML.Tag.TR.toString())) {
            sink.tableRow((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HTML.Tag.TH.toString())) {
            sink.tableHeaderCell((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HTML.Tag.TD.toString())) {
            sink.tableCell((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HTML.Tag.CAPTION.toString())) {
            sink.tableCaption((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HTML.Tag.BR.toString())) {
            sink.lineBreak((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HTML.Tag.HR.toString())) {
            sink.horizontalRule((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(HTML.Tag.IMG.toString())) {
            this.handleImgStart(parser, sink, attribs);
        } else {
            visited = false;
        }
        return visited;
    }

    protected boolean baseEndTag(XmlPullParser parser, Sink sink) {
        boolean visited = true;
        if (this.isVerbatim()) {
            this.handleVerbatimEnd(parser, sink);
        } else if (parser.getName().equals(HTML.Tag.P.toString())) {
            if (!this.inFigure) {
                sink.paragraph_();
            }
        } else if (parser.getName().equals(HTML.Tag.U.toString()) || parser.getName().equals(HTML.Tag.S.toString()) || parser.getName().equals(HTML.Tag.STRIKE.toString()) || parser.getName().equals("del")) {
            this.decoration.removeAttribute("decoration");
        } else if (parser.getName().equals(HTML.Tag.SUB.toString()) || parser.getName().equals(HTML.Tag.SUP.toString())) {
            this.decoration.removeAttribute("valign");
        } else if (parser.getName().equals(HTML.Tag.DIV.toString())) {
            if (this.inFigure) {
                sink.figure_();
                this.inFigure = false;
            }
        } else if (parser.getName().equals(HTML.Tag.PRE.toString())) {
            this.verbatim_();
            sink.verbatim_();
        } else if (parser.getName().equals(HTML.Tag.UL.toString())) {
            sink.list_();
        } else if (parser.getName().equals(HTML.Tag.OL.toString())) {
            sink.numberedList_();
            --this.orderedListDepth;
        } else if (parser.getName().equals(HTML.Tag.LI.toString())) {
            this.handleListItemEnd(sink);
        } else if (parser.getName().equals(HTML.Tag.DL.toString())) {
            sink.definitionList_();
        } else if (parser.getName().equals(HTML.Tag.DT.toString())) {
            sink.definedTerm_();
        } else if (parser.getName().equals(HTML.Tag.DD.toString())) {
            sink.definition_();
            sink.definitionListItem_();
        } else if (parser.getName().equals(HTML.Tag.B.toString()) || parser.getName().equals(HTML.Tag.STRONG.toString())) {
            sink.bold_();
        } else if (parser.getName().equals(HTML.Tag.I.toString()) || parser.getName().equals(HTML.Tag.EM.toString())) {
            this.handleFigureCaptionEnd(sink);
        } else if (parser.getName().equals(HTML.Tag.CODE.toString()) || parser.getName().equals(HTML.Tag.SAMP.toString()) || parser.getName().equals(HTML.Tag.TT.toString())) {
            sink.monospaced_();
        } else if (parser.getName().equals(HTML.Tag.A.toString())) {
            this.handleAEnd(sink);
        } else if (parser.getName().equals(HTML.Tag.TABLE.toString())) {
            sink.tableRows_();
            sink.table_();
        } else if (parser.getName().equals(HTML.Tag.TR.toString())) {
            sink.tableRow_();
        } else if (parser.getName().equals(HTML.Tag.TH.toString())) {
            sink.tableHeaderCell_();
        } else if (parser.getName().equals(HTML.Tag.TD.toString())) {
            sink.tableCell_();
        } else if (parser.getName().equals(HTML.Tag.CAPTION.toString())) {
            sink.tableCaption_();
        } else if (parser.getName().equals(HTML.Tag.H2.toString())) {
            sink.sectionTitle1_();
        } else if (parser.getName().equals(HTML.Tag.H3.toString())) {
            sink.sectionTitle2_();
        } else if (parser.getName().equals(HTML.Tag.H4.toString())) {
            sink.sectionTitle3_();
        } else if (parser.getName().equals(HTML.Tag.H5.toString())) {
            sink.sectionTitle4_();
        } else if (parser.getName().equals(HTML.Tag.H6.toString())) {
            sink.sectionTitle5_();
        } else {
            visited = false;
        }
        return visited;
    }

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!this.baseStartTag(parser, sink) && this.getLog().isWarnEnabled()) {
            String position = "[" + parser.getLineNumber() + ":" + parser.getColumnNumber() + "]";
            String tag = "<" + parser.getName() + ">";
            this.getLog().warn((CharSequence)("Unrecognized xml tag: " + tag + " at " + position));
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!this.baseEndTag(parser, sink)) {
            // empty if block
        }
    }

    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (StringUtils.isNotEmpty((String)text)) {
            sink.text(text, (SinkEventAttributes)this.decoration);
        }
    }

    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        sink.text(this.getText(parser));
    }

    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if ("PB".equals(text.trim())) {
            sink.pageBreak();
        } else {
            sink.comment(text.trim());
        }
    }

    protected void handleEntity(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        int[] holder = new int[]{0, 0};
        char[] chars = parser.getTextCharacters(holder);
        String textChars = String.valueOf(chars, holder[0], holder[1]);
        if ("#160".equals(textChars) || "nbsp".equals(textChars)) {
            sink.nonBreakingSpace();
        } else if (this.getLocalEntities().containsKey(textChars)) {
            sink.rawText(text);
        } else {
            sink.text(text);
        }
    }

    protected void handleUnknown(XmlPullParser parser, Sink sink, int type) {
        Object[] required = new Object[]{new Integer(type)};
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        sink.unknown(parser.getName(), required, (SinkEventAttributes)attribs);
    }

    protected void consecutiveSections(int newLevel, Sink sink) {
        this.closeOpenSections(newLevel, sink);
        this.openMissingSections(newLevel, sink);
        this.sectionLevel = newLevel;
    }

    private void closeOpenSections(int newLevel, Sink sink) {
        while (this.sectionLevel >= newLevel) {
            if (this.sectionLevel == 5) {
                sink.section5_();
            } else if (this.sectionLevel == 4) {
                sink.section4_();
            } else if (this.sectionLevel == 3) {
                sink.section3_();
            } else if (this.sectionLevel == 2) {
                sink.section2_();
            } else if (this.sectionLevel == 1) {
                sink.section1_();
            }
            --this.sectionLevel;
        }
    }

    private void openMissingSections(int newLevel, Sink sink) {
        while (this.sectionLevel < newLevel - 1) {
            ++this.sectionLevel;
            if (this.sectionLevel == 5) {
                sink.section5();
                continue;
            }
            if (this.sectionLevel == 4) {
                sink.section4();
                continue;
            }
            if (this.sectionLevel == 3) {
                sink.section3();
                continue;
            }
            if (this.sectionLevel == 2) {
                sink.section2();
                continue;
            }
            if (this.sectionLevel != 1) continue;
            sink.section1();
        }
    }

    protected int getSectionLevel() {
        return this.sectionLevel;
    }

    protected void setSectionLevel(int newLevel) {
        this.sectionLevel = newLevel;
    }

    protected void verbatim_() {
        --this.verbatimLevel;
    }

    protected void verbatim() {
        ++this.verbatimLevel;
    }

    protected boolean isVerbatim() {
        return this.verbatimLevel != 0;
    }

    protected String validAnchor(String id) {
        if (!DoxiaUtils.isValidId(id)) {
            this.getLog().warn((CharSequence)("Modified invalid anchor name: " + id));
            return DoxiaUtils.encodeId(id);
        }
        return id;
    }

    private void handleAEnd(Sink sink) {
        if (this.isLink) {
            sink.link_();
            this.isLink = false;
        } else if (this.isAnchor) {
            sink.anchor_();
            this.isAnchor = false;
        }
    }

    private void handleAStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        String href = parser.getAttributeValue(null, HTML.Attribute.HREF.toString());
        if (href != null) {
            sink.link(href, (SinkEventAttributes)attribs);
            this.isLink = true;
        } else {
            String name = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
            if (name != null) {
                sink.anchor(this.validAnchor(name), (SinkEventAttributes)attribs);
                this.isAnchor = true;
            } else {
                String id = parser.getAttributeValue(null, HTML.Attribute.ID.toString());
                if (id != null) {
                    sink.anchor(this.validAnchor(id), (SinkEventAttributes)attribs);
                    this.isAnchor = true;
                }
            }
        }
    }

    private boolean handleDivStart(XmlPullParser parser, SinkEventAttributeSet attribs, Sink sink) {
        boolean visited = true;
        String divclass = parser.getAttributeValue(null, HTML.Attribute.CLASS.toString());
        if ("figure".equals(divclass)) {
            this.inFigure = true;
            SinkEventAttributeSet atts = new SinkEventAttributeSet((AttributeSet)((Object)attribs));
            atts.removeAttribute("class");
            sink.figure((SinkEventAttributes)atts);
        } else {
            visited = false;
        }
        return visited;
    }

    private void handleFigureCaptionEnd(Sink sink) {
        if (this.inFigure) {
            sink.figureCaption_();
        } else {
            sink.italic_();
        }
    }

    private void handleFigureCaptionStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.inFigure) {
            sink.figureCaption((SinkEventAttributes)attribs);
        } else {
            sink.italic();
        }
    }

    private void handleImgStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        String src = parser.getAttributeValue(null, HTML.Attribute.SRC.toString());
        if (src != null) {
            sink.figureGraphics(src, (SinkEventAttributes)attribs);
        }
    }

    private void handleLIStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.orderedListDepth == 0) {
            sink.listItem((SinkEventAttributes)attribs);
        } else {
            sink.numberedListItem((SinkEventAttributes)attribs);
        }
    }

    private void handleListItemEnd(Sink sink) {
        if (this.orderedListDepth == 0) {
            sink.listItem_();
        } else {
            sink.numberedListItem_();
        }
    }

    private void handleOLStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        int numbering = 0;
        String style = parser.getAttributeValue(null, HTML.Attribute.STYLE.toString());
        if (style != null) {
            if ("list-style-type: upper-alpha".equals(style)) {
                numbering = 2;
            } else if ("list-style-type: lower-alpha".equals(style)) {
                numbering = 1;
            } else if ("list-style-type: upper-roman".equals(style)) {
                numbering = 4;
            } else if ("list-style-type: lower-roman".equals(style)) {
                numbering = 3;
            } else if ("list-style-type: decimal".equals(style)) {
                numbering = 0;
            }
        }
        sink.numberedList(numbering, (SinkEventAttributes)attribs);
        ++this.orderedListDepth;
    }

    private void handlePStart(Sink sink, SinkEventAttributeSet attribs) {
        if (!this.inFigure) {
            sink.paragraph((SinkEventAttributes)attribs);
        }
    }

    private void handlePreStart(SinkEventAttributeSet attribs, Sink sink) {
        this.verbatim();
        attribs.removeAttribute("decoration");
        sink.verbatim((SinkEventAttributes)attribs);
    }

    private void handleSectionStart(Sink sink, int sectionLevel, SinkEventAttributeSet attribs) {
        this.consecutiveSections(sectionLevel, sink);
        sink.section(sectionLevel, (SinkEventAttributes)attribs);
        sink.sectionTitle(sectionLevel, (SinkEventAttributes)attribs);
    }

    private void handleTableStart(Sink sink, SinkEventAttributeSet attribs, XmlPullParser parser) {
        sink.table((SinkEventAttributes)attribs);
        String border = parser.getAttributeValue(null, HTML.Attribute.BORDER.toString());
        boolean grid = true;
        if ("0".equals(border)) {
            grid = false;
        }
        String align = parser.getAttributeValue(null, HTML.Attribute.ALIGN.toString());
        int[] justif = new int[]{1};
        if ("center".equals(align)) {
            justif[0] = 0;
        } else if ("right".equals(align)) {
            justif[0] = 2;
        }
        sink.tableRows(justif, grid);
    }

    private void handleVerbatim(XmlPullParser parser, Sink sink) {
        if (parser.getName().equals(HTML.Tag.PRE.toString())) {
            this.verbatim();
        }
        sink.text(this.getText(parser));
    }

    private void handleVerbatimEnd(XmlPullParser parser, Sink sink) {
        if (parser.getName().equals(HTML.Tag.PRE.toString())) {
            this.verbatim_();
            if (this.isVerbatim()) {
                sink.text(this.getText(parser));
            } else {
                sink.verbatim_();
            }
        } else {
            sink.text(this.getText(parser));
        }
    }
}

