/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class DoxiaUtils {
    public static boolean isInternalLink(String link) {
        return link.startsWith("#");
    }

    public static boolean isExternalLink(String link) {
        String text = link.toLowerCase(Locale.ENGLISH);
        return text.indexOf("http:/") == 0 || text.indexOf("https:/") == 0 || text.indexOf("ftp:/") == 0 || text.indexOf("mailto:") == 0 || text.indexOf("file:/") == 0 || text.indexOf("://") != -1;
    }

    public static boolean isLocalLink(String link) {
        return !DoxiaUtils.isExternalLink(link) && !DoxiaUtils.isInternalLink(link);
    }

    public static String encodeId(String id) {
        if (id == null) {
            return null;
        }
        id = id.trim();
        int length = id.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            byte[] bytes;
            char c = id.charAt(i);
            if (i == 0 && !DoxiaUtils.isAciiLetter(c)) {
                buffer.append("a");
            }
            if (c == ' ') {
                buffer.append("_");
                continue;
            }
            if (DoxiaUtils.isAciiLetter(c) || DoxiaUtils.isAciiDigit(c) || c == '-' || c == '_' || c == ':' || c == '.') {
                buffer.append(c);
                continue;
            }
            char[] unicode = new char[1];
            try {
                unicode[0] = c;
                bytes = new String(unicode, 0, 1).getBytes("UTF8");
            }
            catch (UnsupportedEncodingException cannotHappen) {
                bytes = new byte[]{};
            }
            for (int j = 0; j < bytes.length; ++j) {
                String hex = Integer.toHexString(bytes[j] & 0xFF);
                buffer.append('%');
                if (hex.length() == 1) {
                    buffer.append('0');
                }
                buffer.append(hex);
            }
        }
        return buffer.toString();
    }

    public static boolean isValidId(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i == 0 && !DoxiaUtils.isAciiLetter(c)) {
                return false;
            }
            if (c == ' ') {
                return false;
            }
            if (DoxiaUtils.isAciiLetter(c) || DoxiaUtils.isAciiDigit(c) || c == '-' || c == '_' || c == ':' || c == '.') continue;
            return false;
        }
        return true;
    }

    private static boolean isAciiLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isAciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private DoxiaUtils() {
    }
}

