/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.markup.HtmlMarkup;

public class HtmlTools {
    private static final HTML.Tag[] ALL_TAGS = new HTML.Tag[]{HtmlMarkup.A, HtmlMarkup.ABBR, HtmlMarkup.ACRONYM, HtmlMarkup.ADDRESS, HtmlMarkup.APPLET, HtmlMarkup.AREA, HtmlMarkup.B, HtmlMarkup.BASE, HtmlMarkup.BASEFONT, HtmlMarkup.BDO, HtmlMarkup.BIG, HtmlMarkup.BLOCKQUOTE, HtmlMarkup.BODY, HtmlMarkup.BR, HtmlMarkup.BUTTON, HtmlMarkup.CAPTION, HtmlMarkup.CENTER, HtmlMarkup.CITE, HtmlMarkup.CODE, HtmlMarkup.COL, HtmlMarkup.COLGROUP, HtmlMarkup.DD, HtmlMarkup.DEL, HtmlMarkup.DFN, HtmlMarkup.DIR, HtmlMarkup.DIV, HtmlMarkup.DL, HtmlMarkup.DT, HtmlMarkup.EM, HtmlMarkup.FIELDSET, HtmlMarkup.FONT, HtmlMarkup.FORM, HtmlMarkup.FRAME, HtmlMarkup.FRAMESET, HtmlMarkup.H1, HtmlMarkup.H2, HtmlMarkup.H3, HtmlMarkup.H4, HtmlMarkup.H5, HtmlMarkup.H6, HtmlMarkup.HEAD, HtmlMarkup.HR, HtmlMarkup.HTML, HtmlMarkup.I, HtmlMarkup.IFRAME, HtmlMarkup.IMG, HtmlMarkup.INPUT, HtmlMarkup.INS, HtmlMarkup.ISINDEX, HtmlMarkup.KBD, HtmlMarkup.LABEL, HtmlMarkup.LEGEND, HtmlMarkup.LI, HtmlMarkup.LINK, HtmlMarkup.MAP, HtmlMarkup.MENU, HtmlMarkup.META, HtmlMarkup.NOFRAMES, HtmlMarkup.NOSCRIPT, HtmlMarkup.OBJECT, HtmlMarkup.OL, HtmlMarkup.OPTGROUP, HtmlMarkup.OPTION, HtmlMarkup.P, HtmlMarkup.PARAM, HtmlMarkup.PRE, HtmlMarkup.Q, HtmlMarkup.S, HtmlMarkup.SAMP, HtmlMarkup.SCRIPT, HtmlMarkup.SELECT, HtmlMarkup.SMALL, HtmlMarkup.SPAN, HtmlMarkup.STRIKE, HtmlMarkup.STRONG, HtmlMarkup.STYLE, HtmlMarkup.SUB, HtmlMarkup.SUP, HtmlMarkup.TABLE, HtmlMarkup.TBODY, HtmlMarkup.TD, HtmlMarkup.TEXTAREA, HtmlMarkup.TFOOT, HtmlMarkup.TH, HtmlMarkup.THEAD, HtmlMarkup.TITLE, HtmlMarkup.TR, HtmlMarkup.TT, HtmlMarkup.U, HtmlMarkup.UL, HtmlMarkup.VAR};
    private static final Hashtable TAG_HASHTABLE = new Hashtable(ALL_TAGS.length);

    public static HTML.Tag getHtmlTag(String tagName) {
        Object t = TAG_HASHTABLE.get(tagName);
        return t == null ? null : (HTML.Tag)t;
    }

    public static String escapeHTML(String text) {
        return HtmlTools.escapeHTML(text, true);
    }

    public static final String escapeHTML(String text, boolean xmlMode) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block6: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    if (xmlMode) {
                        buffer.append(c);
                        continue block6;
                    }
                    if (c <= '~') {
                        buffer.append(c);
                        continue block6;
                    }
                    buffer.append("&#");
                    buffer.append((int)c);
                    buffer.append(';');
                }
            }
        }
        return buffer.toString();
    }

    public static String encodeURL(String url) {
        if (url == null) {
            return null;
        }
        StringBuffer encoded = new StringBuffer();
        int length = url.length();
        char[] unicode = new char[1];
        block5: for (int i = 0; i < length; ++i) {
            char c = url.charAt(i);
            switch (c) {
                case '!': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '_': 
                case '~': {
                    encoded.append(c);
                    continue block5;
                }
                default: {
                    byte[] bytes;
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        encoded.append(c);
                        continue block5;
                    }
                    try {
                        unicode[0] = c;
                        bytes = new String(unicode, 0, 1).getBytes("UTF8");
                    }
                    catch (UnsupportedEncodingException cannotHappen) {
                        bytes = new byte[]{};
                    }
                    for (int j = 0; j < bytes.length; ++j) {
                        String hex = Integer.toHexString(bytes[j] & 0xFF);
                        encoded.append('%');
                        if (hex.length() == 1) {
                            encoded.append('0');
                        }
                        encoded.append(hex);
                    }
                }
            }
        }
        return encoded.toString();
    }

    public static String encodeId(String id) {
        if (id == null) {
            return null;
        }
        id = id.trim();
        int length = id.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (i == 0 && !Character.isLetter(c)) {
                buffer.append("a");
            }
            if (c == ' ') {
                buffer.append("_");
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != ':' && c != '.') continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static boolean isId(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i == 0 && !Character.isLetter(c)) {
                return false;
            }
            if (c == ' ') {
                return false;
            }
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == ':' || c == '.') continue;
            return false;
        }
        return true;
    }

    private HtmlTools() {
    }

    static {
        for (int i = 0; i < ALL_TAGS.length; ++i) {
            TAG_HASHTABLE.put(ALL_TAGS[i].toString(), ALL_TAGS[i]);
        }
    }
}

