/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.macro;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.maven.doxia.macro.EchoMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventElement;
import org.apache.maven.doxia.sink.SinkEventTestingSink;

public class EchoMacroTest
extends TestCase {
    public void testExecute() {
        HashMap<String, String> macroParameters = new HashMap<String, String>();
        macroParameters.put("paramName", "paramValue");
        macroParameters.put("parser", "parserValue");
        macroParameters.put("sourceContent", "sourceContentValue");
        SinkEventTestingSink sink = new SinkEventTestingSink();
        MacroRequest request = new MacroRequest(macroParameters, new File("."));
        new EchoMacro().execute((Sink)sink, request);
        Iterator<SinkEventElement> it = sink.getEventList().iterator();
        SinkEventElement event = it.next();
        EchoMacroTest.assertEquals((String)"verbatim", (String)event.getName());
        event = it.next();
        EchoMacroTest.assertEquals((String)"text", (String)event.getName());
        EchoMacroTest.assertEquals((String)("echo" + Macro.EOL), (String)((String)event.getArgs()[0]));
        event = it.next();
        EchoMacroTest.assertEquals((String)"text", (String)event.getName());
        EchoMacroTest.assertEquals((String)("paramName ---> paramValue" + Macro.EOL), (String)((String)event.getArgs()[0]));
        event = it.next();
        EchoMacroTest.assertEquals((String)"verbatim_", (String)event.getName());
        EchoMacroTest.assertFalse((boolean)it.hasNext());
    }

    public void testLog() {
        EchoMacro macro = new EchoMacro();
        macro.enableLogging(null);
        EchoMacroTest.assertNotNull((Object)macro.getLog());
        EchoMacroTest.assertNotNull((Object)macro.getLog());
    }
}

