/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.macro;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.SwfMacro;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventElement;
import org.apache.maven.doxia.sink.SinkEventTestingSink;

public class SwfMacroTest
extends TestCase {
    public void testExecute() throws MacroExecutionException {
        HashMap<String, String> macroParameters = new HashMap<String, String>();
        macroParameters.put("src", "src.swf");
        macroParameters.put("id", "Movie");
        macroParameters.put("width", "50");
        macroParameters.put("height", "60");
        macroParameters.put("quality", "best");
        macroParameters.put("menu", "true");
        macroParameters.put("loop", "3");
        macroParameters.put("play", "false");
        macroParameters.put("version", "6");
        macroParameters.put("allowScript", "always");
        SinkEventTestingSink sink = new SinkEventTestingSink();
        MacroRequest request = new MacroRequest(macroParameters, new File("."));
        SwfMacro macro = new SwfMacro();
        macro.required("src", "value");
        try {
            macro.required("src", "");
            SwfMacroTest.fail();
        }
        catch (IllegalArgumentException e) {
            SwfMacroTest.assertNotNull((Object)e);
        }
        try {
            macro.required("src", null);
            SwfMacroTest.fail();
        }
        catch (IllegalArgumentException e) {
            SwfMacroTest.assertNotNull((Object)e);
        }
        macro.execute((Sink)sink, request);
        Iterator<SinkEventElement> it = sink.getEventList().iterator();
        SinkEventElement event = it.next();
        SwfMacroTest.assertEquals((String)"rawText", (String)event.getName());
        SwfMacroTest.assertFalse((boolean)it.hasNext());
        request = new MacroRequest(new HashMap(), new File("."));
        sink.reset();
        macro.execute((Sink)sink, request);
        it = sink.getEventList().iterator();
        event = it.next();
        SwfMacroTest.assertEquals((String)"rawText", (String)event.getName());
        SwfMacroTest.assertFalse((boolean)it.hasNext());
    }
}

