/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.macro.snippet;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.snippet.SnippetMacro;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventElement;
import org.apache.maven.doxia.sink.SinkEventTestingSink;
import org.codehaus.plexus.PlexusTestCase;

public class SnippetMacroTest
extends PlexusTestCase {
    public void testExecute() throws MacroExecutionException {
        File basedir = new File(SnippetMacroTest.getBasedir());
        HashMap<String, String> macroParameters = new HashMap<String, String>();
        macroParameters.put("file", "src/test/resources/macro/snippet/testSnippet.txt");
        SinkEventTestingSink sink = new SinkEventTestingSink();
        MacroRequest request = new MacroRequest(macroParameters, basedir);
        SnippetMacro macro = new SnippetMacro();
        macro.execute((Sink)sink, request);
        Iterator<SinkEventElement> it = sink.getEventList().iterator();
        SnippetMacroTest.assertEquals((String)"verbatim", (String)it.next().getName());
        SinkEventElement event = it.next();
        SnippetMacroTest.assertEquals((String)"text", (String)event.getName());
        String snippet = (String)event.getArgs()[0];
        SnippetMacroTest.assertEquals((String)"verbatim_", (String)it.next().getName());
        SnippetMacroTest.assertFalse((boolean)it.hasNext());
        SnippetMacroTest.assertTrue((snippet.indexOf("preamble") != -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("first snippet") != -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("interlude") != -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("second snippet") != -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("conclusion") != -1 ? 1 : 0) != 0);
        macroParameters.put("id", "firstId");
        macroParameters.put("verbatim", "");
        sink.reset();
        request = new MacroRequest(macroParameters, basedir);
        macro.execute((Sink)sink, request);
        it = sink.getEventList().iterator();
        SnippetMacroTest.assertEquals((String)"verbatim", (String)it.next().getName());
        event = it.next();
        SnippetMacroTest.assertEquals((String)"text", (String)event.getName());
        snippet = (String)event.getArgs()[0];
        SnippetMacroTest.assertEquals((String)"verbatim_", (String)it.next().getName());
        SnippetMacroTest.assertFalse((boolean)it.hasNext());
        SnippetMacroTest.assertTrue((snippet.indexOf("preamble") == -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("first snippet") != -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("interlude") == -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("second snippet") == -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("conclusion") == -1 ? 1 : 0) != 0);
        macroParameters.put("id", "secondId");
        macroParameters.put("verbatim", "false");
        sink.reset();
        request = new MacroRequest(macroParameters, basedir);
        macro.execute((Sink)sink, request);
        it = sink.getEventList().iterator();
        event = it.next();
        SnippetMacroTest.assertEquals((String)"rawText", (String)event.getName());
        snippet = (String)event.getArgs()[0];
        SnippetMacroTest.assertFalse((boolean)it.hasNext());
        SnippetMacroTest.assertTrue((snippet.indexOf("preamble") == -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("first snippet") == -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("interlude") == -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("second snippet") != -1 ? 1 : 0) != 0);
        SnippetMacroTest.assertTrue((snippet.indexOf("conclusion") == -1 ? 1 : 0) != 0);
    }
}

