/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.macro.toc;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.toc.TocMacro;
import org.apache.maven.doxia.parser.XhtmlBaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventElement;
import org.apache.maven.doxia.sink.SinkEventTestingSink;
import org.apache.maven.doxia.sink.XhtmlBaseSink;

public class TocMacroTest
extends TestCase {
    public void testExecute() throws MacroExecutionException {
        String sourceContent = "<div><h2>h21</h2><h2>h22</h2><h3>h3</h3><h4>h4</h4><h2>h23</h2></div>";
        XhtmlBaseParser parser = new XhtmlBaseParser();
        parser.setSecondParsing(true);
        HashMap<String, Object> macroParameters = new HashMap<String, Object>();
        macroParameters.put("parser", parser);
        macroParameters.put("sourceContent", sourceContent);
        macroParameters.put("section", "sec1");
        File basedir = new File("");
        SinkEventTestingSink sink = new SinkEventTestingSink();
        MacroRequest request = new MacroRequest(macroParameters, basedir);
        TocMacro macro = new TocMacro();
        macro.execute((Sink)sink, request);
        Iterator<SinkEventElement> it = sink.getEventList().iterator();
        TocMacroTest.assertEquals((String)"list", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"text", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"text", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"list", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"text", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"list", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"text", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"list_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"list_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"text", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"list_", (String)it.next().getName());
        TocMacroTest.assertFalse((boolean)it.hasNext());
        parser = new XhtmlBaseParser();
        parser.setSecondParsing(true);
        macroParameters.put("parser", parser);
        macroParameters.put("section", "2");
        macroParameters.put("fromDepth", "1");
        macroParameters.put("toDepth", "2");
        macroParameters.put("class", "myClass");
        macroParameters.put("id", "myId");
        sink.reset();
        request = new MacroRequest(macroParameters, basedir);
        macro.execute((Sink)sink, request);
        it = sink.getEventList().iterator();
        SinkEventElement event = it.next();
        TocMacroTest.assertEquals((String)"list", (String)event.getName());
        SinkEventAttributeSet atts = (SinkEventAttributeSet)event.getArgs()[0];
        TocMacroTest.assertEquals((Object)"myId", (Object)atts.getAttribute((Object)"id"));
        TocMacroTest.assertEquals((Object)"myClass", (Object)atts.getAttribute((Object)"class"));
        TocMacroTest.assertEquals((String)"listItem", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link", (String)it.next().getName());
        event = it.next();
        TocMacroTest.assertEquals((String)"text", (String)event.getName());
        TocMacroTest.assertEquals((String)"h22", (String)((String)event.getArgs()[0]));
        TocMacroTest.assertEquals((String)"link_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"list", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"link", (String)it.next().getName());
        event = it.next();
        TocMacroTest.assertEquals((String)"text", (String)event.getName());
        TocMacroTest.assertEquals((String)"h3", (String)((String)event.getArgs()[0]));
        TocMacroTest.assertEquals((String)"link_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"list_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"listItem_", (String)it.next().getName());
        TocMacroTest.assertEquals((String)"list_", (String)it.next().getName());
        TocMacroTest.assertFalse((boolean)it.hasNext());
    }

    public void testTocStyle() throws MacroExecutionException {
        String sourceContent = "<div><h2>h<b>21</b></h2><h2>h<i>22</i></h2><h3>h<tt>3</tt></h3><h4>h4</h4><h2>h23</h2></div>";
        XhtmlBaseParser parser = new XhtmlBaseParser();
        parser.setSecondParsing(true);
        HashMap<String, Object> macroParameters = new HashMap<String, Object>();
        macroParameters.put("parser", parser);
        macroParameters.put("sourceContent", sourceContent);
        macroParameters.put("section", "sec1");
        File basedir = new File("");
        StringWriter out = new StringWriter();
        XhtmlBaseSink sink = new XhtmlBaseSink((Writer)out);
        MacroRequest request = new MacroRequest(macroParameters, basedir);
        TocMacro macro = new TocMacro();
        macro.execute((Sink)sink, request);
        TocMacroTest.assertTrue((out.toString().indexOf("<a href=\"#h21\">h21</a>") != -1 ? 1 : 0) != 0);
        TocMacroTest.assertTrue((out.toString().indexOf("<a href=\"#h22\">h22</a>") != -1 ? 1 : 0) != 0);
        TocMacroTest.assertTrue((out.toString().indexOf("<a href=\"#h3\">h3</a>") != -1 ? 1 : 0) != 0);
    }
}

