/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.util.Iterator;
import org.apache.maven.doxia.parser.XhtmlBaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventElement;
import org.apache.maven.doxia.sink.SinkEventTestingSink;
import org.codehaus.plexus.PlexusTestCase;

public class XhtmlBaseParserTest
extends PlexusTestCase {
    private XhtmlBaseParser parser;
    private final SinkEventTestingSink sink = new SinkEventTestingSink();

    protected void setUp() throws Exception {
        super.setUp();
        this.parser = new XhtmlBaseParser();
        this.parser.getLog().setLogLevel(3);
        this.sink.reset();
    }

    public void testDoxiaVersion() {
        XhtmlBaseParserTest.assertNotNull((Object)XhtmlBaseParser.doxiaVersion());
        XhtmlBaseParserTest.assertFalse((boolean)"unknown".equals(XhtmlBaseParser.doxiaVersion()));
    }

    public void testHeadingEventsList() throws Exception {
        String text = "<p><h2></h2><h3></h3><h4></h4><h5></h5><h6></h6><h2></h2></p>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section1", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section2", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle2", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle2_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section3", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle3", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle3_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section4", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle4", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle4_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section5", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle5", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle5_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section5_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section4_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section3_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section2_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section1_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section1", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testNestedHeadingEventsList() throws Exception {
        String text = "<p><h2></h2><h6></h6><h3></h3></p>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section1", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section2", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section3", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section4", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section5", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle5", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle5_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section5_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section4_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section3_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section2_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"section2", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle2", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle2_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testFigureEventsList() throws Exception {
        String text = "<img src=\"source\" title=\"caption\" />";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"figureGraphics", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testTableEventsList() throws Exception {
        String text = "<table align=\"center\"><tr><th>Header</th></tr><tr><td>cell</td></tr></table>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"table", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRows", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableHeaderCell", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableHeaderCell_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableCell", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableCell_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRows_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"table_", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testSignificantWhiteSpace() throws Exception {
        String text = "<p><b>word</b> <i>word</i></p>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"bold", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"bold_", (String)it.next().getName());
        SinkEventElement el = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)el.getName());
        XhtmlBaseParserTest.assertEquals((String)" ", (String)((String)el.getArgs()[0]));
        XhtmlBaseParserTest.assertEquals((String)"italic", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"italic_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
        String eol = System.getProperty("line.separator");
        text = "<p><b>word</b>" + eol + "<i>word</i></p>";
        this.sink.reset();
        this.parser.parse(text, (Sink)this.sink);
        it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"bold", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"bold_", (String)it.next().getName());
        el = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)el.getName());
        XhtmlBaseParserTest.assertEquals((String)"\n", (String)((String)el.getArgs()[0]));
        XhtmlBaseParserTest.assertEquals((String)"italic", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"italic_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
        text = "<p>There should be no space after the last <i>word</i>.</p>";
        this.sink.reset();
        this.parser.parse(text, (Sink)this.sink);
        it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"italic", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"italic_", (String)it.next().getName());
        el = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)el.getName());
        XhtmlBaseParserTest.assertEquals((String)".", (String)((String)el.getArgs()[0]));
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testPreFormattedText() throws Exception {
        String text = "<pre><a href=\"what.html\">what</a></pre>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"verbatim", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"link", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"verbatim_", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
        text = "<pre><![CDATA[<a href=\"what.html\">what</a>]]></pre>";
        this.sink.reset();
        this.parser.parse(text, (Sink)this.sink);
        it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"verbatim", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"verbatim_", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
        text = "<pre><![CDATA[<pre>what</pre>]]></pre>";
        this.sink.reset();
        this.parser.parse(text, (Sink)this.sink);
        it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"verbatim", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"verbatim_", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testPreEOL() throws Exception {
        String text = "<pre><a href=\"what.html\">what</a>" + XhtmlBaseParser.EOL + "<a href=\"what.html\">what</a></pre>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"verbatim", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"link", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"link", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"text", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"verbatim_", (String)it.next().getName());
    }

    public void testDoxia250() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE test [").append(XhtmlBaseParser.EOL);
        sb.append("<!ENTITY foo \"&#x159;\">").append(XhtmlBaseParser.EOL);
        sb.append("<!ENTITY foo1 \"&nbsp;\">").append(XhtmlBaseParser.EOL);
        sb.append("<!ENTITY foo2 \"&#x161;\">").append(XhtmlBaseParser.EOL);
        sb.append("<!ENTITY tritPos \"&#x1d7ed;\">").append(XhtmlBaseParser.EOL);
        sb.append("]>").append(XhtmlBaseParser.EOL);
        sb.append("<b>&foo;&foo1;&foo2;&tritPos;</b>");
        this.parser.setValidate(false);
        this.parser.parse(sb.toString(), (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        SinkEventElement event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"bold", (String)event.getName());
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"\u0159", (String)((String)event.getArgs()[0]));
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"\u00a0", (String)((String)event.getArgs()[0]));
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"\u0161", (String)((String)event.getArgs()[0]));
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"\ud835\udfed", (String)((String)event.getArgs()[0]));
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"bold_", (String)event.getName());
    }

    public void testEntities() throws Exception {
        String text = "<!DOCTYPE test [<!ENTITY flo \"&#x159;\"><!ENTITY tritPos \"&#x1d7ed;\"><!ENTITY fo \"&#65;\"><!ENTITY myCustom \"&fo;\">]><body><h2>&amp;&flo;&#x159;&tritPos;&#x1d7ed;</h2><p>&amp;&flo;&#x159;&tritPos;&#x1d7ed;&myCustom;</p></body>";
        this.parser.setValidate(false);
        this.parser.parse("<!DOCTYPE test [<!ENTITY flo \"&#x159;\"><!ENTITY tritPos \"&#x1d7ed;\"><!ENTITY fo \"&#65;\"><!ENTITY myCustom \"&fo;\">]><body><h2>&amp;&flo;&#x159;&tritPos;&#x1d7ed;</h2><p>&amp;&flo;&#x159;&tritPos;&#x1d7ed;&myCustom;</p></body>", (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"section1", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1", (String)it.next().getName());
        SinkEventElement textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"&", (Object)textEvt.getArgs()[0]);
        textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\u0159", (Object)textEvt.getArgs()[0]);
        textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\u0159", (Object)textEvt.getArgs()[0]);
        textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((String)"\ud835\udfed", (String)((String)textEvt.getArgs()[0]));
        textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\ud835\udfed", (Object)textEvt.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"sectionTitle1_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)it.next().getName());
        textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"&", (Object)textEvt.getArgs()[0]);
        textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\u0159", (Object)textEvt.getArgs()[0]);
        textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\u0159", (Object)textEvt.getArgs()[0]);
        textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((String)"\ud835\udfed", (String)((String)textEvt.getArgs()[0]));
        textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"\ud835\udfed", (Object)textEvt.getArgs()[0]);
        textEvt = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)textEvt.getName());
        XhtmlBaseParserTest.assertEquals((Object)"A", (Object)textEvt.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
    }

    public void testDecoration() throws Exception {
        String text = "<div><u>u</u><s>s</s><del>del</del><strike>strike</strike><sub>sub</sub><sup>sup</sup></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        SinkEventElement event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"u", (String)((String)event.getArgs()[0]));
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"s", (String)((String)event.getArgs()[0]));
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"del", (String)((String)event.getArgs()[0]));
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"strike", (String)((String)event.getArgs()[0]));
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"sub", (String)((String)event.getArgs()[0]));
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"text", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((String)"sup", (String)((String)event.getArgs()[0]));
    }

    public void testLists() throws Exception {
        String text = "<div><ul><li></li></ul><ol><li></li></ol><dl><dt></dt><dd></dd></dl></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"list", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"listItem", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"listItem_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"list_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"numberedList", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"numberedListItem", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"numberedListItem_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"numberedList_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"definitionList", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"definitionListItem", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"definedTerm", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"definedTerm_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"definition", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"definition_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"definitionListItem_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"definitionList_", (String)it.next().getName());
    }

    public void testStyles() throws Exception {
        String text = "<div><b></b><strong></strong><i></i><em></em><code></code><samp></samp><tt></tt></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"bold", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"bold_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"bold", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"bold_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"italic", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"italic_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"italic", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"italic_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"monospaced_", (String)it.next().getName());
    }

    public void testSimpleTags() throws Exception {
        String text = "<div><br/><hr/><img src=\"img.src\"/></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"lineBreak", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"horizontalRule", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"figureGraphics", (String)it.next().getName());
    }

    public void testSpecial() throws Exception {
        String text = "<p><!-- a pagebreak: --><!-- PB -->&nbsp;&#160;<unknown /></p>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"paragraph", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"comment", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"pageBreak", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"nonBreakingSpace", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"nonBreakingSpace", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"paragraph_", (String)it.next().getName());
    }

    public void testTable() throws Exception {
        String text = "<table><caption></caption><tr><th></th></tr><tr><td></td></tr></table>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"table", (String)it.next().getName());
        SinkEventElement el = it.next();
        XhtmlBaseParserTest.assertEquals((String)"tableRows", (String)el.getName());
        XhtmlBaseParserTest.assertFalse((boolean)((Boolean)el.getArgs()[1]));
        XhtmlBaseParserTest.assertEquals((String)"tableCaption", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableCaption_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableHeaderCell", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableHeaderCell_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableCell", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableCell_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRow_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"tableRows_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"table_", (String)it.next().getName());
    }

    public void testFigure() throws Exception {
        String text = "<div class=\"figure\"><p><img src=\"src.jpg\"/></p><p><i></i></p></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        XhtmlBaseParserTest.assertEquals((String)"figure", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"figureGraphics", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"figureCaption", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"figureCaption_", (String)it.next().getName());
        XhtmlBaseParserTest.assertEquals((String)"figure_", (String)it.next().getName());
    }

    public void testAnchorLink() throws Exception {
        String text = "<div><a href=\"\"></a><a href=\"valid\"></a><a href=\"#1invalid\"></a><a href=\"http://www.fo.com/index.html#1invalid\"></a><a name=\"valid\"></a><a name=\"1invalid\"></a><a id=\"1invalid\"></a></div>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        SinkEventElement element = it.next();
        XhtmlBaseParserTest.assertEquals((String)"link", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)it.next().getName());
        element = it.next();
        XhtmlBaseParserTest.assertEquals((String)"link", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"valid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)it.next().getName());
        element = it.next();
        XhtmlBaseParserTest.assertEquals((String)"link", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"#a1invalid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)it.next().getName());
        element = it.next();
        XhtmlBaseParserTest.assertEquals((String)"link", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"http://www.fo.com/index.html#1invalid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"link_", (String)it.next().getName());
        element = it.next();
        XhtmlBaseParserTest.assertEquals((String)"anchor", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"valid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"anchor_", (String)it.next().getName());
        element = it.next();
        XhtmlBaseParserTest.assertEquals((String)"anchor", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"a1invalid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"anchor_", (String)it.next().getName());
        element = it.next();
        XhtmlBaseParserTest.assertEquals((String)"anchor", (String)element.getName());
        XhtmlBaseParserTest.assertEquals((Object)"a1invalid", (Object)element.getArgs()[0]);
        XhtmlBaseParserTest.assertEquals((String)"anchor_", (String)it.next().getName());
    }

    public void testAttributeEntities() throws Exception {
        String text = "<script type=\"text/javascript\" src=\"http://ex.com/ex.js?v=l&amp;l=e\"></script>";
        this.parser.parse(text, (Sink)this.sink);
        Iterator<SinkEventElement> it = this.sink.getEventList().iterator();
        SinkEventElement event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"unknown", (String)event.getName());
        XhtmlBaseParserTest.assertEquals((Object)"script", (Object)event.getArgs()[0]);
        SinkEventAttributeSet attribs = (SinkEventAttributeSet)event.getArgs()[2];
        XhtmlBaseParserTest.assertEquals((Object)"http://ex.com/ex.js?v=l&l=e", (Object)attribs.getAttribute((Object)"src"));
        XhtmlBaseParserTest.assertEquals((String)"unknown", (String)it.next().getName());
        XhtmlBaseParserTest.assertFalse((boolean)it.hasNext());
        this.sink.reset();
        text = "<img src=\"http://ex.com/ex.jpg?v=l&amp;l=e\" alt=\"image\"/>";
        this.parser.parse(text, (Sink)this.sink);
        it = this.sink.getEventList().iterator();
        event = it.next();
        XhtmlBaseParserTest.assertEquals((String)"figureGraphics", (String)event.getName());
        attribs = (SinkEventAttributeSet)event.getArgs()[1];
        XhtmlBaseParserTest.assertEquals((Object)"http://ex.com/ex.jpg?v=l&l=e", (Object)attribs.getAttribute((Object)"src"));
    }
}

