/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import junit.framework.TestCase;
import org.apache.maven.doxia.sink.AbstractXmlSink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;

public class AbstractXmlSinkTest
extends TestCase {
    public void testNameSpace() {
        HTML.Tag t = HTML.Tag.A;
        String ns = "ns";
        XmlTestSink instance = new XmlTestSink();
        instance.writeStartTag(t);
        instance.writeEndTag(t);
        AbstractXmlSinkTest.assertEquals((String)"<a></a>", (String)instance.getText());
        instance.writeSimpleTag(t);
        AbstractXmlSinkTest.assertEquals((String)"<a />", (String)instance.getText());
        instance.setNameSpace("ns");
        instance.writeStartTag(t);
        instance.writeEndTag(t);
        AbstractXmlSinkTest.assertEquals((String)"<ns:a></ns:a>", (String)instance.getText());
        instance.writeSimpleTag(t);
        AbstractXmlSinkTest.assertEquals((String)"<ns:a />", (String)instance.getText());
        AbstractXmlSinkTest.assertEquals((String)"ns", (String)instance.getNameSpace());
        try {
            instance.writeStartTag(null);
            AbstractXmlSinkTest.fail((String)"null tag should fail!");
        }
        catch (IllegalArgumentException e) {
            AbstractXmlSinkTest.assertNotNull((Object)e);
        }
        try {
            instance.writeEndTag(null);
            AbstractXmlSinkTest.fail((String)"null tag should fail!");
        }
        catch (IllegalArgumentException e) {
            AbstractXmlSinkTest.assertNotNull((Object)e);
        }
    }

    public void testWriteStartTag() {
        HTML.Tag t = HTML.Tag.A;
        SinkEventAttributeSet att = new SinkEventAttributeSet((AttributeSet)SinkEventAttributeSet.BOLD);
        XmlTestSink instance = new XmlTestSink();
        instance.writeStartTag(t);
        AbstractXmlSinkTest.assertEquals((String)"<a>", (String)instance.getText());
        instance.writeStartTag(t, (MutableAttributeSet)att);
        AbstractXmlSinkTest.assertEquals((String)"<a style=\"bold\">", (String)instance.getText());
        instance.writeStartTag(t, (MutableAttributeSet)att, false);
        AbstractXmlSinkTest.assertEquals((String)"<a style=\"bold\">", (String)instance.getText());
        instance.writeStartTag(t, (MutableAttributeSet)att, true);
        AbstractXmlSinkTest.assertEquals((String)"<a style=\"bold\" />", (String)instance.getText());
    }

    public void testWriteEOL() {
        XmlTestSink instance = new XmlTestSink();
        instance.writeEOL();
        AbstractXmlSinkTest.assertEquals((String)System.getProperty("line.separator"), (String)instance.getText());
    }

    public void testWriteSimpleTag() {
        HTML.Tag t = HTML.Tag.A;
        SinkEventAttributeSet att = new SinkEventAttributeSet((AttributeSet)SinkEventAttributeSet.BOLD);
        XmlTestSink instance = new XmlTestSink();
        instance.writeSimpleTag(t);
        AbstractXmlSinkTest.assertEquals((String)"<a />", (String)instance.getText());
        instance.writeSimpleTag(t, (MutableAttributeSet)att);
        AbstractXmlSinkTest.assertEquals((String)"<a style=\"bold\" />", (String)instance.getText());
    }

    private class XmlTestSink
    extends AbstractXmlSink {
        private final StringBuffer buffer = new StringBuffer(0);

        private XmlTestSink() {
        }

        public void reset() {
            this.buffer.setLength(0);
        }

        public String getText() {
            String text = this.buffer.toString();
            this.reset();
            return text;
        }

        protected void write(String text) {
            this.buffer.append(text);
        }
    }
}

