/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import junit.framework.TestCase;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;

public class SinkEventAttributeSetTest
extends TestCase {
    private SinkEventAttributeSet sinkEventAttributeSet;

    protected void setUp() throws Exception {
        super.setUp();
        this.sinkEventAttributeSet = new SinkEventAttributeSet();
    }

    public void testConstructor() {
        try {
            SinkEventAttributeSet aset = new SinkEventAttributeSet(new String[]{"key"});
            SinkEventAttributeSetTest.fail((String)"missing attribute value!");
        }
        catch (IllegalArgumentException e) {
            SinkEventAttributeSetTest.assertNotNull((Object)e);
        }
    }

    public void testIsEmpty() {
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.isEmpty());
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.BOLD);
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.isEmpty());
    }

    public void testGetAttributeCount() {
        SinkEventAttributeSetTest.assertEquals((int)0, (int)this.sinkEventAttributeSet.getAttributeCount());
        this.sinkEventAttributeSet.addAttribute((Object)"name1", (Object)"value1");
        SinkEventAttributeSetTest.assertEquals((int)1, (int)this.sinkEventAttributeSet.getAttributeCount());
        this.sinkEventAttributeSet.removeAttribute((Object)"name2");
        SinkEventAttributeSetTest.assertEquals((int)1, (int)this.sinkEventAttributeSet.getAttributeCount());
        this.sinkEventAttributeSet.removeAttribute((Object)"name1");
        SinkEventAttributeSetTest.assertEquals((int)0, (int)this.sinkEventAttributeSet.getAttributeCount());
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.BOLD);
        SinkEventAttributeSetTest.assertEquals((int)1, (int)this.sinkEventAttributeSet.getAttributeCount());
        this.sinkEventAttributeSet.removeAttributes((AttributeSet)SinkEventAttributeSet.BOXED);
        SinkEventAttributeSetTest.assertEquals((int)1, (int)this.sinkEventAttributeSet.getAttributeCount());
        this.sinkEventAttributeSet.removeAttributes((AttributeSet)SinkEventAttributeSet.BOLD);
        SinkEventAttributeSetTest.assertEquals((int)0, (int)this.sinkEventAttributeSet.getAttributeCount());
    }

    public void testIsDefined() {
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.isDefined((Object)"decoration"));
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.BOXED);
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.isDefined((Object)"decoration"));
    }

    public void testIsEqual() {
        SinkEventAttributeSet instance = new SinkEventAttributeSet((AttributeSet)SinkEventAttributeSet.BOLD);
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.BOLD);
        SinkEventAttributeSetTest.assertTrue((boolean)instance.isEqual((AttributeSet)this.sinkEventAttributeSet));
        instance.addAttributes((AttributeSet)SinkEventAttributeSet.BOXED);
        SinkEventAttributeSetTest.assertFalse((boolean)instance.isEqual((AttributeSet)this.sinkEventAttributeSet));
    }

    public void testEquals() {
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.equals(null));
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.equals((Object)this.sinkEventAttributeSet));
        SinkEventAttributeSet instance = new SinkEventAttributeSet((AttributeSet)SinkEventAttributeSet.BOLD);
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.BOLD);
        SinkEventAttributeSetTest.assertTrue((boolean)instance.equals(this.sinkEventAttributeSet));
        instance.addAttributes((AttributeSet)SinkEventAttributeSet.BOXED);
        SinkEventAttributeSetTest.assertFalse((boolean)instance.equals(this.sinkEventAttributeSet));
    }

    public void testCopyAttributes() {
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.ITALIC);
        AttributeSet instance = this.sinkEventAttributeSet.copyAttributes();
        SinkEventAttributeSetTest.assertTrue((boolean)instance.isEqual((AttributeSet)this.sinkEventAttributeSet));
    }

    public void testGetAttributeNames() {
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.UNDERLINE);
        Enumeration result = this.sinkEventAttributeSet.getAttributeNames();
        SinkEventAttributeSetTest.assertEquals((String)"decoration", (String)((String)result.nextElement()));
        SinkEventAttributeSetTest.assertFalse((boolean)result.hasMoreElements());
    }

    public void testGetAttribute() {
        this.sinkEventAttributeSet.addAttribute((Object)"key", (Object)"value");
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.getAttribute((Object)"key").equals("value"));
        SinkEventAttributeSetTest.assertNull((Object)this.sinkEventAttributeSet.getAttribute((Object)"bla"));
    }

    public void testContainsAttribute() {
        this.sinkEventAttributeSet.addAttribute((Object)"key", (Object)"value");
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.containsAttribute((Object)"key", (Object)"value"));
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.containsAttribute((Object)"key", (Object)"valu"));
    }

    public void testContainsAttributes() {
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.JUSTIFY);
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.containsAttributes((AttributeSet)SinkEventAttributeSet.JUSTIFY));
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.containsAttributes((AttributeSet)SinkEventAttributeSet.BOXED));
    }

    public void testAddAttribute() {
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.containsAttribute((Object)"key", (Object)"value"));
        this.sinkEventAttributeSet.addAttribute((Object)"key", (Object)"value");
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.containsAttribute((Object)"key", (Object)"value"));
        this.sinkEventAttributeSet.removeAttribute((Object)"key");
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.containsAttribute((Object)"key", (Object)"value"));
    }

    public void testAddAttributes() {
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.containsAttributes((AttributeSet)SinkEventAttributeSet.JUSTIFY));
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.JUSTIFY);
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.containsAttributes((AttributeSet)SinkEventAttributeSet.JUSTIFY));
        this.sinkEventAttributeSet.removeAttributes((AttributeSet)SinkEventAttributeSet.JUSTIFY);
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.containsAttributes((AttributeSet)SinkEventAttributeSet.JUSTIFY));
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.JUSTIFY);
        this.sinkEventAttributeSet.removeAttributes(SinkEventAttributeSet.JUSTIFY.getAttributeNames());
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.containsAttributes((AttributeSet)SinkEventAttributeSet.JUSTIFY));
        this.sinkEventAttributeSet.setResolveParent((AttributeSet)SinkEventAttributeSet.JUSTIFY);
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.containsAttributes((AttributeSet)SinkEventAttributeSet.JUSTIFY));
        this.sinkEventAttributeSet.removeAttributes((AttributeSet)null);
    }

    public void testGetResolveParent() {
        SinkEventAttributeSetTest.assertNull((Object)this.sinkEventAttributeSet.getResolveParent());
        this.sinkEventAttributeSet.setResolveParent((AttributeSet)SinkEventAttributeSet.CENTER);
        SinkEventAttributeSetTest.assertNotNull((Object)this.sinkEventAttributeSet.getResolveParent());
    }

    public void testClone() {
        Object result = this.sinkEventAttributeSet.clone();
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.equals(result));
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.MONOSPACED);
        SinkEventAttributeSetTest.assertFalse((boolean)this.sinkEventAttributeSet.equals(result));
        result = this.sinkEventAttributeSet.clone();
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.equals(result));
        this.sinkEventAttributeSet.setResolveParent((AttributeSet)SinkEventAttributeSet.CENTER);
        result = this.sinkEventAttributeSet.clone();
        SinkEventAttributeSetTest.assertTrue((boolean)this.sinkEventAttributeSet.equals(result));
        this.sinkEventAttributeSet.setResolveParent((AttributeSet)SinkEventAttributeSet.BOXED);
    }

    public void testHashCode() {
        int oldValue = this.sinkEventAttributeSet.hashCode();
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.BOLD);
        int newValue = this.sinkEventAttributeSet.hashCode();
        SinkEventAttributeSetTest.assertFalse((oldValue == newValue ? 1 : 0) != 0);
        oldValue = newValue;
        this.sinkEventAttributeSet.setResolveParent((AttributeSet)SinkEventAttributeSet.CENTER);
        newValue = this.sinkEventAttributeSet.hashCode();
        SinkEventAttributeSetTest.assertFalse((oldValue == newValue ? 1 : 0) != 0);
    }

    public void testToString() {
        String expected = "";
        SinkEventAttributeSetTest.assertEquals((String)expected, (String)this.sinkEventAttributeSet.toString());
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.BOXED);
        expected = " decoration=boxed";
        SinkEventAttributeSetTest.assertEquals((String)expected, (String)this.sinkEventAttributeSet.toString());
        this.sinkEventAttributeSet.addAttributes((AttributeSet)SinkEventAttributeSet.CENTER);
        expected = " decoration=boxed align=center";
        SinkEventAttributeSetTest.assertEquals((String)expected, (String)this.sinkEventAttributeSet.toString());
    }
}

