/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;

public class SinkTestDocument {
    private SinkTestDocument() {
    }

    public static void generate(Sink sink) {
        SinkTestDocument.generateHead(sink);
        sink.body();
        sink.paragraph();
        sink.text("Paragraph 1, line 1. Paragraph 1, line 2.");
        sink.paragraph_();
        sink.paragraph();
        sink.text("Paragraph 2, line 1. Paragraph 2, line 2.");
        sink.paragraph_();
        sink.section1();
        sink.sectionTitle1();
        sink.text("Section title");
        sink.sectionTitle1_();
        sink.section2();
        sink.sectionTitle2();
        sink.text("Sub-section title");
        sink.sectionTitle2_();
        sink.section3();
        sink.sectionTitle3();
        sink.text("Sub-sub-section title");
        sink.sectionTitle3_();
        sink.section4();
        sink.sectionTitle4();
        sink.text("Sub-sub-sub-section title");
        sink.sectionTitle4_();
        sink.section5();
        sink.sectionTitle5();
        sink.text("Sub-sub-sub-sub-section title");
        sink.sectionTitle5_();
        SinkTestDocument.generateList(sink);
        sink.verbatim(SinkEventAttributeSet.BOXED);
        sink.text("Verbatim text not contained in list item 3");
        sink.verbatim_();
        SinkTestDocument.generateNumberedList(sink);
        sink.paragraph();
        sink.text("List numbering schemes: [[1]], [[a]], [[A]], [[i]], [[I]].");
        sink.paragraph_();
        SinkTestDocument.generateDefinitionList(sink);
        sink.paragraph();
        sink.text("--- instead of +-- suppresses the box around verbatim text.");
        sink.paragraph_();
        SinkTestDocument.generateFigure(sink);
        SinkTestDocument.generateTable(sink);
        sink.paragraph();
        sink.text("No grid, no caption:");
        sink.paragraph_();
        SinkTestDocument.generateNoGridTable(sink);
        SinkTestDocument.generateHeaderTable(sink);
        SinkTestDocument.generateHorizontalRule(sink);
        SinkTestDocument.generatePageBreak(sink);
        SinkTestDocument.generateFonts(sink);
        SinkTestDocument.generateAnchors(sink);
        SinkTestDocument.generateLineBreak(sink);
        SinkTestDocument.generateNonBreakingSpace(sink);
        SinkTestDocument.generateSpecialCharacters(sink);
        sink.comment("A comment!");
        sink.section5_();
        sink.section4_();
        sink.section3_();
        sink.section2_();
        sink.section1_();
        sink.body_();
        sink.flush();
    }

    public static void generateHead(Sink sink) {
        sink.head();
        sink.title();
        sink.text("Title");
        sink.title_();
        sink.author();
        sink.text("Author");
        sink.author_();
        sink.date();
        sink.text("Date");
        sink.date_();
        sink.head_();
    }

    public static void generateList(Sink sink) {
        sink.list();
        sink.listItem();
        sink.text("List item 1.");
        sink.listItem_();
        sink.listItem();
        sink.text("List item 2.");
        sink.paragraph();
        sink.text("Paragraph contained in list item 2.");
        sink.paragraph_();
        sink.list();
        sink.listItem();
        sink.text("Sub-list item 1.");
        sink.listItem_();
        sink.listItem();
        sink.text("Sub-list item 2.");
        sink.listItem_();
        sink.list_();
        sink.listItem_();
        sink.listItem();
        sink.text("List item 3. Force end of list:");
        sink.listItem_();
        sink.list_();
    }

    public static void generateNumberedList(Sink sink) {
        sink.numberedList(0);
        sink.numberedListItem();
        sink.text("Numbered item 1.");
        sink.numberedList(2);
        sink.numberedListItem();
        sink.text("Numbered item A.");
        sink.numberedListItem_();
        sink.numberedListItem();
        sink.text("Numbered item B.");
        sink.numberedListItem_();
        sink.numberedList_();
        sink.numberedListItem_();
        sink.numberedListItem();
        sink.text("Numbered item 2.");
        sink.numberedListItem_();
        sink.numberedList_();
    }

    public static void generateDefinitionList(Sink sink) {
        String eol = System.getProperty("line.separator");
        sink.definitionList();
        sink.definitionListItem();
        sink.definedTerm();
        sink.text("Defined term 1");
        sink.definedTerm_();
        sink.definition();
        sink.text("of definition list.");
        sink.definition_();
        sink.definitionListItem_();
        sink.definitionListItem();
        sink.definedTerm();
        sink.text("Defined term 2");
        sink.definedTerm_();
        sink.definition();
        sink.text("of definition list.");
        sink.verbatim(SinkEventAttributeSet.BOXED);
        sink.text("Verbatim text" + eol + "                        in a box        ");
        sink.verbatim_();
        sink.definition_();
        sink.definitionListItem_();
        sink.definitionList_();
    }

    public static void generateFigure(Sink sink) {
        sink.figure(null);
        sink.figureGraphics("figure.png", null);
        sink.figureCaption(null);
        sink.text("Figure caption", null);
        sink.figureCaption_();
        sink.figure_();
    }

    public static void generateTable(Sink sink) {
        int[] justify = new int[]{0, 1, 2};
        sink.table();
        sink.tableRows(justify, true);
        sink.tableRow();
        sink.tableCell();
        sink.text("Centered");
        sink.lineBreak();
        sink.text("cell 1,1");
        sink.tableCell_();
        sink.tableCell();
        sink.text("Left-aligned");
        sink.lineBreak();
        sink.text("cell 1,2");
        sink.tableCell_();
        sink.tableCell();
        sink.text("Right-aligned");
        sink.lineBreak();
        sink.text("cell 1,3");
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.text("cell 2,1");
        sink.tableCell_();
        sink.tableCell();
        sink.text("cell 2,2");
        sink.tableCell_();
        sink.tableCell();
        sink.text("cell 2,3");
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRows_();
        sink.tableCaption();
        sink.text("Table caption");
        sink.tableCaption_();
        sink.table_();
    }

    public static void generateNoGridTable(Sink sink) {
        int[] justify = new int[]{0, 0};
        sink.table();
        sink.tableRows(justify, false);
        sink.tableRow();
        sink.tableCell();
        sink.text("cell");
        sink.tableCell_();
        sink.tableCell();
        sink.text("cell");
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.text("cell");
        sink.tableCell_();
        sink.tableCell();
        sink.text("cell");
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRows_();
        sink.table_();
    }

    public static void generateHeaderTable(Sink sink) {
        int[] justify = new int[]{0, 0};
        sink.table();
        sink.tableRows(justify, true);
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text("header");
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text("header");
        sink.tableHeaderCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableCell();
        sink.text("cell");
        sink.tableCell_();
        sink.tableCell();
        sink.text("cell");
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRows_();
        sink.table_();
    }

    public static void generateFonts(Sink sink) {
        sink.paragraph();
        sink.italic();
        sink.text("Italic");
        sink.italic_();
        sink.text(" font. ");
        sink.bold();
        sink.text("Bold");
        sink.bold_();
        sink.text(" font. ");
        sink.monospaced();
        sink.text("Monospaced");
        sink.monospaced_();
        sink.text(" font.");
        sink.paragraph_();
    }

    public static void generateAnchors(Sink sink) {
        sink.paragraph();
        sink.anchor("Anchor");
        sink.text("Anchor");
        sink.anchor_();
        sink.text(". Link to ");
        sink.link("#Anchor");
        sink.text("Anchor");
        sink.link_();
        sink.text(". Link to ");
        sink.link("http://www.pixware.fr");
        sink.text("http://www.pixware.fr");
        sink.link_();
        sink.text(". Link to ");
        sink.link("#Anchor");
        sink.text("showing alternate text");
        sink.link_();
        sink.text(". Link to ");
        sink.link("http://www.pixware.fr");
        sink.text("Pixware home page");
        sink.link_();
        sink.text(".");
        sink.paragraph_();
    }

    public static void generateHorizontalRule(Sink sink) {
        sink.paragraph();
        sink.text("Horizontal line:");
        sink.paragraph_();
        sink.horizontalRule();
    }

    public static void generatePageBreak(Sink sink) {
        sink.pageBreak();
        sink.paragraph();
        sink.text("New page.");
        sink.paragraph_();
    }

    public static void generateLineBreak(Sink sink) {
        sink.paragraph();
        sink.text("Force line");
        sink.lineBreak();
        sink.text("break.");
        sink.paragraph_();
    }

    public static void generateNonBreakingSpace(Sink sink) {
        sink.paragraph();
        sink.text("Non");
        sink.nonBreakingSpace();
        sink.text("breaking");
        sink.nonBreakingSpace();
        sink.text("space.");
        sink.paragraph_();
    }

    public static void generateSpecialCharacters(Sink sink) {
        sink.paragraph();
        sink.text("Escaped special characters:");
        sink.lineBreak();
        sink.text("~");
        sink.lineBreak();
        sink.text("=");
        sink.lineBreak();
        sink.text("-");
        sink.lineBreak();
        sink.text("+");
        sink.lineBreak();
        sink.text("*");
        sink.lineBreak();
        sink.text("[");
        sink.lineBreak();
        sink.text("]");
        sink.lineBreak();
        sink.text("<");
        sink.lineBreak();
        sink.text(">");
        sink.lineBreak();
        sink.text("{");
        sink.lineBreak();
        sink.text("}");
        sink.lineBreak();
        sink.text("\\");
        sink.paragraph_();
        sink.paragraph();
        sink.text("Copyright symbol:");
        sink.lineBreak();
        sink.text("\u00a9");
        sink.paragraph_();
    }
}

