/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.maven.doxia.sink.AbstractSink;
import org.apache.maven.doxia.sink.SinkEventAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WellformednessCheckingSink
extends AbstractSink {
    private final Stack<String> elements = new Stack();
    private final List<String> errors = new LinkedList<String>();

    public void head() {
        this.startElement("head");
    }

    public void head_() {
        this.checkWellformedness("head");
    }

    public void body() {
        this.startElement("body");
    }

    public void body_() {
        this.checkWellformedness("body");
    }

    public void section1() {
        this.startElement("section1");
    }

    public void section1_() {
        this.checkWellformedness("section1");
    }

    public void section2() {
        this.startElement("section2");
    }

    public void section2_() {
        this.checkWellformedness("section2");
    }

    public void section3() {
        this.startElement("section3");
    }

    public void section3_() {
        this.checkWellformedness("section3");
    }

    public void section4() {
        this.startElement("section4");
    }

    public void section4_() {
        this.checkWellformedness("section4");
    }

    public void section5() {
        this.startElement("section5");
    }

    public void section5_() {
        this.checkWellformedness("section5");
    }

    public void list() {
        this.startElement("list");
    }

    public void list_() {
        this.checkWellformedness("list");
    }

    public void listItem() {
        this.startElement("listItem");
    }

    public void listItem_() {
        this.checkWellformedness("listItem");
    }

    public void numberedList(int numbering) {
        this.startElement("numberedList");
    }

    public void numberedList_() {
        this.checkWellformedness("numberedList");
    }

    public void numberedListItem() {
        this.startElement("numberedListItem");
    }

    public void numberedListItem_() {
        this.checkWellformedness("numberedListItem");
    }

    public void definitionList() {
        this.startElement("definitionList");
    }

    public void definitionList_() {
        this.checkWellformedness("definitionList");
    }

    public void definitionListItem() {
        this.startElement("definitionListItem");
    }

    public void definitionListItem_() {
        this.checkWellformedness("definitionListItem");
    }

    public void definition() {
        this.startElement("definition");
    }

    public void definition_() {
        this.checkWellformedness("definition");
    }

    public void figure() {
        this.startElement("figure");
    }

    public void figure_() {
        this.checkWellformedness("figure");
    }

    public void table() {
        this.startElement("table");
    }

    public void table_() {
        this.checkWellformedness("table");
    }

    public void tableRows(int[] justification, boolean grid) {
        this.startElement("tableRows");
    }

    public void tableRows_() {
        this.checkWellformedness("tableRows");
    }

    public void tableRow() {
        this.startElement("tableRow");
    }

    public void tableRow_() {
        this.checkWellformedness("tableRow");
    }

    public void title() {
        this.startElement("title");
    }

    public void title_() {
        this.checkWellformedness("title");
    }

    public void author() {
        this.startElement("author");
    }

    public void author_() {
        this.checkWellformedness("author");
    }

    public void date() {
        this.startElement("date");
    }

    public void date_() {
        this.checkWellformedness("date");
    }

    public void sectionTitle() {
        this.startElement("sectionTitle");
    }

    public void sectionTitle_() {
        this.checkWellformedness("sectionTitle");
    }

    public void sectionTitle1() {
        this.startElement("sectionTitle1");
    }

    public void sectionTitle1_() {
        this.checkWellformedness("sectionTitle1");
    }

    public void sectionTitle2() {
        this.startElement("sectionTitle2");
    }

    public void sectionTitle2_() {
        this.checkWellformedness("sectionTitle2");
    }

    public void sectionTitle3() {
        this.startElement("sectionTitle3");
    }

    public void sectionTitle3_() {
        this.checkWellformedness("sectionTitle3");
    }

    public void sectionTitle4() {
        this.startElement("sectionTitle4");
    }

    public void sectionTitle4_() {
        this.checkWellformedness("sectionTitle4");
    }

    public void sectionTitle5() {
        this.startElement("sectionTitle5");
    }

    public void sectionTitle5_() {
        this.checkWellformedness("sectionTitle5");
    }

    public void paragraph() {
        this.startElement("paragraph");
    }

    public void paragraph_() {
        this.checkWellformedness("paragraph");
    }

    public void verbatim(boolean boxed) {
        this.startElement("verbatim");
    }

    public void verbatim_() {
        this.checkWellformedness("verbatim");
    }

    public void definedTerm() {
        this.startElement("definedTerm");
    }

    public void definedTerm_() {
        this.checkWellformedness("definedTerm");
    }

    public void figureCaption() {
        this.startElement("figureCaption");
    }

    public void figureCaption_() {
        this.checkWellformedness("figureCaption");
    }

    public void tableCell() {
        this.startElement("tableCell");
    }

    public void tableCell(String width) {
        this.startElement("tableCell");
    }

    public void tableCell_() {
        this.checkWellformedness("tableCell");
    }

    public void tableHeaderCell() {
        this.startElement("tableHeaderCell");
    }

    public void tableHeaderCell(String width) {
        this.startElement("tableHeaderCell");
    }

    public void tableHeaderCell_() {
        this.checkWellformedness("tableHeaderCell");
    }

    public void tableCaption() {
        this.startElement("tableCaption");
    }

    public void tableCaption_() {
        this.checkWellformedness("tableCaption");
    }

    public void figureGraphics(String name) {
    }

    public void horizontalRule() {
    }

    public void pageBreak() {
    }

    public void anchor(String name) {
        this.startElement("anchor");
    }

    public void anchor_() {
        this.checkWellformedness("anchor");
    }

    public void link(String name) {
        this.startElement("link");
    }

    public void link_() {
        this.checkWellformedness("link");
    }

    public void italic() {
        this.startElement("italic");
    }

    public void italic_() {
        this.checkWellformedness("italic");
    }

    public void bold() {
        this.startElement("bold");
    }

    public void bold_() {
        this.checkWellformedness("bold");
    }

    public void monospaced() {
        this.startElement("monospaced");
    }

    public void monospaced_() {
        this.checkWellformedness("monospaced");
    }

    public void lineBreak() {
    }

    public void nonBreakingSpace() {
    }

    public void text(String text) {
    }

    public void rawText(String text) {
    }

    public void comment(String comment) {
    }

    public void flush() {
    }

    public void close() {
        this.elements.clear();
        this.errors.clear();
    }

    public boolean isWellformed() {
        return this.errors.size() == 0;
    }

    public String getOffender() {
        if (this.isWellformed()) {
            return null;
        }
        return this.errors.get(this.errors.size() - 1);
    }

    public List<String> getOffenders() {
        return this.errors;
    }

    private void checkWellformedness(String actual) {
        String expected = this.elements.pop();
        if (!expected.equals(actual)) {
            this.errors.add("Encountered closing: " + actual + ", expected " + expected);
        }
    }

    private void startElement(String string) {
        this.elements.push(string);
    }

    public void head(SinkEventAttributes attributes) {
        this.head();
    }

    public void title(SinkEventAttributes attributes) {
        this.title();
    }

    public void author(SinkEventAttributes attributes) {
        this.author();
    }

    public void date(SinkEventAttributes attributes) {
        this.date();
    }

    public void body(SinkEventAttributes attributes) {
        this.body();
    }

    public void section(int level, SinkEventAttributes attributes) {
        this.startElement("section" + level);
    }

    public void section_(int level) {
        this.checkWellformedness("section" + level);
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.startElement("sectionTitle" + level);
    }

    public void sectionTitle_(int level) {
        this.checkWellformedness("sectionTitle" + level);
    }

    public void list(SinkEventAttributes attributes) {
        this.list();
    }

    public void listItem(SinkEventAttributes attributes) {
        this.listItem();
    }

    public void numberedList(int numbering, SinkEventAttributes attributes) {
        this.numberedList(numbering);
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        this.numberedListItem();
    }

    public void definitionList(SinkEventAttributes attributes) {
        this.definitionList();
    }

    public void definitionListItem(SinkEventAttributes attributes) {
        this.definitionListItem();
    }

    public void definition(SinkEventAttributes attributes) {
        this.definition();
    }

    public void definedTerm(SinkEventAttributes attributes) {
        this.definedTerm();
    }

    public void figure(SinkEventAttributes attributes) {
        this.figure();
    }

    public void figureCaption(SinkEventAttributes attributes) {
        this.figureCaption();
    }

    public void figureGraphics(String src, SinkEventAttributes attributes) {
        this.figureGraphics(src);
    }

    public void table(SinkEventAttributes attributes) {
        this.table();
    }

    public void tableRow(SinkEventAttributes attributes) {
        this.tableRow();
    }

    public void tableCell(SinkEventAttributes attributes) {
        this.tableCell();
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableHeaderCell();
    }

    public void tableCaption(SinkEventAttributes attributes) {
        this.tableCaption();
    }

    public void paragraph(SinkEventAttributes attributes) {
        this.paragraph();
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.verbatim(false);
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        this.horizontalRule();
    }

    public void anchor(String name, SinkEventAttributes attributes) {
        this.anchor(name);
    }

    public void link(String name, SinkEventAttributes attributes) {
        this.link(name);
    }

    public void lineBreak(SinkEventAttributes attributes) {
        this.lineBreak();
    }

    public void text(String text, SinkEventAttributes attributes) {
        this.text(text);
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
    }
}

