/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.xsd;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.apache.maven.doxia.parser.Parser;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlValidator
extends PlexusTestCase {
    protected static final String EOL = System.getProperty("line.separator");
    private XMLReader xmlReader;

    protected boolean isFailErrorMessage(String message) {
        return message.indexOf("schema_reference.4: Failed to read schema document 'http://www.w3.org/2001/xml.xsd'") == -1 && message.indexOf("cvc-complex-type.4: Attribute 'alt' must appear on element 'img'.") == -1 && message.indexOf("cvc-complex-type.2.4.a: Invalid content starting with element") == -1 && message.indexOf("cvc-complex-type.2.4.a: Invalid content was found starting with element") == -1 && message.indexOf("cvc-datatype-valid.1.2.1:") == -1 && message.indexOf("cvc-attribute.3:") == -1;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.xmlReader = null;
    }

    public void testValidateFiles() throws Exception {
        Logger logger = this.getContainer().getLoggerManager().getLoggerForComponent(Parser.ROLE);
        for (Map.Entry<String, String> entry : this.getTestDocuments().entrySet()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Validate '" + entry.getKey() + "'");
            }
            List<ErrorMessage> errors = this.parseXML(entry.getValue().toString());
            for (ErrorMessage error : errors) {
                if (this.isFailErrorMessage(error.getMessage())) {
                    AbstractXmlValidator.fail((String)(entry.getKey() + EOL + error.toString()));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(entry.getKey() + EOL + error.toString());
            }
        }
    }

    protected abstract String addNamespaces(String var1);

    protected abstract Map<String, String> getTestDocuments() throws IOException;

    protected abstract EntityResolver getEntityResolver();

    private XMLReader getXMLReader() {
        if (this.xmlReader == null) {
            try {
                this.xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.xmlReader.setErrorHandler(new MessagesErrorHandler());
                this.xmlReader.setEntityResolver(this.getEntityResolver());
            }
            catch (SAXNotRecognizedException e) {
                throw new AssertionFailedError("SAXNotRecognizedException: " + e.getMessage());
            }
            catch (SAXNotSupportedException e) {
                throw new AssertionFailedError("SAXNotSupportedException: " + e.getMessage());
            }
            catch (SAXException e) {
                throw new AssertionFailedError("SAXException: " + e.getMessage());
            }
        }
        ((MessagesErrorHandler)this.xmlReader.getErrorHandler()).clearMessages();
        return this.xmlReader;
    }

    private List<ErrorMessage> parseXML(String content) throws IOException, SAXException {
        String xmlContent = this.addNamespaces(content);
        MessagesErrorHandler errorHandler = (MessagesErrorHandler)this.getXMLReader().getErrorHandler();
        this.getXMLReader().parse(new InputSource(new StringReader(xmlContent)));
        return errorHandler.getMessages();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessagesErrorHandler
    extends DefaultHandler {
        private final List<ErrorMessage> messages = new ArrayList<ErrorMessage>(8);

        MessagesErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.addMessage("Warning", e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.addMessage("Error", e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.addMessage("Fatal error", e);
        }

        private void addMessage(String pre, SAXParseException e) {
            ErrorMessage error = new ErrorMessage(pre, e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e.getMessage());
            this.messages.add(error);
        }

        protected List<ErrorMessage> getMessages() {
            return Collections.unmodifiableList(this.messages);
        }

        protected void clearMessages() {
            this.messages.clear();
        }
    }

    private static class ErrorMessage
    extends DefaultHandler {
        private final String level;
        private final String publicID;
        private final String systemID;
        private final int lineNumber;
        private final int columnNumber;
        private final String message;

        ErrorMessage(String level, String publicID, String systemID, int lineNumber, int columnNumber, String message) {
            this.level = level;
            this.publicID = publicID;
            this.systemID = systemID;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
            this.message = message;
        }

        protected String getLevel() {
            return this.level;
        }

        protected String getPublicID() {
            return this.publicID;
        }

        protected String getSystemID() {
            return this.systemID;
        }

        protected int getLineNumber() {
            return this.lineNumber;
        }

        protected int getColumnNumber() {
            return this.columnNumber;
        }

        protected String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(512);
            sb.append(this.level).append(EOL);
            sb.append("  Public ID: ").append(this.publicID).append(EOL);
            sb.append("  System ID: ").append(this.systemID).append(EOL);
            sb.append("  Line number: ").append(this.lineNumber).append(EOL);
            sb.append("  Column number: ").append(this.columnNumber).append(EOL);
            sb.append("  Message: ").append(this.message).append(EOL);
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.columnNumber;
            result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
            result = 31 * result + this.lineNumber;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.publicID == null ? 0 : this.publicID.hashCode());
            result = 31 * result + (this.systemID == null ? 0 : this.systemID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ErrorMessage other = (ErrorMessage)obj;
            if (this.columnNumber != other.getColumnNumber()) {
                return false;
            }
            if (this.level == null ? other.getLevel() != null : !this.level.equals(other.getLevel())) {
                return false;
            }
            if (this.lineNumber != other.getLineNumber()) {
                return false;
            }
            if (this.message == null ? other.getMessage() != null : !this.message.equals(other.getMessage())) {
                return false;
            }
            if (this.publicID == null ? other.getPublicID() != null : !this.publicID.equals(other.getPublicID())) {
                return false;
            }
            return !(this.systemID == null ? other.getSystemID() != null : !this.systemID.equals(other.getSystemID()));
        }
    }
}

