/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.xsd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.xsd.AbstractXmlValidator;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.xml.XmlUtil;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlValidatorTest
extends AbstractXmlValidator {
    private static final Map<String, String> CACHE_DOXIA_TEST_DOCUMENTS = new Hashtable<String, String>();
    private static final String MAVEN_RESOURCE_PATH = "META-INF/maven/org.apache.maven.doxia/doxia-test-docs/";

    protected abstract String[] getIncludes();

    @Override
    protected Map<String, String> getTestDocuments() throws IOException {
        if (this.getIncludes() == null) {
            return Collections.emptyMap();
        }
        Map<String, String> testDocs = AbstractXmlValidatorTest.getAllTestDocuments();
        Hashtable<String, String> ret = new Hashtable<String, String>();
        ret.putAll(testDocs);
        for (String key : testDocs.keySet()) {
            for (int i = 0; i < this.getIncludes().length; ++i) {
                if (SelectorUtils.matchPath((String)this.getIncludes()[i], (String)key.toLowerCase(Locale.ENGLISH))) continue;
                ret.remove(key);
            }
        }
        return ret;
    }

    @Override
    protected EntityResolver getEntityResolver() {
        return new AbstractXmlParser.CachedFileEntityResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<String, String> getAllTestDocuments() throws IOException {
        if (CACHE_DOXIA_TEST_DOCUMENTS != null && !CACHE_DOXIA_TEST_DOCUMENTS.isEmpty()) {
            return Collections.unmodifiableMap(CACHE_DOXIA_TEST_DOCUMENTS);
        }
        URL testJar = AbstractXmlValidatorTest.class.getClassLoader().getResource(MAVEN_RESOURCE_PATH);
        if (testJar == null && (testJar = AbstractXmlValidatorTest.class.getClassLoader().getResource("doxia-site")) == null) {
            throw new RuntimeException("Could not find the Doxia test documents artefact i.e. doxia-test-docs-XXX.jar");
        }
        if (testJar.toString().startsWith("jar")) {
            JarURLConnection conn = (JarURLConnection)testJar.openConnection();
            JarFile jarFile = conn.getJarFile();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.getName().startsWith("META-INF") || entry.isDirectory()) continue;
                InputStream in = null;
                try {
                    in = AbstractXmlValidatorTest.class.getClassLoader().getResource(entry.getName()).openStream();
                    String content = IOUtil.toString((InputStream)in, (String)"UTF-8");
                    CACHE_DOXIA_TEST_DOCUMENTS.put("jar:" + conn.getJarFileURL() + "!/" + entry.getName(), content);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close((InputStream)in);
            }
        } else {
            File testDocsDir = FileUtils.toFile((URL)testJar).getParentFile();
            List files = FileUtils.getFiles((File)testDocsDir, (String)"**/*.*", (String)FileUtils.getDefaultExcludesAsString(), (boolean)true);
            Iterator it = files.iterator();
            while (it.hasNext()) {
                File file = new File(((File)it.next()).toString());
                if (file.getAbsolutePath().indexOf("META-INF") != -1) continue;
                Object reader = null;
                reader = XmlUtil.isXml((File)file) ? ReaderFactory.newXmlReader((File)file) : ReaderFactory.newReader((File)file, (String)"UTF-8");
                String content = IOUtil.toString((Reader)reader);
                CACHE_DOXIA_TEST_DOCUMENTS.put(file.toURI().toString(), content);
            }
        }
        return Collections.unmodifiableMap(CACHE_DOXIA_TEST_DOCUMENTS);
    }
}

